#ifndef _TIMIDITY_STRUCT_H
#define _TIMIDITY_STRUCT_H

typedef struct _tmdy_struct_ex_t tmdy_struct_ex_t;

#include "tmdy_struct_prv.h"
#include "timidity_main.h"
typedef struct _tmdy_amin_ex_t tmdy_maint_t;
typedef struct _output_ex_t output_ex_t;
typedef struct _aq_ex_t aq_ex_t;
typedef struct _controls_ex_t controls_ex_t;
typedef struct _instrum_ex_t instrum_ex_t;
typedef struct _resample_ex_t resample_ex_t;
typedef struct _readmidi_ex_t readmidi_ex_t;
typedef struct _playmidi_ex_t playmidi_ex_t;
typedef struct _common_ex_t common_ex_t;
typedef struct _filter_ex_t filter_ex_t;
typedef struct _mix_ex_t mix_ex_t;
typedef struct _sffile_ex_t sffile_ex_t;
typedef struct _freq_ex_t freq_ex_t;
typedef struct _mod_ex_t mod_ex_t;
typedef struct _mod2midi_ex_t mod2midi_ex_t;
typedef struct _m2m_ex_t m2m_ex_t;
typedef struct _miditrace_ex_t miditrace_ex_t;
typedef struct _wrd_ex_t wrd_ex_t;
typedef struct _recache_ex_t recache_ex_t;
typedef struct _quantity_ex_t quantity_ex_t;
typedef struct _reverb_ex_t reverb_ex_t;
typedef struct _rtsyn_ex_t rtsyn_ex_t;

#if defined(__MACOS__)
typedef int timidity_mutex_t;
#define timidity_mutex_init(_m)      { (_m) = 0; }
#define timidity_mutex_destroy(_m) 
#define timidity_mutex_lock(_m) 
#define timidity_mutex_unlock(_m) 
#elif defined(__W32__)
typedef HANDLE timidity_mutex_t;
#define timidity_mutex_init(_m)      { (_m) = CreateMutex(NULL, 0, NULL); }
#define timidity_mutex_destroy(_m)   if (_m) { CloseHandle(_m); }
#define timidity_mutex_lock(_m)      WaitForSingleObject(_m, INFINITE)
#define timidity_mutex_unlock(_m)    ReleaseMutex(_m)
#else
typedef pthread_mutex_t timidity_mutex_t;
#define timidity_mutex_init(_m)      pthread_mutex_init(&(_m), NULL)
#define timidity_mutex_destroy(_m)   pthread_mutex_destroy(&(_m))
#define timidity_mutex_lock(_m)      pthread_mutex_lock(&(_m))
#define timidity_mutex_unlock(_m)    pthread_mutex_unlock(&(_m))
#endif


struct _tmdy_struct_ex_t {
	timidity_mutex_t  busy;
	timidity_main_ex_t *timidity_main;
	output_ex_t *output;
	aq_ex_t *aq;
	controls_ex_t *controls;
	instrum_ex_t *instrum;
	resample_ex_t *resample;
	readmidi_ex_t *readmidi;
	playmidi_ex_t *playmidi;
	common_ex_t *common;
	filter_ex_t *filter;
	mix_ex_t *mix;
	sffile_ex_t *sffile;
	freq_ex_t *freq;
	mod_ex_t *mod;
	mod2midi_ex_t *mod2midi;
	m2m_ex_t *m2m;
	miditrace_ex_t *miditrace;
	wrd_ex_t *wrd;
	recache_ex_t *recache;
	quantity_ex_t *quantity;
	reverb_ex_t *reverb;
	rtsyn_ex_t *rtsyn;

};

extern tmdy_struct_ex_t *tmdy_struct;
#define REVERB tmdy_struct->reverb
#define RTSYN tmdy_struct->rtsyn


tmdy_struct_ex_t* new_tmdy_struct(void);
void destroy_tmdy_struct(tmdy_struct_ex_t* tmdy_struct);



#endif /* _TIMIDITY_STRUCT_H */
