/*      MikMod sound library
   (c) 1998, 1999 Miodrag Vallat and others - see file AUTHORS for
   complete list.

   This library is free software; you can redistribute it and/or modify
   it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
   02111-1307, USA.
 */

/*==============================================================================

  $Id: unimod_priv.h,v 1.23 1999/10/25 16:31:41 miod Exp $

  MikMod sound library internal definitions

==============================================================================*/

#ifndef _UNIMOD_PRIV_H
#define _UNIMOD_PRIV_H

#ifdef __cplusplus
extern "C"
{
#endif

#ifdef HAVE_MALLOC_H
#include <malloc.h>
#endif
#include <stdarg.h>
#if defined(__OS2__)||defined(__EMX__)||defined(__W32__)
#define strcasecmp(s,t) stricmp(s,t)
#endif

#include "unimod.h"
#include "url.h"

#ifdef __W32__
#pragma warning(disable:4761)
#endif

/*========== Error handling */

#define _mm_errno ML_errno

/*========== Memory allocation */

extern void *_mm_malloc (tmdy_struct_ex_t *tmdy_struct, size_t);
extern void *_mm_calloc (tmdy_struct_ex_t *tmdy_struct, size_t, size_t);
#define _mm_free(tmdy_struct, p) do { if (p) free(p); p = NULL; } while(0)

/*========== Portable file I/O */

#define _mm_read_SBYTE(tmdy_struct, x)	((SBYTE)TMDY_ARC->url->url_getc(tmdy_struct, x))
#define _mm_read_UBYTE(tmdy_struct, x)	((UBYTE)TMDY_ARC->url->url_getc(tmdy_struct, x))
#define _mm_read_SBYTES(tmdy_struct, x,y,z)	TMDY_ARC->url->url_nread(tmdy_struct, z,(void *)x,y)
#define _mm_read_UBYTES(tmdy_struct, x,y,z)	TMDY_ARC->url->url_nread(tmdy_struct, z,(void *)x,y)
#define _mm_fseek(tmdy_struct, x,y,z)	TMDY_ARC->url->url_seek(tmdy_struct, x,y,z)
#define _mm_ftell(tmdy_struct, x)		TMDY_ARC->url->url_tell(tmdy_struct, x)
#define _mm_eof(tmdy_struct, x)		TMDY_ARC->url->url_eof(tmdy_struct, x)
#define _mm_rewind(tmdy_struct, x)		_mm_fseek(tmdy_struct, x,0,SEEK_SET)

extern int _mm_read_string (tmdy_struct_ex_t *tmdy_struct, CHAR *, int, URL);

extern SWORD _mm_read_M_SWORD (tmdy_struct_ex_t *tmdy_struct, URL);
extern SWORD _mm_read_I_SWORD (tmdy_struct_ex_t *tmdy_struct, URL);
extern UWORD _mm_read_M_UWORD (tmdy_struct_ex_t *tmdy_struct, URL);
extern UWORD _mm_read_I_UWORD (tmdy_struct_ex_t *tmdy_struct, URL);

extern SLONG _mm_read_M_SLONG (tmdy_struct_ex_t *tmdy_struct, URL);
extern SLONG _mm_read_I_SLONG (tmdy_struct_ex_t *tmdy_struct, URL);
extern ULONG _mm_read_M_ULONG (tmdy_struct_ex_t *tmdy_struct, URL);
extern ULONG _mm_read_I_ULONG (tmdy_struct_ex_t *tmdy_struct, URL);

extern int _mm_read_M_SWORDS (tmdy_struct_ex_t *tmdy_struct, SWORD *, int, URL);
extern int _mm_read_I_SWORDS (tmdy_struct_ex_t *tmdy_struct, SWORD *, int, URL);
extern int _mm_read_M_UWORDS (tmdy_struct_ex_t *tmdy_struct, UWORD *, int, URL);
extern int _mm_read_I_UWORDS (tmdy_struct_ex_t *tmdy_struct, UWORD *, int, URL);

extern int _mm_read_M_SLONGS (tmdy_struct_ex_t *tmdy_struct, SLONG *, int, URL);
extern int _mm_read_I_SLONGS (tmdy_struct_ex_t *tmdy_struct, SLONG *, int, URL);
extern int _mm_read_M_ULONGS (tmdy_struct_ex_t *tmdy_struct, ULONG *, int, URL);
extern int _mm_read_I_ULONGS (tmdy_struct_ex_t *tmdy_struct, ULONG *, int, URL);


/*========== Loaders */

typedef struct MLOADER
{
  struct MLOADER *next;
  CHAR *type;
  CHAR *version;
  BOOL (*Init) (tmdy_struct_ex_t *tmdy_struct);
  BOOL (*Test) (tmdy_struct_ex_t *tmdy_struct);
  BOOL (*Load) (tmdy_struct_ex_t *tmdy_struct, BOOL);
  void (*Cleanup) (tmdy_struct_ex_t *tmdy_struct);
  CHAR *(*LoadTitle) (tmdy_struct_ex_t *tmdy_struct);
}
MLOADER;

/* internal loader variables: */
extern URL modreader;
extern UWORD finetune[16];
extern MODULE of;		/* static unimod loading space */

extern SBYTE remap[64];	/* for removing empty channels */
extern UBYTE *poslookup;	/* lookup table for pattern jumps after
				 blank pattern removal */
extern UBYTE poslookupcnt;
extern UWORD *origpositions;

extern BOOL filters;		/* resonant filters in use */
extern UBYTE activemacro;	/* active midi macro number for Sxx */
extern UBYTE filtermacros[16];	/* midi macros settings */
extern FILTER filtersettings[256];	/* computed filter settings */

extern int *noteindex;

/* tracker identifiers */
#define STM_NTRACKERS 3
extern CHAR *STM_Signatures[];
extern CHAR *STM_Version[];


/*========== Internal loader interface */

extern BOOL ReadComment (tmdy_struct_ex_t *tmdy_struct, UWORD);
extern BOOL ReadLinedComment (tmdy_struct_ex_t *tmdy_struct, UWORD, UWORD);
extern BOOL AllocPositions (tmdy_struct_ex_t *tmdy_struct, int);
extern BOOL AllocPatterns (tmdy_struct_ex_t *tmdy_struct);
extern BOOL AllocTracks (tmdy_struct_ex_t *tmdy_struct);
extern BOOL AllocInstruments (tmdy_struct_ex_t *tmdy_struct);
extern BOOL AllocSamples (tmdy_struct_ex_t *tmdy_struct);
extern CHAR *DupStr (tmdy_struct_ex_t *tmdy_struct, CHAR *, UWORD, BOOL);

/* loader utility functions */
extern int *AllocLinear (tmdy_struct_ex_t *tmdy_struct);
extern void FreeLinear (tmdy_struct_ex_t *tmdy_struct);
extern int speed_to_finetune (tmdy_struct_ex_t *tmdy_struct, ULONG, int);
extern void S3MIT_ProcessCmd (tmdy_struct_ex_t *tmdy_struct, UBYTE, UBYTE, BOOL);
extern void S3MIT_CreateOrders (tmdy_struct_ex_t *tmdy_struct, BOOL);


/*
* fllowings are External interfaces *
*/
/*========== Internal module representation (UniMod) interface */
extern void UniSetRow (tmdy_struct_ex_t *tmdy_struct, UBYTE *);
extern UBYTE UniGetByte (tmdy_struct_ex_t *tmdy_struct);
extern UWORD UniGetWord (tmdy_struct_ex_t *tmdy_struct);
extern UBYTE *UniFindRow (tmdy_struct_ex_t *tmdy_struct, UBYTE *, UWORD);
extern void UniSkipOpcode (tmdy_struct_ex_t *tmdy_struct, UBYTE);
extern void UniReset (tmdy_struct_ex_t *tmdy_struct);
extern void UniWriteByte (tmdy_struct_ex_t *tmdy_struct, UBYTE);
extern void UniWriteWord (tmdy_struct_ex_t *tmdy_struct, UWORD);
extern void UniNewline (tmdy_struct_ex_t *tmdy_struct);
extern UBYTE *UniDup (tmdy_struct_ex_t *tmdy_struct);
extern BOOL UniInit (tmdy_struct_ex_t *tmdy_struct);
extern void UniCleanup (tmdy_struct_ex_t *tmdy_struct);
extern void UniEffect (tmdy_struct_ex_t *tmdy_struct, UWORD, UWORD);
extern void UniPTEffect (tmdy_struct_ex_t *tmdy_struct, UBYTE, UBYTE);
extern void UniVolEffect (tmdy_struct_ex_t *tmdy_struct, UWORD, UBYTE);
/* used to convert c4spd to linear XM periods (IT and IMF loaders). */
extern UWORD getlinearperiod (tmdy_struct_ex_t *tmdy_struct, UWORD, ULONG);
extern UWORD getlogperiod (tmdy_struct_ex_t *tmdy_struct, UWORD note, ULONG fine);
extern UWORD getoldperiod (tmdy_struct_ex_t *tmdy_struct, UWORD, ULONG);
extern ULONG getfrequency (tmdy_struct_ex_t *tmdy_struct, UBYTE, ULONG);
extern ULONG getAmigaPeriod (tmdy_struct_ex_t *tmdy_struct, UBYTE, ULONG);
/*    ========== External interface   */
extern UWORD finetune[];
extern BOOL ML_8bitsamples;
extern BOOL ML_monosamples;
extern CHAR *ML_InfoLoader (tmdy_struct_ex_t *tmdy_struct);
extern void ML_RegisterAllLoaders (tmdy_struct_ex_t *tmdy_struct);
extern BOOL ML_Test (tmdy_struct_ex_t *tmdy_struct, URL);
extern MODULE *ML_Load (tmdy_struct_ex_t *tmdy_struct, URL, int, BOOL);
extern CHAR *ML_LoadTitle (tmdy_struct_ex_t *tmdy_struct, URL);
extern void ML_Free (tmdy_struct_ex_t *tmdy_struct, MODULE *);



#ifdef __cplusplus
}
#endif

#endif

/* ex:set ts=4: */
