#ifndef _TIMIDITY_STRUCT_H
#define _TIMIDITY_STRUCT_H

typedef struct _tmdy_struct_ex_t tmdy_struct_ex_t;

#ifdef __W32__
#include <windows.h>
#endif
#include "tmdy_struct_prv.h"


typedef struct _timidity_main_ex_t timidity_main_ex_t;
typedef struct _output_ex_t output_ex_t;
typedef struct _aq_ex_t aq_ex_t;
typedef struct _controls_ex_t controls_ex_t;
typedef struct _instrum_ex_t instrum_ex_t;
typedef struct _resample_ex_t resample_ex_t;
typedef struct _readmidi_ex_t readmidi_ex_t;
typedef struct _playmidi_ex_t playmidi_ex_t;
typedef struct _common_ex_t common_ex_t;
typedef struct _filter_ex_t filter_ex_t;
typedef struct _mix_ex_t mix_ex_t;
typedef struct _sffile_ex_t sffile_ex_t;
typedef struct _freq_ex_t freq_ex_t;
typedef struct _mod_ex_t mod_ex_t;
typedef struct _mod2midi_ex_t mod2midi_ex_t;
typedef struct _m2m_ex_t m2m_ex_t;
typedef struct _miditrace_ex_t miditrace_ex_t;
typedef struct _wrd_ex_t wrd_ex_t;
typedef struct _recache_ex_t recache_ex_t;
typedef struct _quantity_ex_t quantity_ex_t;
typedef struct _reverb_ex_t reverb_ex_t;
typedef struct _rtsyn_ex_t rtsyn_ex_t;
typedef struct _utils_ex_t utils_ex_t;
typedef struct _libunimod_ex_t libunimod_ex_t;
typedef struct _libarc_ex_t libarc_ex_t;

#if defined(__MACOS__)
typedef int timidity_mutex_t;
#define timidity_mutex_init(_m)      { (_m) = 0; }
#define timidity_mutex_destroy(_m) 
#define timidity_mutex_lock(_m) 
#define timidity_mutex_unlock(_m) 
#elif defined(__W32__)
/*
typedef HANDLE timidity_mutex_t;
#define timidity_mutex_init(_m)      { (_m) = CreateMutex(NULL, 0, NULL); }
#define timidity_mutex_destroy(_m)   if (_m) { CloseHandle(_m); }
#define timidity_mutex_lock(_m)      WaitForSingleObject(_m, INFINITE)
#define timidity_mutex_unlock(_m)    ReleaseMutex(_m)
*/
typedef CRITICAL_SECTION  timidity_mutex_t;
#define timidity_mutex_init(_m)	InitializeCriticalSection(&_m)
#define timidity_mutex_destroy(_m) DeleteCriticalSection(&_m)
#define timidity_mutex_lock(_m)    EnterCriticalSection(&_m)
#define timidity_mutex_unlock(_m)  LeaveCriticalSection(&_m)
#else
typedef pthread_mutex_t timidity_mutex_t;
#define timidity_mutex_init(_m)      pthread_mutex_init(&(_m), NULL)
#define timidity_mutex_destroy(_m)   pthread_mutex_destroy(&(_m))
#define timidity_mutex_lock(_m)      pthread_mutex_lock(&(_m))
#define timidity_mutex_unlock(_m)    pthread_mutex_unlock(&(_m))
#endif


struct _tmdy_struct_ex_t {
	timidity_mutex_t  busy;
	timidity_main_ex_t *timidity_main;
	output_ex_t *output;
	aq_ex_t *aq;
	controls_ex_t *controls;
	instrum_ex_t *instrum;
	resample_ex_t *resample;
	readmidi_ex_t *readmidi;
	playmidi_ex_t *playmidi;
	common_ex_t *common;
	filter_ex_t *filter;
	mix_ex_t *mix;
	sffile_ex_t *sffile;
	freq_ex_t *freq;
	mod_ex_t *mod;
	mod2midi_ex_t *mod2midi;
	m2m_ex_t *m2m;
	miditrace_ex_t *miditrace;
	wrd_ex_t *wrd;
	recache_ex_t *recache;
	quantity_ex_t *quantity;
	reverb_ex_t *reverb;
	rtsyn_ex_t *rtsyn;
	utils_ex_t *utils;
	libunimod_ex_t *libunimod;
	libarc_ex_t *libarc;

};
#define TMDY_MAIN tmdy_struct->timidity_main
#define TMDY_OUTPUT tmdy_struct->output
#define TMDY_AQ tmdy_struct->aq
#define TMDY_CONTROLS tmdy_struct->controls
#define TMDY_INSTRUM tmdy_struct->instrum
#define TMDY_RESAMPLE tmdy_struct->resample
#define TMDY_READMIDI tmdy_struct->readmidi
#define TMDY_PLAYMIDI tmdy_struct->playmidi
#define TMDY_COMMON tmdy_struct->common
#define TMDY_FILTER tmdy_struct->filter
#define TMDY_MIX tmdy_struct->mix
#define TMDY_SFFILE tmdy_struct->sffile
#define TMDY_FREQ tmdy_struct->freq
#define TMDY_MOD tmdy_struct->mod
#define TMDY_MOD2MIDI tmdy_struct->mod2midi
#define TMDY_M2M tmdy_struct->m2m
#define TMDY_MIDITRACE tmdy_struct->miditrace
#define TMDY_WRD tmdy_struct->wrd
#define TMDY_RECACHE tmdy_struct->recache
#define TMDY_QUANTITY tmdy_struct->quantity
#define TMDY_REVERB tmdy_struct->reverb
#define TMDY_RTSYN tmdy_struct->rtsyn
#define TMDY_UTILS tmdy_struct->utils
#define TMDY_UNIMOD tmdy_struct->libunimod
#define TMDY_ARC tmdy_struct->libarc


extern tmdy_struct_ex_t *tmdy_struct;

tmdy_struct_ex_t* new_tmdy_struct(void);
void destroy_tmdy_struct(tmdy_struct_ex_t* tmdy_struct);

#include "utils_export.h"
#include "arc_export.h"


#endif /* _TIMIDITY_STRUCT_H */
