
#ifndef _TIMIDITY_SYNTH_H
#define _TIMIDITY_SYNTH_H


#ifdef __cplusplus
extern "C" {
#endif

TIMIDITY_API tmdy_synth_t* new_tmdy_synth(void);
TIMIDITY_API int delete_tmdy_synth(tmdy_synth_t* synth);

TIMIDITY_API int tmdy_synth_noteon(tmdy_synth_t* synth, int chan, int key, int vel);
TIMIDITY_API int tmdy_synth_noteoff(tmdy_synth_t* synth, int chan, int key);
TIMIDITY_API int tmdy_synth_cc(tmdy_synth_t* synth, int chan, int ctrl, int val);
TIMIDITY_API int tmdy_synth_pitch_bend(tmdy_synth_t* synth, int chan, int val);
TIMIDITY_API 
int tmdy_synth_get_pitch_bend(tmdy_synth_t* synth, int chan, int* ppitch_bend);
TIMIDITY_API int tmdy_synth_pitch_wheel_sens(tmdy_synth_t* synth, int chan, int val);
TIMIDITY_API int tmdy_synth_program_change(tmdy_synth_t* synth, int chan, int program);
TIMIDITY_API 
int tmdy_synth_bank_select(tmdy_synth_t* synth, int chan, unsigned int bank);
TIMIDITY_API int tmdy_synth_program_reset(tmdy_synth_t* synth);
TIMIDITY_API int tmdy_synth_system_reset(tmdy_synth_t* synth);
enum{ REVERB_DISABLE, REVERB_NORMAL, REVERB_GLOBAL, REVERB_FREEVERB };
TIMIDITY_API void tmdy_synth_set_reverb(tmdy_synth_t* synth,int type,int value);
enum{ CHORUS_DISABLE, CHORUS_NORMAL, CHORUS_SURROUND };
TIMIDITY_API	void tmdy_synth_set_chorus(tmdy_synth_t* synth,int type,int value,int degree);
TIMIDITY_API void tmdy_synth_set_gain(tmdy_synth_t* synth, float gain);
TIMIDITY_API float tmdy_synth_get_gain(tmdy_synth_t* synth);
TIMIDITY_API void tmdy_synth_set_drum_gain(tmdy_synth_t* synth, float gain);
TIMIDITY_API float tmdy_synth_get_drum_gain(tmdy_synth_t* synth);
/*	
enum {
	RESAMPLE_CSPLINE,
	RESAMPLE_LAGRANGE,
	RESAMPLE_GAUSS,
	RESAMPLE_NEWTON,
	RESAMPLE_LINEAR,
	RESAMPLE_NONE
};
*/
TIMIDITY_API int tmdy_synth_set_interp_method(tmdy_synth_t* synth,int type,int val);
TIMIDITY_API int tmdy_synth_get_interp_method(tmdy_synth_t* synth);

TIMIDITY_API void tmdy_synth_add_soundfont(tmdy_synth_t* synth, char *sf_file, int sf_order,
			  int cutoff_allowed, int resonance_allowed,
				int amp);
	
TIMIDITY_API void tmdy_synth__remove_soundfont(tmdy_synth_t* synth, char *sf_file);

TIMIDITY_API void tmdy_synth_init_load_soundfont(tmdy_synth_t* synth);

TIMIDITY_API int tmdy_synth_set_output(tmdy_synth_t* synth, char mode, __int32 encoding );
TIMIDITY_API char* tmdy_synth_get_output_mode_list(tmdy_synth_t* synth);
TIMIDITY_API char tmdy_synth_get_output_mode(tmdy_synth_t* synth);
TIMIDITY_API __int32 tmdy_synth_get_output_encoding(tmdy_synth_t* synth);

#ifdef __cplusplus
}
#endif

#endif /* _TIMIDITY_SYNTH_H */
