/* FluidSynth - A Software Synthesizer
 *
 * Copyright (C) 2003  Peter Hanappe and others.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public License
 * as published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *  
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 * 02111-1307, USA
 */


#ifndef _TIMIDITYSYNTH_PRIV_H
#define _TIMIDITYSYNTH_PRIV_H

#if HAVE_CONFIG_H
#include "config.h"
#endif

#if defined(WIN32) && !defined(MINGW32)
#include "config_win32.h"
#endif

#if HAVE_STRING_H
#include <string.h>
#endif

#if HAVE_STDLIB_H
#include <stdlib.h>
#endif

#if HAVE_STDIO_H
#include <stdio.h>
#endif

#if HAVE_MATH_H
#include <math.h>
#endif

#if HAVE_ERRNO_H
#include <errno.h>
#endif

#if HAVE_STDARG_H
#include <stdarg.h>
#endif

#if HAVE_UNISTD_H
#include <unistd.h>
#endif

#if HAVE_FCNTL_H
#include <fcntl.h>
#endif

#if HAVE_SYS_MMAN_H
#include <sys/mman.h>
#endif

#if HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif

#if HAVE_SYS_STAT_H
#include <sys/stat.h>
#endif

#if HAVE_SYS_TIME_H
#include <sys/time.h>
#endif

#if HAVE_SYS_SOCKET_H
#include <sys/socket.h>
#endif

#if HAVE_NETINET_IN_H
#include <netinet/in.h>
#endif

#if HAVE_NETINET_TCP_H
#include <netinet/tcp.h>
#endif

#if HAVE_ARPA_INET_H
#include <arpa/inet.h>
#endif

#if HAVE_LIMITS_H
#include <limits.h>
#endif

#if HAVE_PTHREAD_H
#include <pthread.h>
#endif

#if HAVE_IO_H
#include <io.h>
#endif

#if HAVE_WINDOWS_H
#include <windows.h>
#endif

/* MinGW32 special defines */
#ifdef MINGW32

#include <stdint.h>
#define snprintf _snprintf
#define vsnprintf _vsnprintf

//#define DSOUND_SUPPORT 1
//#define PORTAUDIO_SUPPORT 1
#define WINMIDI_SUPPORT 1
#define STDIN_FILENO 0
#define STDOUT_FILENO 1
#define STDERR_FILENO 2
#define WITHOUT_SERVER 1

#endif

/* Darwin special defines (taken from config_macosx.h) */
#ifdef DARWIN
#define MACINTOSH
#define __Types__
#define WITHOUT_SERVER 1
#endif


#include "timidity_dll.h"


/***************************************************************
 *
 *         BASIC TYPES
 */

#ifndef SYSDEP_H_INCLUDED
#include "sysdep.h"
#endif

#if defined(WITH_FLOAT)
typedef float tmdy_real_t;
#else
typedef double tmdy_real_t;
#endif


typedef enum {
  TIMIDITY_OK = 0,
  TIMIDITY_FAILED = -1
} tmdy_status;


#if defined(WIN32)
typedef SOCKET tmdy_socket_t;
#else
typedef int tmdy_socket_t;
#define INVALID_SOCKET -1
#endif


/** Integer types  */

#if defined(MINGW32)

/* Windows using MinGW32 */
typedef int8_t             sint8;
//typedef uint8_t            uint8;
typedef int16_t            sint16;
//typedef uint16_t           uint16;
typedef int32_t            sint32;
//typedef uint32_t           uint32;
typedef int64_t            sint64;
//typedef uint64_t           uint64;

#elif defined(_WIN32)

/* Windows */
typedef signed __int8      sint8;
//typedef unsigned __int8    uint8;
typedef signed __int16     sint16;
//typedef unsigned __int16   uint16;
typedef signed __int32     sint32;
//typedef unsigned __int32   uint32;
typedef signed __int64     sint64;
//typedef unsigned __int64   uint64;

#elif defined(MACOS9)

/* Macintosh */
typedef signed char        sint8;
//typedef unsigned char      uint8;
typedef signed short       sint16;
//typedef unsigned short     uint16;
typedef signed int         sint32;
//typedef unsigned int       uint32;
/* FIXME: needs to be verified */
typedef long long          sint64;
//typedef unsigned long long uint64;

#else 

/* Linux & Darwin */
typedef int8_t             sint8;
//typedef u_int8_t           uint8;
typedef int16_t            sint16;
//typedef u_int16_t          uint16;
typedef int32_t            sint32;
//typedef u_int32_t          uint32;
typedef int64_t            sint64;
//typedef u_int64_t          uint64;

#endif

/***************************************************************
 *
 *       FORWARD DECLARATIONS 
 */
typedef struct _tmdy_env_data_t tmdy_env_data_t;
typedef struct _tmdy_adriver_definition_t tmdy_adriver_definition_t;
typedef struct _tmdy_channel_t tmdy_channel_t;
typedef struct _tmdy_tuning_t tmdy_tuning_t;
typedef struct _tmdy_hashtable_t  tmdy_hashtable_t;
typedef struct _tmdy_client_t tmdy_client_t;
typedef struct _tmdy_server_socket_t tmdy_server_socket_t;

/***************************************************************
 *
 *                      CONSTANTS 
 */

#define TIMIDITY_BUFSIZE                64

#ifndef PI
#define PI                          3.141592654
#endif

/***************************************************************
 *
 *                      SYSTEM INTERFACE
 */
typedef FILE*  tmdy_file;

#define TIMIDITY_MALLOC(_n)             malloc(_n)
#define TIMIDITY_REALLOC(_n)            realloc(_p,_n)
#define TIMIDITY_NEW(_t)                (_t*)malloc(sizeof(_t))
#define TIMIDITY_ARRAY(_t,_n)           (_t*)malloc((_n)*sizeof(_t))
#define TIMIDITY_FREE(_p)               free(_p)
#define TIMIDITY_FOPEN(_f,_m)           fopen(_f,_m)
#define TIMIDITY_FCLOSE(_f)             fclose(_f)
#define TIMIDITY_FREAD(_p,_s,_n,_f)     fread(_p,_s,_n,_f)
#define TIMIDITY_FSEEK(_f,_n,_set)      fseek(_f,_n,_set)
#define TIMIDITY_MEMCPY(_dst,_src,_n)   memcpy(_dst,_src,_n)
#define TIMIDITY_MEMSET(_s,_c,_n)       memset(_s,_c,_n)
#define TIMIDITY_STRLEN(_s)             strlen(_s)                  
#define TIMIDITY_STRCMP(_s,_t)          strcmp(_s,_t)
#define TIMIDITY_STRNCMP(_s,_t,_n)      strncmp(_s,_t,_n)
#define TIMIDITY_STRCPY(_dst,_src)      strcpy(_dst,_src)
#define TIMIDITY_STRCHR(_s,_c)          strchr(_s,_c)
#ifdef strdup
#define TIMIDITY_STRDUP(s)              strdup(s)
#else
#define TIMIDITY_STRDUP(s) 		    TIMIDITY_STRCPY(TIMIDITY_MALLOC(TIMIDITY_STRLEN(s) + 1), s)
#endif 
#define TIMIDITY_SPRINTF                sprintf
#define TIMIDITY_FPRINTF                fprintf

#define tmdy_clip(_val, _min, _max) \
{ (_val) = ((_val) < (_min))? (_min) : (((_val) > (_max))? (_max) : (_val)); }

/* Purpose:
 * Some commands (SSE extensions on Pentium) need aligned data(
 * The address must be ...xxx0. 
 * Take a pointer, and round it up to the next suitable address.
 * Obviously, one has to allocate 15 bytes of additional memory.
 * As soon as proper alignment is supported by the compiler, this
 * can be removed.
 */
#define TIMIDITY_ALIGN16BYTE(ptr)(((int)(ptr)+15) & (~0xFL))

#if WITH_FTS
#define TIMIDITY_PRINTF                 post
#define TIMIDITY_FLUSH()                
#else
#define TIMIDITY_PRINTF                 printf
#define TIMIDITY_FLUSH()                fflush(stdout)
#endif

#define TIMIDITY_LOG                    tmdy_log

#ifndef M_PI
#define M_PI 3.1415926535897932384626433832795
#endif


#define TIMIDITY_ASSERT(a,b)
#define TIMIDITY_ASSERT_P(a,b)

char* tmdy_error(void);


/* Internationalization */
#define _(s) s


#endif /* _TIMIDITYSYNTH_PRIV_H */
