/*
    TiMidity++ -- MIDI to WAVE converter and player
    Copyright (C) 1999-2002 Masanao Izumo <mo@goice.co.jp>
    Copyright (C) 1995 Tuukka Toivonen <tt@cgs.fi>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    m2m.h 
*/

#ifndef ___M2M_H_
#define ___M2M_H_

/**** private definitions ****/
#define MAX_PB_SENSITIVITY 24
#define ROUND(frac)			(floor(frac + 0.5))

/**** main struct *****/
struct _m2m_ex_t {
	timidity_mutex_t  busy;

void (*convert_mod_to_midi_file)(tmdy_struct_ex_t* tmdy_struct, MidiEvent * ev);

/**** private variables ****/

char *outname;
char *actual_outname;
char *cfgname;

unsigned char header[14];

unsigned char mtrk[4];
unsigned char event[11];
unsigned char dt_array[4];
unsigned char *track_events[34];
unsigned char *p_track_event;
uint32 last_track_event_time[34];
uint32 track_size[34];
int tracks_enabled[34];
int tracks_useless[34];
int current_track_sample[34];
int orig_track_expr[34];
int current_channel_expr[34];
int current_channel_bank[34];
int current_channel_program[34];
int current_channel_note[34];
int current_track_note[34];
int track_pans[34];
uint32 kill_early_time[34];
int kill_early_note[34];
int kill_early_velocity[34];
int kill_early_ch[34];
int tweak_note_offset[34];
int tweak_pb_offset[34];

uint32 length;
uint16 divisions, orig_divisions;
double divisions_ratio;
int num_dt_bytes;
int32 value;
int num_tracks;
int32 tempo;
uint32 maxtime;
uint32 num_killed_early;
uint32 num_big_pitch_slides;
uint32 num_huge_pitch_slides;
int pb_sensitivity;
int old_pb_sensitivity;
float notes_per_pb;
float pb_per_note;
int rpn_msb, rpn_lsb;
int min_enabled_track;
int max_enabled_track, first_free_track;
int non_drums_on_drums;

int silent_samples[256];
int sample_chords[256];
int sample_to_program[256];
int banks[256];
int transpose[256];
int is_drum_sample[256];
int vol_amp[256];
char linestring[256];
int fine_tune[256];

double samples_per_tick;
int maxsample;
char chord_letters[4];

/* mod volumes are linear, midi volumes are x^1.66 (for generic hardware)
 * scale the mod volumes so they sound linear on non-linear midi devices
 * EXPRESSION events are the new corrected volume levels
 * MAINVOLUME events fine tune the volume correction
 *
 * lookup_table[mod_vol][expression, volume]
 */
char vol_nonlin_to_lin[128][2];

};


m2m_ex_t* new_m2m(tmdy_struct_ex_t *tmdy_struct);
void destroy_m2m(m2m_ex_t* m2m);

#endif /* ___M2M_H_ */
