/*
    TiMidity++ -- MIDI to WAVE converter and player
    Copyright (C) 1999-2002 Masanao Izumo <mo@goice.co.jp>
    Copyright (C) 1995 Tuukka Toivonen <tt@cgs.fi>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef ___RECACHE_H_
#define ___RECACHE_H_

struct cache_hash
{
    /* cache key */
    int note;
    Sample *sp;

    int32 cnt;			/* counter */
    double r;			/* size/refcnt */
    struct _Sample *resampled;
    struct cache_hash *next;
};

/**** private definitions ****/
#define HASH_TABLE_SIZE 251
#define MIXLEN 256

#define MIN_LOOPSTART MIXLEN
#define MIN_LOOPLEN   1024
#define MAX_EXPANDLEN (1024*32)


#define CACHE_RESAMPLING_OK	0
#define CACHE_RESAMPLING_NOTOK	1
typedef struct
{
    int32 on[128];
    struct cache_hash *cache[128];
}channel_note_table_t;

/**** main struct *****/

struct _recache_ex_t {
	timidity_mutex_t  busy;
	int32 allocate_cache_size;

	void (*resamp_cache_reset)(tmdy_struct_ex_t *tmdy_struct);
	void (*resamp_cache_refer_on)(tmdy_struct_ex_t *tmdy_struct, Voice *vp, int32 sample_start);
	void (*resamp_cache_refer_off)(tmdy_struct_ex_t *tmdy_struct, int ch, int note, int32 sample_end);
	void (*resamp_cache_refer_alloff)(tmdy_struct_ex_t *tmdy_struct, int ch, int32 sample_end);
	void (*resamp_cache_create)(tmdy_struct_ex_t *tmdy_struct);
	struct cache_hash *(*resamp_cache_fetch)(tmdy_struct_ex_t *tmdy_struct, struct _Sample *sp, int note);

	/**** private variables ****/
	sample_t *cache_data;

	splen_t cache_data_len;
	struct cache_hash *cache_hash_table[HASH_TABLE_SIZE];
	MBlockList hash_entry_pool;
	channel_note_table_t channel_note_table[MAX_CHANNELS];
};


recache_ex_t* new_recache(tmdy_struct_ex_t *tmdy_struct);
void destroy_recache(recache_ex_t* recache);



#endif /* ___RECACHE_H_ */
