/*
    TiMidity++ -- MIDI to WAVE converter and player
    Copyright (C) 1999-2002 Masanao Izumo <mo@goice.co.jp>
    Copyright (C) 1995 Tuukka Toivonen <tt@cgs.fi>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/*
 * REVERB EFFECT FOR TIMIDITY++-1.X (Version 0.06e  1999/1/28)
 *
 * Copyright (C) 1997,1998,1999  Masaki Kiryu <mkiryu@usa.net>
 *                           (http://w3mb.kcom.ne.jp/~mkiryu/)
 *
 * reverb.h
 *
 */
#ifndef ___REVERB_H_
#define ___REVERB_H_

#define DEFAULT_REVERB_SEND_LEVEL 40

//extern int opt_reverb_control;


enum {
	EFFECT_NONE,
	EFFECT_EQ2,
	EFFECT_OVERDRIVE1,
	EFFECT_DISTORTION1,
	EFFECT_OD1OD2,
};

#define MAGIC_INIT_EFFECT_INFO -1

typedef struct _EffectList {
	int8 type;
	void *info;	/* private effect information struct */
	void (*do_effect)(tmdy_struct_ex_t *tmdy_struct, int32 *, int32, struct _EffectList *);
	struct _EffectList *next_ef;
} EffectList;


/*! general purpose 2-band equalizer information. */
struct InfoEQ2
{
    int16 low_freq;		/* in Hz */
	int16 high_freq;	/* in Hz */
	int16 low_gain;		/* in dB */
	int16 high_gain;	/* in dB */

	/* for highpass shelving filter */
	int32 high_coef[5];
	int32 high_val[8];
	/* for lowpass shelving filter */
	int32 low_coef[5];
	int32 low_val[8];
};
/* GS parameters of delay effect */
struct delay_status_t
{
	/* GS parameters */
	uint8 type;
	uint8 level;
    uint8 level_center;
    uint8 level_left;
    uint8 level_right;
    double time_center;			/* in ms */
    double time_ratio_left;		/* in pct */
    double time_ratio_right;	/* in pct */
    uint8 feedback;
	uint8 pre_lpf;
	uint8 send_reverb;

	/* for pre-calculation */
	int32 sample_c;
	int32 sample_l;
	int32 sample_r;
	double level_ratio_c;
	double level_ratio_l;
	double level_ratio_r;
	double feedback_ratio;
	double send_reverb_ratio;

	/* for (negative) highpass shelving filter */
	int32 high_coef[5];
	int32 high_val[8];
};

/* GS parameters of reverb effect */
struct reverb_status_t
{
	/* GS parameters */
	uint8 character;
	uint8 pre_lpf;
	uint8 level;
	uint8 time;
	uint8 delay_feedback;
	uint8 pre_delay_time;	/* in ms */

	/* for pre-calculation */
	double level_ratio;
	double time_ratio;

	/* for (negative) highpass shelving filter */
	int32 high_coef[5];
	int32 high_val[8];
};

/* GS parameters of chorus effect */
struct chorus_param_t
{
	/* GS parameters */
	uint8 chorus_macro;
	uint8 chorus_pre_lpf;
	uint8 chorus_level;
	uint8 chorus_feedback;
	uint8 chorus_delay;
	uint8 chorus_rate;
	uint8 chorus_depth;
	uint8 chorus_send_level_to_reverb;
	uint8 chorus_send_level_to_delay;

	/* for pre-calculation */
	double level_ratio;
	double feedback_ratio;
	double send_reverb_ratio;
	double send_delay_ratio;
	int32 cycle_in_sample;
	int32 depth_in_sample;
	int32 delay_in_sample;

	/* for (negative) highpass shelving filter */
	int32 high_coef[5];
	int32 high_val[8];
};

/* GS parameters of channel EQ */
struct eq_status_t
{
	/* GS parameters */
    uint8 low_freq;
	uint8 high_freq;
	uint8 low_gain;
	uint8 high_gain;

	/* for highpass shelving filter */
	int32 high_coef[5];
	int32 high_val[8];

	/* for lowpass shelving filter */
	int32 low_coef[5];
	int32 low_val[8];
};

struct GSInsertionEffect {
	int32 type;
	int8 type_lsb, type_msb, parameter[20], send_reverb,
		send_chorus, send_delay, control_source1, control_depth1,
		control_source2, control_depth2, send_eq_switch;
	struct _EffectList *ef;
} gs_ieffect;

/* see also readmidi.c */
struct chorus_status_t
{
    int status;
    uint8 voice_reserve[18];
    uint8 macro[3];
    uint8 pre_lpf[3];
    uint8 level[3];
    uint8 feed_back[3];
    uint8 delay[3];
    uint8 rate[3];
    uint8 depth[3];
    uint8 send_level[3];
};

/**** private defs ****/

/* delay buffers @65kHz */
#define REV_BUF0       344 * 2
#define REV_BUF1       684 * 2
#define REV_BUF2      2868 * 2
#define REV_BUF3      1368 * 2

#define REV_VAL0         5.3
#define REV_VAL1        10.5
#define REV_VAL2        44.12
#define REV_VAL3        21.0

#if OPT_MODE != 0
#define REV_FBK_LEV      TIM_FSCALE(0.12, 24)

#define REV_NMIX_LEV     0.7
#define REV_CMIX_LEV     TIM_FSCALE(0.9, 24)
#define REV_MONO_LEV     0.7

#define REV_HPF_LEV      TIM_FSCALE(0.5, 24)
#define REV_LPF_LEV      TIM_FSCALE(0.45, 24)
#define REV_LPF_INP      TIM_FSCALE(0.55, 24)
#define REV_EPF_LEV      TIM_FSCALE(0.4, 24)
#define REV_EPF_INP      TIM_FSCALE(0.48, 24)

#define REV_WIDTH        TIM_FSCALE(0.125, 24)
#else
#define REV_FBK_LEV      0.12

#define REV_NMIX_LEV     0.7
#define REV_CMIX_LEV     0.9
#define REV_MONO_LEV     0.7

#define REV_HPF_LEV      0.5
#define REV_LPF_LEV      0.45
#define REV_LPF_INP      0.55
#define REV_EPF_LEV      0.4
#define REV_EPF_INP      0.48

#define REV_WIDTH        0.125
#endif

#ifdef USE_DSP_EFFECT
#define DELAY_BUFFER_SIZE 48000 + 1
#endif /* USE_DSP_EFFECT */

#ifdef USE_DSP_EFFECT
#define CHORUS_BUFFER_SIZE 9600
#endif /* USE_DSP_EFFECT */

#define numcombs 8
#define numallpasses 4
#define scalewet 0.06f
#define scaledamp 0.4f
#define scaleroom 0.28f
#define offsetroom 0.7f
#define initialroom 0.5f
#define initialdamp 0.5f
#define initialwet 1 / scalewet
#define initialdry 0
#define initialwidth 0.5f
#define initialallpassfbk 0.65f
#define stereospread 23
#define fixedgain 0.025f
/* allpass filter */
typedef struct _allpass {
	int32 *buf;
	int32 size;
	int32 index;
	double feedback;
	int32 feedbacki;
} allpass;
/* comb filter */
typedef struct _comb {
	int32 *buf;
	int32 filterstore;
	int32 size;
	int32 index;
	double feedback;
	double damp1;
	double damp2;
	int32 feedbacki;
	int32 damp1i;
	int32 damp2i;
} comb;
typedef struct _revmodel_t {
	double roomsize, roomsize1;
	double damp, damp1;
	double wet, wet1, wet2;
	double width;
	comb combL[numcombs];
	comb combR[numcombs];
	allpass allpassL[numallpasses];
	allpass allpassR[numallpasses];
	int32 wet1i, wet2i;
} revmodel_t;

/**** main struct ****/
struct _reverb_ex_t {
	timidity_mutex_t  busy;
	
int opt_effect_quality;
	
void (*convert_effect)(tmdy_struct_ex_t *tmdy_struct, EffectList *);
EffectList *(*push_effect)(tmdy_struct_ex_t *tmdy_struct, EffectList *, int8, void *);
void (*do_effect_list)(tmdy_struct_ex_t *tmdy_struct, int32 *, int32, EffectList *);
void (*free_effect_list)(tmdy_struct_ex_t *tmdy_struct, EffectList *);


void (*set_dry_signal)(tmdy_struct_ex_t *tmdy_struct, register int32 *, int32);
void (*mix_dry_signal)(tmdy_struct_ex_t *tmdy_struct, register int32 *, int32);

/* channel by channel reverberation effect */
void (*do_reverb)(tmdy_struct_ex_t *tmdy_struct, int32 *, int32);
void (*do_ch_reverb)(tmdy_struct_ex_t *tmdy_struct, int32 *, int32);
void (*set_ch_reverb)(tmdy_struct_ex_t *tmdy_struct, register int32 *, int32, int32);
void (*do_mono_reverb)(tmdy_struct_ex_t *tmdy_struct, int32 *, int32);
void (*init_reverb)(tmdy_struct_ex_t *tmdy_struct, int32);
void (*reverb_rc_event)(tmdy_struct_ex_t *tmdy_struct, int, int32);
//void (*recompute_reverb_value)(tmdy_struct_ex_t *tmdy_struct, int32);

/* channel by channel delay effect */
void (*do_ch_delay)(tmdy_struct_ex_t *tmdy_struct, int32 *, int32);
void (*set_ch_delay)(tmdy_struct_ex_t *tmdy_struct, register int32 *, int32, int32);
void (*init_ch_delay)(tmdy_struct_ex_t *tmdy_struct);

/* channel by channel chorus effect */
void (*do_ch_chorus)(tmdy_struct_ex_t *tmdy_struct, int32 *, int32);
void (*set_ch_chorus)(tmdy_struct_ex_t *tmdy_struct, register int32 *, int32, int32);
void (*init_chorus_lfo)(tmdy_struct_ex_t *tmdy_struct);
void (*init_ch_chorus)(tmdy_struct_ex_t *tmdy_struct);

/* channel by channel equalizer */
void (*init_eq)(tmdy_struct_ex_t *tmdy_struct);
void (*set_ch_eq)(tmdy_struct_ex_t *tmdy_struct, register int32 *, int32);
void (*do_ch_eq)(tmdy_struct_ex_t *tmdy_struct, int32 *, int32);
void (*calc_lowshelf_coefs)(tmdy_struct_ex_t *tmdy_struct, int32*,int32,FLOAT_T,int32);
void (*calc_highshelf_coefs)(tmdy_struct_ex_t *tmdy_struct, int32*,int32,FLOAT_T,int32);

/* insertion effect */
void (*init_insertion_effect)(tmdy_struct_ex_t *tmdy_struct);
void (*do_insertion_effect)(tmdy_struct_ex_t *tmdy_struct, int32*, int32);

/* lowpass filter for system effects */
void (*do_lowpass_24db)(tmdy_struct_ex_t *tmdy_struct, register int32*,int32,int32*,int32*);
void (*calc_lowpass_coefs_24db)(tmdy_struct_ex_t *tmdy_struct, int32*,int32,int16,int32);

void (*free_effect_buffers)(tmdy_struct_ex_t *tmdy_struct);

	/**** private variables ****/

int32 sample_rate;
double REV_INP_LEV;
int  spt0, rpt0, def_rpt0;
int  spt1, rpt1, def_rpt1;
int  spt2, rpt2, def_rpt2;
int  spt3, rpt3, def_rpt3;
int32  buf0_L[REV_BUF0], buf0_R[REV_BUF0];
int32  buf1_L[REV_BUF1], buf1_R[REV_BUF1];
int32  buf2_L[REV_BUF2], buf2_R[REV_BUF2];
int32  buf3_L[REV_BUF3], buf3_R[REV_BUF3];

int32  effect_buffer[AUDIO_BUFFER_SIZE*2];
int32  direct_buffer[AUDIO_BUFFER_SIZE*2];
int32  effect_bufsize;
int32  direct_bufsize;

int32  ta, tb;
int32  HPFL, HPFR;
int32  LPFL, LPFR;
int32  EPFL, EPFR;
	
#ifdef USE_DSP_EFFECT
int32 delay_effect_buffer[AUDIO_BUFFER_SIZE * 2];
/* circular buffers and pointers */
int32 delay_buf0_L[DELAY_BUFFER_SIZE + 1];
int32 delay_buf0_R[DELAY_BUFFER_SIZE + 1];
	
int32 delay_rpt0;
int32 delay_wpt0;
int32 delay_spt0;
int32 delay_spt1;
int32 delay_spt2;
#endif /* USE_DSP_EFFECT */

#ifdef USE_DSP_EFFECT
int32 chorus_effect_buffer[AUDIO_BUFFER_SIZE * 2];
/* circular buffers and pointers */
int32 chorus_buf0_L[CHORUS_BUFFER_SIZE + 1];
int32 chorus_buf0_R[CHORUS_BUFFER_SIZE + 1];
int32 chorus_rpt0;
int32 chorus_wpt0;
int32 chorus_wpt1;
int32 chorus_spt0;
int32 chorus_spt1;
int32 chorus_lfo0[SINE_CYCLE_LENGTH];
int32 chorus_lfo1[SINE_CYCLE_LENGTH];
int32 chorus_cyc0;
int32 chorus_cnt0;
#endif /* USE_DSP_EFFECT */

int32 eq_buffer[AUDIO_BUFFER_SIZE * 2];

/* volume stat. for Overdrive / Distortion */
int32 od_max_volume1;	
int32 od_max_volume2;

int combtunings[numcombs];
int allpasstunings[numallpasses];
revmodel_t *revmodel;

struct delay_status_t delay_status;
struct reverb_status_t reverb_status;
struct chorus_status_t chorus_status;// not found 
struct chorus_param_t chorus_param;
struct eq_status_t eq_status;
	
int revmodel_alloc_flag;

};

reverb_ex_t* new_reverb(tmdy_struct_ex_t *tmdy_struct);
void destroy_reverb(reverb_ex_t* reverb);
	
	



#endif /* ___REVERB_H_ */
