#ifndef ___JACK_A_H_
#define ___JACK_A_H

#include <jack/jack.h>

/*
 *  * simple ring-buffer
 *   */

struct tm_ringbuf {
    long rdptr, wrptr;      /* read, write pointers (not bound in ringbuffer size!) */
    int size;               /* ring buffer size */
    jack_default_audio_sample_t *buf[2];    /* left, right buffers */
};

/*
 *  * jack control context
 *   */
struct tm_jack {
     jack_client_t *client;
     jack_port_t *ports[2];

     int channels;           /* number of channels */
     int sample_16bit;       /* 16bit sample */
     int shift;              /* sample bit shift */
     int frag_size;          /* buffer fragment size (in samples) */
     int frags;              /* buffer fragments */

     pthread_cond_t cond;
     pthread_mutex_t lock;
     int running;
     int shutdown;

     struct tm_ringbuf rbuf;
};


struct s_jack_a_ex_t {
	timidity_mutex_t  busy;
		
	struct tm_jack jack_ctx;

};


jack_a_ex_t* new_jack_a(tmdy_struct_ex_t *tmdy_struct);
void destroy_jack_a(jack_a_ex_t* jack_a);

#endif /* ___JACK_A_H_ */

