#include "timidity.h"
#include "common.h"
#include "unimod.h"
#include "unimod_priv.h"


void ts_UniSetRow (tmdy_struct_ex_t *tmdy_struct, UBYTE *a){
	timidity_mutex_lock(TMDY_UNIMOD->busy);
	UniSetRow (tmdy_struct,a);
	timidity_mutex_unlock(TMDY_UNIMOD->busy);
}
UBYTE ts_UniGetByte (tmdy_struct_ex_t *tmdy_struct){
	UBYTE ts_buf;
	timidity_mutex_lock(TMDY_UNIMOD->busy);
	ts_buf=UniGetByte (tmdy_struct);
	timidity_mutex_unlock(TMDY_UNIMOD->busy);
	return ts_buf;
}
UWORD ts_UniGetWord (tmdy_struct_ex_t *tmdy_struct){
	UWORD ts_buf;
	timidity_mutex_lock(TMDY_UNIMOD->busy);
	ts_buf=UniGetWord (tmdy_struct);
	timidity_mutex_unlock(TMDY_UNIMOD->busy);
	return ts_buf;
}
UBYTE *ts_UniFindRow (tmdy_struct_ex_t *tmdy_struct, UBYTE *a, UWORD b){
	UBYTE *ts_buf;
	timidity_mutex_lock(TMDY_UNIMOD->busy);
	ts_buf=UniFindRow (tmdy_struct, a, b);
	timidity_mutex_unlock(TMDY_UNIMOD->busy);
	return ts_buf;
}
void ts_UniSkipOpcode (tmdy_struct_ex_t *tmdy_struct, UBYTE a){
	timidity_mutex_lock(TMDY_UNIMOD->busy);
	UniSkipOpcode (tmdy_struct, a);
	timidity_mutex_unlock(TMDY_UNIMOD->busy);
}
void ts_UniReset (tmdy_struct_ex_t *tmdy_struct){
	timidity_mutex_lock(TMDY_UNIMOD->busy);
	UniReset (tmdy_struct);
	timidity_mutex_unlock(TMDY_UNIMOD->busy);
}
void ts_UniWriteByte (tmdy_struct_ex_t *tmdy_struct, UBYTE a){
	timidity_mutex_lock(TMDY_UNIMOD->busy);
	UniWriteByte (tmdy_struct, a);
	timidity_mutex_unlock(TMDY_UNIMOD->busy);
}
void ts_UniWriteWord (tmdy_struct_ex_t *tmdy_struct, UWORD a){
	timidity_mutex_lock(TMDY_UNIMOD->busy);
	UniWriteWord (tmdy_struct, a);
	timidity_mutex_unlock(TMDY_UNIMOD->busy);
}
void ts_UniNewline (tmdy_struct_ex_t *tmdy_struct){
	timidity_mutex_lock(TMDY_UNIMOD->busy);
	UniNewline (tmdy_struct);
	timidity_mutex_unlock(TMDY_UNIMOD->busy);
}
UBYTE *ts_UniDup (tmdy_struct_ex_t *tmdy_struct){
	UBYTE *ts_buf;
	timidity_mutex_lock(TMDY_UNIMOD->busy);
	ts_buf=UniDup (tmdy_struct);
	timidity_mutex_unlock(TMDY_UNIMOD->busy);
	return ts_buf;
}
BOOL ts_UniInit (tmdy_struct_ex_t *tmdy_struct){
	BOOL ts_buf;
	timidity_mutex_lock(TMDY_UNIMOD->busy);
	ts_buf=UniInit (tmdy_struct);
	timidity_mutex_unlock(TMDY_UNIMOD->busy);
	return ts_buf;
}
void ts_UniCleanup (tmdy_struct_ex_t *tmdy_struct){
	timidity_mutex_lock(TMDY_UNIMOD->busy);
	UniCleanup (tmdy_struct);
	timidity_mutex_unlock(TMDY_UNIMOD->busy);
}
void ts_UniEffect (tmdy_struct_ex_t *tmdy_struct, UWORD a, UWORD b){
	timidity_mutex_lock(TMDY_UNIMOD->busy);
	UniEffect (tmdy_struct, a, b);
	timidity_mutex_unlock(TMDY_UNIMOD->busy);
}
void ts_UniPTEffect (tmdy_struct_ex_t *tmdy_struct, UBYTE a, UBYTE b){
	timidity_mutex_lock(TMDY_UNIMOD->busy);
	UniPTEffect (tmdy_struct, a, b);
	timidity_mutex_unlock(TMDY_UNIMOD->busy);
}
void ts_UniVolEffect (tmdy_struct_ex_t *tmdy_struct, UWORD a, UBYTE b){
	timidity_mutex_lock(TMDY_UNIMOD->busy);
	UniVolEffect (tmdy_struct, a, b);
	timidity_mutex_unlock(TMDY_UNIMOD->busy);
}
/* used to convert c4spd to linear XM periods (IT and IMF loaders). */
UWORD ts_getlinearperiod (tmdy_struct_ex_t *tmdy_struct, UWORD a, ULONG b){
	UWORD ts_buf;
	timidity_mutex_lock(TMDY_UNIMOD->busy);
	ts_buf=getlinearperiod (tmdy_struct, a, b);
	timidity_mutex_unlock(TMDY_UNIMOD->busy);
	return ts_buf;
}
UWORD ts_getlogperiod (tmdy_struct_ex_t *tmdy_struct, UWORD note, ULONG fine){
	UWORD ts_buf;
	timidity_mutex_lock(TMDY_UNIMOD->busy);
	ts_buf=getlogperiod (tmdy_struct, note, fine);
	timidity_mutex_unlock(TMDY_UNIMOD->busy);
	return ts_buf;
}
UWORD ts_getoldperiod (tmdy_struct_ex_t *tmdy_struct, UWORD a, ULONG b){
	UWORD ts_buf;
	timidity_mutex_lock(TMDY_UNIMOD->busy);
	ts_buf=getoldperiod (tmdy_struct, a, b);
	timidity_mutex_unlock(TMDY_UNIMOD->busy);
	return ts_buf;
}
ULONG ts_getfrequency (tmdy_struct_ex_t *tmdy_struct, UBYTE a, ULONG b){
	ULONG ts_buf;
	timidity_mutex_lock(TMDY_UNIMOD->busy);
	ts_buf=getfrequency (tmdy_struct, a, b);
	timidity_mutex_unlock(TMDY_UNIMOD->busy);
	return ts_buf;
}
ULONG ts_getAmigaPeriod (tmdy_struct_ex_t *tmdy_struct, UBYTE a, ULONG b){
	ULONG ts_buf;
	timidity_mutex_lock(TMDY_UNIMOD->busy);
	ts_buf=getAmigaPeriod (tmdy_struct, a, b);
	timidity_mutex_unlock(TMDY_UNIMOD->busy);
	return ts_buf;
}
/*    ========== External interface   */
CHAR *ts_ML_InfoLoader (tmdy_struct_ex_t *tmdy_struct){
	CHAR *ts_buf;
	timidity_mutex_lock(TMDY_UNIMOD->busy);
	ts_buf=ML_InfoLoader (tmdy_struct);
	timidity_mutex_unlock(TMDY_UNIMOD->busy);
	return ts_buf;
}
void ts_ML_RegisterAllLoaders (tmdy_struct_ex_t *tmdy_struct){
	ML_RegisterAllLoaders (tmdy_struct);
}
BOOL ts_ML_Test (tmdy_struct_ex_t *tmdy_struct, URL a){
	BOOL ts_buf;
	timidity_mutex_lock(TMDY_UNIMOD->busy);
	ts_buf=ML_Test (tmdy_struct, a);
	timidity_mutex_unlock(TMDY_UNIMOD->busy);
	return ts_buf;
}
MODULE *ts_ML_Load (tmdy_struct_ex_t *tmdy_struct, URL a, int b, BOOL c){
	MODULE *ts_buf;
	timidity_mutex_lock(TMDY_UNIMOD->busy);
	ts_buf=ML_Load (tmdy_struct, a, b, c);
	timidity_mutex_unlock(TMDY_UNIMOD->busy);
	return ts_buf;
}
CHAR *ts_ML_LoadTitle (tmdy_struct_ex_t *tmdy_struct, URL a){
	CHAR *ts_buf;
	timidity_mutex_lock(TMDY_UNIMOD->busy);
	ts_buf=ML_LoadTitle (tmdy_struct, a);
	timidity_mutex_unlock(TMDY_UNIMOD->busy);
	return ts_buf;
}
void ts_ML_Free (tmdy_struct_ex_t *tmdy_struct, MODULE *a){
	timidity_mutex_lock(TMDY_UNIMOD->busy);
	ML_Free (tmdy_struct, a);
	timidity_mutex_unlock(TMDY_UNIMOD->busy);
}




libunimod_ex_t* new_libunimod(tmdy_struct_ex_t *tmdy_struct){
	int i;
	libunimod_ex_t* libunimod_ex;

	libunimod_ex=(libunimod_ex_t *)TMDY_COMMON->safe_malloc(tmdy_struct, sizeof(libunimod_ex_t));
	timidity_mutex_init(libunimod_ex->busy);
	
/*========== Internal module representation (UniMod) interface */
libunimod_ex->UniSetRow=ts_UniSetRow;
libunimod_ex->UniGetByte=ts_UniGetByte;
libunimod_ex->UniGetWord=ts_UniGetWord;
libunimod_ex->UniFindRow=ts_UniFindRow;
libunimod_ex->UniSkipOpcode=ts_UniSkipOpcode;
libunimod_ex->UniReset=ts_UniReset;
libunimod_ex->UniWriteByte=ts_UniWriteByte;
libunimod_ex->UniWriteWord=ts_UniWriteWord;
libunimod_ex->UniNewline=ts_UniNewline;
libunimod_ex->UniDup=ts_UniDup;
libunimod_ex->UniInit=ts_UniInit;
libunimod_ex->UniCleanup=ts_UniCleanup;
libunimod_ex->UniEffect=ts_UniEffect;

libunimod_ex->UniPTEffect=ts_UniPTEffect;
libunimod_ex->UniVolEffect=ts_UniVolEffect;

/* used to convert c4spd to linear XM periods )(IT and IMF loaders). */
libunimod_ex->getlinearperiod=ts_getlinearperiod;
libunimod_ex->getlogperiod=ts_getlogperiod;
libunimod_ex->getoldperiod=ts_getoldperiod;
libunimod_ex->getfrequency=ts_getfrequency;
libunimod_ex->getAmigaPeriod=ts_getAmigaPeriod;

/*
 *    ========== External interface
 */

libunimod_ex->finetune=finetune;  //variable
libunimod_ex->ML_8bitsamples_p=&ML_8bitsamples;
libunimod_ex->ML_monosamples_p=&ML_monosamples;
libunimod_ex->ML_InfoLoader=ts_ML_InfoLoader;
libunimod_ex->ML_RegisterAllLoaders=ts_ML_RegisterAllLoaders;
libunimod_ex->ML_Test=ts_ML_Test;
libunimod_ex->ML_Load=ts_ML_Load;
libunimod_ex->ML_LoadTitle=ts_ML_LoadTitle;
libunimod_ex->ML_Free=ts_ML_Free;

libunimod_ex->of=of;

	return libunimod_ex;
}
void destroy_libunimod(libunimod_ex_t* libunimod){
	timidity_mutex_destroy(libunimod->busy);
	free(libunimod);
}




