#!/usr/bin/sh
echo "copying header files"
rm ../include/timidity-2.13/*.h
cp ../*.h ../include/timidity-2.13
cp ../libarc/*.h ../include/timidity-2.13
cp ../libunimod/*.h ../include/timidity-2.13
cp ../utils/*.h ../include/timidity-2.13
cp ../interface/*.h ../include/timidity-2.13
cp ../libtimidity/*.h ../include/timidity-2.13
rm ../include/timidity-2.13/*prv.h
rm ../include/timidity-2.13/*priv.h
grep '^#define' ../include/timidity-2.13/config.h|sed -e 's/^\#define //g'|sed -e 's/ .*$//g'>config_defs
grep '#undef'  ../include/timidity-2.13/config.h|sed -e 's/^.*\#undef //g'|sed -e 's/ .*$//g'>>config_defs
cat config_defs|sed -e 's/[a-z].*//g'|sed -e '/^$/d' >defbuf
mv defbuf config_defs
mv ../include/timidity-2.13/config.h ../include/timidity-2.13/config_dll
echo "changing header files"

for file in ../include/timidity-2.13/*.h
do

if grep  -f config_defs $file >defbuf
then
echo $file

for def in `cat config_defs`
do
if grep -l ${def} defbuf >/dev/null
then
cat $file |sed -e "s/ifdef ${def}/ifdef TMDY_${def}/g"|sed -e "s/ifndef ${def}/ifndef TMDY_${def}/g"|sed -e "s/defined(${def})/defined(TMDY_${def})/g" >config_buf
mv config_buf $file
fi
done

fi

done

mv ../include/timidity-2.13/config_dll ../include/timidity-2.13/config_dll.h
for def in `cat config_defs`
do
cat ../include/timidity-2.13/config_dll.h |sed -e "s/${def}/TMDY_${def}/g" > config_buf
mv config_buf ../include/timidity-2.13/config_dll.h
done

rm config_defs
rm defbuf

echo "header files are changed"
