/*
    TiMidity++ -- MIDI to WAVE converter and player
    Copyright (C) 1999-2002 Masanao Izumo <mo@goice.co.jp>
    Copyright (C) 1995 Tuukka Toivonen <tt@cgs.fi>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#ifndef ___NET_H_
#define ___NET_H_

#if defined(WINSOCK)
#include <winsock.h>
#else
typedef int SOCKET;
#define closesocket(fd) close(fd)
#define WSADATA int
#define MAKEWORD(a,b)
#define WSAStartup(a,b)
#define WSACleanup()
#endif

struct s_net_ex_t {
timidity_mutex_t  busy;

SOCKET (*open_socket)(tmdy_struct_ex_t *tmdy_struct, char *host, unsigned short port);
int (*socket_shutdown)(tmdy_struct_ex_t *tmdy_struct, SOCKET fd, int how);
long (*socket_write)(tmdy_struct_ex_t *tmdy_struct, SOCKET fd, char *buff, long bufsiz);

FILE *(*socket_fdopen)(tmdy_struct_ex_t *tmdy_struct, SOCKET fd, char *mode);
char *(*socket_fgets)(tmdy_struct_ex_t *tmdy_struct, char *buff, int n, FILE *fp);
int (*socket_fgetc)(tmdy_struct_ex_t *tmdy_struct, FILE *fp);
long (*socket_fread)(tmdy_struct_ex_t *tmdy_struct, void *buff, long bufsiz, FILE *fp);
long (*socket_fwrite)(tmdy_struct_ex_t *tmdy_struct, void *buff, long bufsiz, FILE *fp);
int (*socket_fflush)(tmdy_struct_ex_t *tmdy_struct, FILE *fp);
int (*socket_fclose)(tmdy_struct_ex_t *tmdy_struct, FILE *fp);
	

};


net_ex_t* new_net(tmdy_struct_ex_t *tmdy_struct);
void destroy_net(net_ex_t* net);
#endif /* ___NET_H_ */
