#
# The contents of this file are subject to the Mozilla Public
# License Version 1.1 (the "License"); you may not use this file
# except in compliance with the License. You may obtain a copy of
# the License at http://www.mozilla.org/MPL/
#
# Software distributed under the License is distributed on an "AS
# IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
# implied. See the License for the specific language governing
# rights and limitations under the License.
#
# The Original Code is this file as it was released upon August 6, 1998.
#
# The Initial Developer of the Original Code is Christopher
# Seawood. Portions created by Christopher Seawood are
# Copyright (C) 1998 Christopher Seawood. All
# Rights Reserved.
#
# Contributor(s): 

# A netscape style .mk file for autoconf builds

INCLUDED_AUTOCONF_MK = 1
USE_AUTOCONF 	= 1
MOZILLA_CLIENT	= 1
NO_MDUPDATE	= 1
BUILD_MODULES	= all
MOZILLA_VERSION = 1.0.0

prefix		= /usr/local
exec_prefix	= ${prefix}
bindir		= ${exec_prefix}/bin
includedir	= ${prefix}/include/mozilla-$(MOZILLA_VERSION)
libdir		= ${exec_prefix}/lib
datadir		= ${prefix}/share
mandir		= ${prefix}/man

mozappdir	= $(libdir)/mozilla-$(MOZILLA_VERSION)
mredir		= $(libdir)/mre/mre-$(MOZILLA_VERSION)
mrelibdir	= $(mredir)/lib

DIST		= $(DEPTH)/dist

MOZ_CHROME_FILE_FORMAT	= jar

MOZ_WIDGET_TOOLKIT	= windows
MOZ_GFX_TOOLKIT	= $(MOZ_WIDGET_TOOLKIT)

MOZ_JS_LIBS		   = -L$(DIST)/bin -lmozjs

MOZ_GFX_TOOLKIT_LDFLAGS     = -lgfx_$(MOZ_WIDGET_TOOLKIT) $(MOZ_XLIBRGB_LDFLAGS)
MOZ_WIDGET_TOOLKIT_LDFLAGS  = -lwidget_$(MOZ_WIDGET_TOOLKIT)

MOZ_DEBUG	= 1
MOZ_DEBUG_MODULES = 
MOZ_PROFILE_MODULES = 
MOZ_DEBUG_ENABLE_DEFS		= -DDEBUG -D_DEBUG -DDEBUG_keishi -DTRACING
MOZ_DEBUG_DISABLE_DEFS	= -DNDEBUG -DTRIMMED
MOZ_DEBUG_FLAGS	= -g
MOZ_DEBUG_LDFLAGS=
MOZ_DBGRINFO_MODULES	= 
MOZ_EXTENSIONS  = cookie wallet content-packs xml-rpc xmlextras help pref transformiix venkman inspector irc universalchardet
MOZ_JSDEBUGGER  = 1
MOZ_PERF_METRICS = 
MOZ_LEAKY	= 
MOZ_JPROF       = 
MOZ_XPCTOOLS    = 
ENABLE_EAZEL_PROFILER=
EAZEL_PROFILER_CFLAGS=
EAZEL_PROFILER_LIBS=
GC_LEAK_DETECTOR = 
NS_TRACE_MALLOC = 
USE_ELF_DYNSTR_GC = 
MOZ_MAIL_NEWS	= 1
MOZ_CALENDAR	= 
MOZ_PLAINTEXT_EDITOR_ONLY = 
BUILD_SHARED_LIBS = 1
BUILD_STATIC_LIBS = 
MOZ_STATIC_COMPONENTS = 
MOZ_META_COMPONENTS = 
MOZ_STATIC_COMPONENT_LIBS = 
ENABLE_TESTS	= 1
IBMBIDI = 1
SUNCTL = 
ACCESSIBILITY = 1
MOZ_LDAP_XPCOM = 1
MOZ_LDAP_XPCOM_EXPERIMENTAL = 
XPCOM_USE_LEA = 
JS_ULTRASPARC_OPTS = 
MOZ_ENABLE_POSTSCRIPT = 

MOZ_COMPONENTS_VERSION_SCRIPT_LDFLAGS = 
MOZ_COMPONENT_NSPR_LIBS=-L$(DIST)/bin $(NSPR_LIBS)
MOZ_COMPONENT_XPCOM_LIBS=-L$(DIST)/bin -lxpcom
XPCOM_LIBS=-L$(DIST)/bin -lxpcom
MOZ_REORDER=
MOZ_TIMELINE=

ENABLE_STRIP	= 

ClientWallet=1
CookieManagement=1
SingleSignon=1

MOZ_OJI=1

MOZ_POST_DSO_LIB_COMMAND = 
MOZ_POST_PROGRAM_COMMAND = 

MOZ_BUILD_ROOT             = 

MOZ_GLE                    = 
MOZ_XUL                    = 1

MOZ_NATIVE_ZLIB	= 
MOZ_NATIVE_JPEG	= 
MOZ_NATIVE_PNG	= 
MOZ_NATIVE_MNG	= 

MOZ_INTERNAL_LIBART_LGPL = 

MOZ_UPDATE_XTERM = 
MOZ_MATHML = 1
MOZ_SVG = 
MOZ_LIBART_CFLAGS = 
TX_EXE = 

# Mac's don't like / in a #include, so we include the libart
# headers locally if we're using the external library
ifdef MOZ_LIBART_CFLAGS
ifndef MOZ_INTERNAL_LIBART_LGPL
MOZ_LIBART_CFLAGS := $(MOZ_LIBART_CFLAGS)/libart_lgpl
endif
endif
MOZ_LIBART_LIBS = 

MOZ_INSURE = 
MOZ_INSURIFYING = 
MOZ_INSURE_DIRS = 
MOZ_INSURE_EXCLUDE_DIRS = 

MOZ_NATIVE_NSPR = 

CROSS_COMPILE   = 

OS_CPPFLAGS	= 
OS_CFLAGS	= $(OS_CPPFLAGS) -Wall -W -Wno-unused -Wpointer-arith -Wcast-align -pedantic -Wno-long-long -fvtable-thunks -pipe
OS_CXXFLAGS	= $(OS_CPPFLAGS) -fno-rtti -fno-exceptions -Wall -Wconversion -Wpointer-arith -Wbad-function-cast -Wcast-align -Woverloaded-virtual -Wsynth -Wno-ctor-dtor-privacy -pedantic -Wno-long-long -fvtable-thunks -pipe
OS_LDFLAGS	= 

OS_COMPILE_CFLAGS = $(OS_CPPFLAGS) -include $(DEPTH)/config-defs.h -DMOZILLA_CLIENT $(filter-out %/.pp,-Wp,-MD,$(MDDEPDIR)/$(*F).pp)
OS_COMPILE_CXXFLAGS = $(OS_CPPFLAGS) -DMOZILLA_CLIENT -include $(DEPTH)/config-defs.h $(filter-out %/.pp,-Wp,-MD,$(MDDEPDIR)/$(*F).pp)

OS_INCLUDES	= $(NSPR_CFLAGS) $(JPEG_CFLAGS) $(PNG_CFLAGS) $(MNG_CFLAGS) $(ZLIB_CFLAGS)
OS_LIBS		= -lm 
ACDEFINES	=  -DX_DISPLAY_MISSING=1 -DWIN32_LEAN_AND_MEAN=1 -DNONAMELESSUNION=1 -D_WINDOWS=1 -D_WIN32=1 -DWIN32=1 -DXP_PC=1 -DXP_WIN=1 -DXP_WIN32=1 -DHW_THREADS=1 -DWINVER=0x400 -DMSVC4=1 -DSTDC_HEADERS=1 -DNO_X11=1 -D_X86_=1 -DD_INO=d_ino -DSTDC_HEADERS=1 -Duid_t=int -Dgid_t=int -DHAVE_CPP_2BYTE_WCHAR_T=1 -DHAVE_DIRENT_H=1 -DHAVE_GETOPT_H=1 -DHAVE_MEMORY_H=1 -DHAVE_UNISTD_H=1 -DHAVE_LIBM=1 -DNO_X11=1 -DMMAP_MISSES_WRITES=1 -DHAVE_STRERROR=1 -DHAVE_MEMMOVE=1 -DHAVE_IOS_BINARY=1 -DHAVE_CPP_EXPLICIT=1 -DHAVE_CPP_SPECIALIZATION=1 -DHAVE_CPP_MODERN_SPECIALIZE_TEMPLATE_SYNTAX=1 -DHAVE_CPP_PARTIAL_SPECIALIZATION=1 -DHAVE_CPP_ACCESS_CHANGING_USING=1 -DHAVE_CPP_AMBIGUITY_RESOLVING_USING=1 -DHAVE_CPP_NAMESPACE_STD=1 -DHAVE_CPP_UNAMBIGUOUS_STD_NOTEQUAL=1 -DHAVE_CPP_NEW_CASTS=1 -DHAVE_CPP_DYNAMIC_CAST_TO_VOID_PTR=1 -DNEED_CPP_UNUSED_IMPLEMENTATIONS=1 -DMOZ_DEFAULT_TOOLKIT=\"windows\" -DIBMBIDI=1 -DACCESSIBILITY=1 -DMOZ_MATHML=1 -DMOZ_LOGGING=1 -DDETECT_WEBSHELL_LEAKS=1 -DMOZ_USER_DIR=\".mozilla\" -DMOZ_XUL=1 -DINCLUDE_XUL=1 -DNS_MT_SUPPORTED=1 -DUSE_IMG2=1 -DMOZ_DLL_SUFFIX=\".so\" -DXP_PC=1 -DJS_THREADSAFE=1 -DNS_PRINT_PREVIEW=1 -DMOZ_REFLOW_PERF=1 -DMOZ_REFLOW_PERF_DSP=1 

MOZ_OPTIMIZE	= 
MOZ_OPTIMIZE_FLAGS = -O
MOZ_OPTIMIZE_LDFLAGS = 

XCFLAGS		= 
XLDFLAGS	= 
XLIBS		= 

AIX_SHLIB_BIN	= 
AR		= /mingw/bin/ar
AR_FLAGS	= cr $@
AR_EXTRACT	= $(AR) x
AR_LIST		= $(AR) t
AR_DELETE	= $(AR) d
#AS		= $(CC)
AS		= as
ASFLAGS		= 
AS_DASH_C_FLAG	= -c
LD		= /mingw/bin/ld
#DLLTOOL		= /mingw/bin/dlltool
DLLTOOL         = dllwrap --export-all-symbols
RC		= windres
RCFLAGS		= -O coff
WINDRES		= 
USE_SHORT_LIBNAME = 1
IMPLIB		= 
FILTER		= 
BIN_FLAGS	= 

LIB_PREFIX	= lib
OBJ_SUFFIX	= o
LIB_SUFFIX	= a
DLL_SUFFIX	= .a
BIN_SUFFIX	= .exe
ASM_SUFFIX	= s
USE_N32		= 
HAVE_64BIT_OS	= 

# Temp hack.  It is not my intention to leave this crap in here for ever.
# Im talking to fur right now to solve the problem without introducing 
# NS_USE_NATIVE to the build system -ramiro.
NS_USE_NATIVE = 

CC		    = gcc
CXX		    = c++

GNU_AS		= 1
GNU_LD		= 1
GNU_CC		= 1
GNU_CXX		= 1
HAVE_GCC3_ABI	= 1

HOST_CC		= gcc
HOST_CXX	= c++
HOST_CFLAGS	= 
HOST_CXXFLAGS	= 
HOST_NSPR_MDCPUCFG = 
HOST_AR		= /mingw/bin/ar
HOST_RANLIB	= ranlib

HOST_LIBIDL_CONFIG = 
HOST_LIBIDL_CFLAGS = 
HOST_LIBIDL_LIBS   = 

TARGET_NSPR_MDCPUCFG = \"md/_win95.cfg\"
TARGET_CPU	= i686
TARGET_VENDOR	= pc
TARGET_OS	= mingw32
TARGET_MD_ARCH	= win32

AUTOCONF	= /mingw/gnuWin32/bin/autoconf
EMACS		= :
PERL		= /c/perl/bin/perl
RANLIB		= ranlib
WHOAMI		= :
UNZIP_PROG	= :
ZIP_PROG	= /c/mozilla_SDK/moztools/bin/zip
XARGS		= /mingw/gnuWin32/bin/xargs
STRIP		= /mingw/bin/strip
DOXYGEN		= :

ifdef MOZ_NATIVE_JPEG
JPEG_CFLAGS	= 
JPEG_LIBS	= 
JPEG_REQUIRES	=
else
JPEG_CFLAGS	= 
JPEG_LIBS	= -L$(DIST)/lib -lmozjpeg
JPEG_REQUIRES	= jpeg
endif

ifdef MOZ_NATIVE_ZLIB
ZLIB_CFLAGS	= 
ZLIB_LIBS	= 
ZLIB_REQUIRES	=
else
ZLIB_CFLAGS	= 
ZLIB_LIBS	= -L$(DIST)/lib -lmozz
ZLIB_REQUIRES	= zlib
endif

ifdef MOZ_NATIVE_PNG
PNG_CFLAGS	= 
PNG_LIBS	= 
PNG_REQUIRES	=
else
PNG_CFLAGS	= 
PNG_LIBS	= -L$(DIST)/lib -lmozpng
PNG_REQUIRES	= png
endif

ifdef MOZ_NATIVE_MNG
MNG_CFLAGS	= 
MNG_LIBS	= 
MNG_REQUIRES	=
else
MNG_CFLAGS	= 
MNG_LIBS	= -L$(DIST)/lib -lmozmng
MNG_REQUIRES	= mng
endif

NSPR_CFLAGS = -I/dist/include/nspr 
NSPR_LIBS = -L/dist/lib -lplds4 -lplc4 -lnspr4 

LDAP_CFLAGS	= -I${DIST}/public/ldap
LDAP_LIBS	= -L${DIST}/bin -L${DIST}/lib -lldap50 -llber50 -lprldap50

# MKSHLIB_FORCE_ALL is used to force the linker to include all object
# files present in an archive. MKSHLIB_UNFORCE_ALL reverts the linker
# to normal behavior. Makefile's that create shared libraries out of
# archives use these flags to force in all of the .o files in the
# archives into the shared library.
WRAP_MALLOC_LIB         = 
WRAP_MALLOC_CFLAGS      = 
DSO_CFLAGS              = 
DSO_PIC_CFLAGS          = -fPIC
MKSHLIB                 = $(DLLTOOL) --as=$(AS) -k --dllname $(LIBRARY_NAME).dll --output-lib $@
MKCSHLIB                = $(DLLTOOL) --as=$(AS) -k --dllname $(LIBRARY_NAME).dll --output-lib $@
MKSHLIB_FORCE_ALL       = 
MKSHLIB_UNFORCE_ALL     = 
DSO_LDOPTS              = -shared -Wl,-h -Wl,$@
DLL_SUFFIX              = .a

NO_LD_ARCHIVE_FLAGS     = 1

GTK_CONFIG	= 
TK_CFLAGS	= 
TK_LIBS		= 

MOZ_TOOLKIT_REGISTRY_CFLAGS = \
	-DWIDGET_DLL=\"libwidget_$(MOZ_WIDGET_TOOLKIT)$(DLL_SUFFIX)\" \
	-DGFXWIN_DLL=\"libgfx_$(MOZ_GFX_TOOLKIT)$(DLL_SUFFIX)\" \
	$(TK_CFLAGS)

MOZ_ENABLE_GTK		= 
MOZ_ENABLE_GTK2		= 
MOZ_ENABLE_XLIB		= 
MOZ_ENABLE_QT		= 
MOZ_ENABLE_PHOTON	= 
MOZ_ENABLE_COCOA	= 
MOZ_ENABLE_XREMOTE	= 

MOZ_GTK_CFLAGS		= 
MOZ_GTK_LDFLAGS		= 

MOZ_GTK2_CFLAGS		= 
MOZ_GTK2_LIBS		= 

MOZ_XLIB_CFLAGS		= 
MOZ_XLIB_LDFLAGS	= 

MOZ_QT_CFLAGS		= 
MOZ_QT_LDFLAGS		= 

MOZ_XPRINT_CFLAGS	= 
MOZ_XPRINT_LDFLAGS	= 
MOZ_ENABLE_XPRINT	= 

MOZ_ENABLE_FREETYPE2	= 
MOZ_XFT_SYSTEM_FREETYPE2 = 
FT2_CFLAGS		= 
FT2_LIBS		= 

MOZ_ENABLE_XFT		= 
MOZ_XFT_CFLAGS		= 
MOZ_XFT_LIBS		= 

MOZ_ENABLE_XINERAMA	= 
MOZ_XINERAMA_LIBS	= 

MOZ_XIE_LIBS		= 

GLIB_CFLAGS	= -Ic:/mozilla_source/moztools/include
GLIB_LIBS	= -Lc:/mozilla_source/moztools/lib -lglib-1.2
GLIB_GMODULE_LIBS	= -Lc:/mozilla_source/moztools/lib -lgmodule-1.2 -lglib-1.2
LIBIDL_CFLAGS = -Ic:/mozilla_source/moztools/include -Ic:/mozilla_source/moztools/include/libIDL -Ic:/mozilla_source/moztools/include
LIBIDL_LIBS = -Lc:/mozilla_source/moztools/lib -lglib-1.2 -Lc:/mozilla_source/moztools/lib -lIDL-0.6 -lglib-1.2

MOZ_NATIVE_MAKEDEPEND	= 

# Used for LD_LIBRARY_PATH
LIBS_PATH       = 

MOZ_AUTO_DEPS	= 1
COMPILER_DEPEND = 1
MDDEPDIR        := .deps

MOZ_DISABLE_DTD_DEBUG = 

MOZ_DEMANGLE_SYMBOLS = 

# XXX - these need to be cleaned up and have real checks added -cls
CM_BLDTYPE=dbg
AWT_11=1
MOZ_BITS=32
OS_TARGET=MINGW32_NT-5.0
OS_ARCH=WINNT
OS_RELEASE=4.0
OS_TEST=i686

# For OS/2 build
MOZ_OS2_TOOLS = 
MOZ_OS2_EMX_OBJECTFORMAT = 

HAVE_XIE=

MOZ_MOVEMAIL=
MOZ_PSM=

# for Qt build
MOC=

# Win32 options
MOZ_PROFILE	= 
MOZ_COVERAGE	= 
MOZ_MAPINFO	= 
MOZ_BROWSE_INFO	= 
MOZ_TOOLS_DIR	= /c/mozilla_SDK/moztools
