package tutorial.bbs;

import java.sql.PreparedStatement;
import java.sql.ResultSet;

import com.sun.corba.se.spi.orbutil.fsm.Guard.Result;

import wisdom.core.application.IRequestHandler;
import wisdomx.logic.formtemplate.AbstractFormObject;
import wisdomx.logic.formtemplate.AbstractFormObjectGenerator;
import wisdomx.logic.formtemplate.ParameterInputForm;

public class CategoryFog extends AbstractFormObjectGenerator {
	public static final long serialVersionUID = 1L;
	
	public static final String SQL_SEL_CATEGOEY = 
		"select CATEGORYNAME from CATEGORY where CATEGORYCD = ? ";
	/***
	 * RXgN^
	 * @param inputForm
	 * @param rh
	 * @throws Exception
	 */
	public CategoryFog(ParameterInputForm inputForm, IRequestHandler rh) throws Exception {
		super(inputForm, rh);
	}

	@Override
	protected AbstractFormObject _generate() throws Exception {
		CategoryFo fo = new CategoryFo();
		fo.setCategorycd(inputForm.getString("categorycd"));
		
		PreparedStatement ps = rh.getConnection().prepareStatement(SQL_SEL_CATEGOEY);
		ps.setString(1, fo.getCategorycd());
		ResultSet rs = ps.executeQuery();
		if (rs.next()) {
			fo.setCategoryname(rs.getString(1).trim());
		}
		rs.close();
		ps.close();
		return fo;
	}
}
