package tutorial.common;

import java.sql.PreparedStatement;
import java.sql.ResultSet;

import wisdom.core.application.IRequestHandler;
import wisdomx.ui.builder.AbstractOptionsBuilder;
import wisdomx.ui.object.Option;
import wisdomx.ui.object.Select;



/**
 *
 * @author  Takao Kouda
 * @version 1
 */
public class OptionsBuilder extends AbstractOptionsBuilder implements OptionsConstants {
	private static final String SQL_CITYCD = "select CITYCD, CITYNM from MCITY ";
	private static final String SQL_HOBBYCD = "select HOBBYCD, HOBBYNM from MHOBBY ";
	
	protected OptionsBuilder(IRequestHandler rh) {
		super(rh);
	}
	
	public Select build(int optionType, String optionsName) throws Exception {
		Select select = new Select(optionsName);
		String sql = null;
		
		switch (optionType) {	
			case OC_CITYCD : sql = SQL_CITYCD ; break;
			case OC_HOBBYCD : sql = SQL_HOBBYCD ; break;
			case OC_SEXKBN  : return createFromArray(select, STR_SEXKBN);
		}
		
		PreparedStatement ps = rh.getConnection().prepareStatement(sql);
		ResultSet rs = ps.executeQuery();
		
		while(rs.next()) {
			select.add(new Option(rs.getString(1).trim(), rs.getString(2).trim()));
		}
		rs.close();
		ps.close();
		
		return select;
	}

	public Select build(int optionType, String optionsName, String key) throws Exception{
		return null;
	}
	
	public Select build(int optionType, String optionsName, String[] keys) throws Exception{
		return null;
	}
	
	private Select createFromArray(Select select, String[][] array) {
		for (int i = 0; i < array.length; i++) {
			select.add(new Option(array[i][0], array[i][1]));
		}
		return select;
	}
	/**  */
	public static final String[][] STR_SEXKBN = new String[][]{
		{"1","j"}, {"2",""}
		};	
}	

	