package tutorial.common;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;


import wisdom.core.application.IRequestParser;
import wisdom.core.request.ParameterNotFoundException;
import wisdomx.logic.formtemplate.Define;
import wisdomx.logic.formtemplate.Types;
import wisdomx.ui.object.IHasMessageList;
import wisdomx.ui.object.Select;
import wisdomx.ui.render.Tag;
import wisdomx.ui.render.TagHelper;

public class TagRendor extends TagHelper {

	/** eLXgTCY̍ől */
	private static final int INPUT_SIZE_MAX = 85;
	/** ͌JEg X^C */
	private static final String INPUT_COUNT_STYLENAME = "textlimit";

	public static String input(Define define, String value) {
		return input(define, value, false);
	}
	public static String input(Define define, String value, boolean isReadonly) { 
		Double doubleLength = define.getLengh() * 1.5;
		int length = doubleLength.intValue();
		if (length > 70 ) {
			length = 70;
		}
		String readOnly = "";
		if (isReadonly) {
			readOnly = " readonly class=\"readonly\" ";
		}
		return 
			"<input type=\"text\"" + " name=\"" + define.getId() + "\" size=\"" + length + "\""
			+ " value=\"" + TagHelper.escape2Input(value) + "\""
			+ " maxlength=\"" + define.getLengh() + "\""
			+ " id=\"" + define.getId() + "\""
			+ readOnly 
			+ "/>"
			
			+ "<span class=\"colsize\">("+define.getLengh()+")</span>"
		;		
	}
	/**
	 * INPUTeLXg^O𐶐ĕԂ܂<br>
	 * ͌̕\EXNvgɂ̓`FbNI\
	 * @param define ڒ`
	 * @param value l
	 * @param isReadonly ǎp
	 * @param isScript   XNvg͐
	 * @return INPUTeLXg
	 */
	public static String input(Define define, String value, boolean isReadonly, boolean isScript) {
		return input(define, define.getId(), define.getLabel(), value, "", isReadonly, false, isScript);
	}
	/**
	 * INPUTeLXg^O𐶐ĕԂ܂<br>
	 * ͌̕\EXNvgɂ̓`FbNI\
	 * @param define ڒ`
	 * @param fieldId tB[hID
	 * @param value l
	 * @param isReadonly ǎp
	 * @param isScript   XNvg͐
	 * @return INPUTeLXg
	 */
	public static String input(Define define, String fieldId, String value, boolean isReadonly, boolean isScript) {
		return input(define, fieldId, define.getLabel(), value, "", isReadonly, false, isScript);
	}
	/**
	 * INPUTeLXg^O̐
	 * @param define ڒ`
	 * @param fieldId tB[hID
	 * @param name tB[h
	 * @param value l
	 * @param className X^C
	 * @param isReadonly ǎp
	 * @param isDisabled L
	 * @param isScript XNvg͐
	 * @return INPUTeLXg
	 */
	private static String input(Define define, String field, String name, String value, String className, boolean isReadonly, boolean isDisabled, boolean isScript) {
		// eLXg̓TCY̎擾
		double doubleSize = define.getLengh() * 1.5;
		int size = (doubleSize > INPUT_SIZE_MAX) ? INPUT_SIZE_MAX : (int)doubleSize;
		
		StringBuffer sb = new StringBuffer();
//		// eLXg
//		sb.append(HtmlTagCreator.inputText(field, field, value, className, size, define.getLengh(), isReadonly, isDisabled));
//		if (isScript) {
//			// ͌\GA
//			sb.append(HtmlTagCreator.span(field + "_count", INPUT_COUNT_STYLENAME, ""));
//			// XNvg̐ݒ
//			sb.append(HtmlTagCreator.script(createKeyupStrCount(field, name, define.getLengh(), define.getType())));
//		}
		return sb.toString();
	}
	public static String inputAlt(Define define, String fieldName, String value) {
		return inputAlt(define, fieldName, value, false);
	}	
	public static String inputAlt(Define define, String fieldName, String value, boolean isReadonly) {
		Double doubleLength = define.getLengh() * 1.5;
		int length = doubleLength.intValue();
		if (length > 70 ) {
			length = 70;
		}
		String readOnly = "";
		if (isReadonly) {
			readOnly = " readonly class=\"readonly\" ";
		}
		return 
			"<input type=\"text\"" + " name=\"" + fieldName + "\" size=\"" + length + "\""
			+ " value=\"" + TagHelper.escape2Input(value) + "\""
			+ " maxlength=\"" + define.getLengh() + "\""
			+ " id=\"" + fieldName + "\""
			+ readOnly 
			+ "/>"
			
			+ "<span class=\"colsize\">("+define.getLengh()+")</span>"
		;			
		
	}
	
	public static String textarea(Define define, String value, int cols, int rows) {
		return textareaAlt(define, define.getId(),value, cols, rows);
	}
	public static String textareaAlt(Define define,String fieldName, String value, int cols, int rows) {
		return 
		"<textarea id=\"" + fieldName + "\""  + " name=\"" + fieldName  + "\" cols=\"" + cols + "\" rows=\"" + rows + "\">" 
		+ TagHelper.escape2Input(value) + "</textarea>"
		;		
	}

	public static String textareaAltEdit(Define define,String fieldName, String value, int cols, int rows) {
		return 
		"<textarea id=\"" + fieldName + "\""  + " name=\"" + fieldName  + "\" style=\" width:100%;\">" 
//		+ Tag.escape2Input(value) + "</textarea>"
		+ "</textarea>"
		;		
	}
 
	public static String name(Define define, IHasMessageList hasMessageList) {
		return name(define,hasMessageList,false);
	}
	public static String name(Define define) {
		return name(define,null);
	}	
	public static String name(Define define, IHasMessageList hasMessageList, boolean isNecessary) {
		String label = "";
		if (hasMessageList != null && hasMessageList.containsMessageByFieldId(define.getId())) {
			label=  "<span class=\"error\">"  +define.getLabel() + "</span>";
		} else {
			label = define.getLabel();
		}
		if (isNecessary) {
			label =  label + "<span class=\"necessary\">"  + "" + "</span>";
		}
		return label;
	}
	public static String selectAlt(Select select, String fieldName) {
		String oldName = select.getName();
		select.setName(fieldName);
		String s = Tag.select(select );
		select.setName(oldName);
		return s;
	}
	public static String select(Select select, boolean isReadonly) {
		select.setDisabled(isReadonly);
		return Tag.select(select );
	}
	/**
	 * eLXgEeLXgGA̓͌̕\EXNvgɂ̓`FbNp<br>
	 * CxgǉXNvg𐶐܂
	 * @param field tB[hID
	 * @param name ږ
	 * @param max ő̓oCg
	 * @return script
	 */
	private static String createKeyupStrCount(String field, String name, int max, int type) {
		StringBuffer sb = new StringBuffer();
		sb.append("checkTextList.push({id: '");
		sb.append(field);
		sb.append("', name: '");
		sb.append(name);
		sb.append("', max: ");
		sb.append(max);
		sb.append(", type: ");
		if (type == Types.DECIMAL) {
			sb.append(3);
		} else if (type == Types.CHAR) {
			sb.append(2);
		} else {
			sb.append(1);
		}
		sb.append("});");
		return sb.toString();
	}
	public static String hiddenChecks(IRequestParser rp, String fieldName )  {
		List<String> already = new ArrayList<String>();
		StringBuffer sb = new StringBuffer();
		
		for (Iterator<String>s = rp.getParameterNames() ; s.hasNext() ; ) {
			String key = s.next();
			if (key.equals(fieldName)) {
				if (already.contains(key)) {
					continue;
				}
				String[] val  = null;
				try {
					 val = rp.getStringArray(fieldName);
				} catch (ParameterNotFoundException e) {}
				if (val != null) {
					for (int i = 0 ; i < val.length ; i++) {
						sb.append(Tag.hidden(fieldName, val[i]));
					}
				}
				already.add(key);
			}
		}
		return sb.toString();
	}
}
