package tutorial.user;

import java.sql.PreparedStatement;
import java.sql.ResultSet;

import wisdom.core.application.IRequestHandler;
import wisdom.core.util.StringUtil;
import wisdomx.logic.formtemplate.AbstractFormObject;
import wisdomx.logic.formtemplate.AbstractFormObjectPersistance;
import wisdomx.logic.formtemplate.StringChecker;
import wisdomx.ui.object.Checkbox;
import static tutorial.common.DataDictionary.*;

public class UserFop extends AbstractFormObjectPersistance {
	public static final long serialVersionUID = 1L;
	
	public static final String SQL_INS_MUSER = 
		"insert into MUSER (USERID,USERNAME,PASSWORD,MAILADDRESS,SEXKBN,CITYCD)values(?,?,?,?,?,?)";
	
	public static final String SQL_INS_MUSERHOBBY = 
		"insert into MUSERHOBBY (USERID,HOBBYCD)values(?,?)";
	
	public static final String SQL_SEL_USER = 
		"select USERID from  MUSER where USERID = ?";
	
	public static final String SQL_UPD_MUSER = 
		"update MUSER set USERNAME = ? ,PASSWORD = ? ,MAILADDRESS = ?, SEXKBN = ? , CITYCD = ? where userid = ?";
	
	public static final String SQL_DEL_MUSER = 
		"delete from MUSER where userid = ?";
	
	public static final String SQL_DEL_MUSERHOBBY = 
		"delete from MUSERHOBBY where userid = ?";
	
	private UserFo fo = null;
	
	public UserFop(AbstractFormObject formObject, IRequestHandler rh) throws Exception {
		super(formObject, rh);
		fo = (UserFo)formObject;
	}

	@Override
	protected void _cleanup() throws Exception {}

	@Override
	protected void _delete() throws Exception {
		PreparedStatement ps = rh.getConnection().prepareStatement(SQL_DEL_MUSER);
		ps.setString(1, fo.getUserid());
		ps.executeUpdate();
		ps.close();
		deleteHobbdy();
	}

	@Override
	protected void _insert() throws Exception {
		PreparedStatement ps = rh.getConnection().prepareStatement(SQL_INS_MUSER);
		int x = 1;
		ps.setString(x++, fo.getUserid());
		ps.setString(x++, fo.getUsername());
		ps.setString(x++, fo.getPassword());
		ps.setString(x++, fo.getMailaddress());
		ps.setString(x++, fo.getSexkbn().getSelected());
		ps.setString(x++, fo.getCitycd().getSelected());
		ps.executeUpdate();
		ps.close();
		insertHoddy();
	}
	private void insertHoddy() throws Exception {
		PreparedStatement ps = rh.getConnection().prepareStatement(SQL_INS_MUSERHOBBY);
		Checkbox hobbycd = fo.getHobbycd().getCheckedOptions();
		for (int i = 0 ; i < hobbycd.size(); i++ ) {
			int x = 1;
			ps.setString(x++, fo.getUserid());
			ps.setString(x++, hobbycd.get(i).getKey());
			ps.executeUpdate();
		}
		ps.close();
	}
	private void deleteHobbdy() throws Exception  {
		PreparedStatement ps = rh.getConnection().prepareStatement(SQL_DEL_MUSERHOBBY);
		ps.setString(1, fo.getUserid());
		ps.executeUpdate();
		ps.close();
	}

	@Override
	protected void _prepare(AbstractFormObject form) throws Exception {}

	@Override
	protected void _update() throws Exception {
		PreparedStatement ps = rh.getConnection().prepareStatement(SQL_UPD_MUSER);
		int x = 1;
		ps.setString(x++, fo.getUsername());
		ps.setString(x++, fo.getPassword());
		ps.setString(x++, fo.getMailaddress());
		ps.setString(x++, fo.getSexkbn().getSelected());
		ps.setString(x++, fo.getCitycd().getSelected());
		
		ps.setString(x++, fo.getUserid());
		ps.executeUpdate();
		ps.close();
		deleteHobbdy();
		insertHoddy();		
	}

	@Override
	protected void _validate() throws Exception {
		StringChecker sc = new StringChecker();
		int result = 0;
		result += sc.checkNotEmpty(USERID, fo.getUserid(),fo);
		result += sc.checkNotEmpty(USERNAME, fo.getUsername(),fo);
		result += sc.checkNotEmpty(PASSWORD, fo.getPassword(),fo);
		result += sc.checkNotEmpty(MAILADDRESS, fo.getMailaddress(),fo);
		result += sc.checkNotEmpty(SEXKBN, fo.getSexkbn().getSelected(),fo);
		result += sc.checkNotEmpty(CITYCD, fo.getCitycd().getSelected(),fo);
		if (fo.isInsert() && StringUtil.notEmpty(fo.getUserid())) {
			PreparedStatement ps = rh.getConnection().prepareStatement(SQL_SEL_USER);
			ps.setString(1, fo.getUserid());
			ResultSet rs = ps.executeQuery();
			if (rs.next()) {
				// USM0011E=͂ꂽ[U[ID͂łɓo^Ă܂B
				fo.addErrorMessage(messageGenerator.getMessage("USM0011E"));
			}
			rs.close();
			ps.close();
		}
	}

}
