package tutorial.user;

import java.sql.PreparedStatement;

import tutorial.common.Factory;
import wisdom.core.MessageList;
import wisdom.core.application.AbstractRequestCommand;
import wisdom.core.util.StringUtil;
import wisdomx.logic.formtemplate.ParameterInputForm;
import wisdomx.ui.builder.StatementBuilder;
import wisdomx.ui.builder.StatementPageListBuilder;
import wisdomx.ui.object.IPageList;

public class UserMaintCmd extends AbstractRequestCommand {
	public static final String[] PAGES = new String[]
	{"/tutorial/user/userlist.jsp",
		"/tutorial/user/userentry.jsp",
		"/tutorial/user/userentryconfirm.jsp",
		"/tutorial/user/userdeleteconfirm.jsp",
	 };
	public static final String SQL_SEL_USER = 
		" select " 
		+   "USERID," 
		+	"USERNAME,"
		+  "CASE SEXKBN WHEN '1' THEN 'j' WHEN '2' THEN '' END," 
		+  " ( select CITYNM from MCITY where MUSER.CITYCD = MCITY.CITYCD)"
		+" from MUSER" 
		+   " order by USERID ";
	private MessageList ml = null;
	private UserFo user = null;
	@Override
	protected void _execute() throws Exception {
		String op = rp.getString("op","");
		
		ml = new MessageList();
		
		 if (StringUtil.isEmpty(op) || "list".equals(op)) {
			list();
		} else if ("entry".equals(op)) {
			entry();
		} else if ("update".equals(op)) {
			update();
		} else if ("entryconfirm".equals(op)) {
			entryconfirm();
		} else if ("deleteconfirm".equals(op)) {
			deleteconfirm();
		} else if ("doentry".equals(op)) {
			doentry();
		} else if ("dodelete".equals(op)) {
			dodelete();
		} else if ("backentry".equals(op)) {
			backentry();
		}
		rh.setAttribute(getName()+"#ml", ml);
	}
	private void list() throws Exception{
		// ꗗ\邽߂PreparedStatement쐬܂B
		PreparedStatement ps = new StatementBuilder(SQL_SEL_USER,rh.getConnection()).buildStatement();
		
		// ݕ\̃y[Wԍ擾܂B݃y[Whiddenp[^gpAp[^Ȃꍇ͈y[WڂƂ܂B
		int page = rp.getInt("page",1);
		
		// ꗗy[W̃IuWFNg쐬܂B\s20sw肵Ă܂B
		IPageList pageList 
				= new StatementPageListBuilder(ps,Factory.getPageDecorator()).buildPerPageRows(5, page);
		
		// JeS[ꍇ̓bZ[W\܂B
		if (pageList.size() == 0) {
			// USM0010I=o^Ă郆[U[͂܂B
			ml.addMessage(messageGenerator.getMessage("USM0010I"));
		}
		//Requestֈꗗy[W̃IuWFNgAbZ[WsetAttributeđJڐy[Ww肵܂B
		rh.setAttribute(getName()+"#pageList", pageList);
		setPage(PAGES[0]);		
	}
	private void entry() throws Exception{
		user = new UserFo(rh);
		rh.setSessionAttribute(getName()+"#user", user);
		setPage(PAGES[1]);		
	}
	private void update() throws Exception{
		ParameterInputForm pif = new ParameterInputForm();
		pif.addString("userid", rp.getString("userid"));
		UserFog fog = new UserFog(pif,rh);
		rh.setSessionAttribute(getName()+"#user", fog.generate());
		setPage(PAGES[1]);
	}
	private void entryconfirm() throws Exception{
		user = (UserFo)rh.getSessionAttribute(getName()+"#user");
		user.set(rh, rp);
		UserFop fop = new UserFop(user,rh);
		user = (UserFo)fop.validate();
		if (user.isError()) {
			setPage(PAGES[1]);	
		} else {
			setPage(PAGES[2]);
		}
	}
	private void deleteconfirm() throws Exception{
		setPage(PAGES[3]);
	}
	private void doentry() throws Exception{
		user = (UserFo)rh.getSessionAttribute(getName()+"#user");
		UserFop fop = new UserFop(user,rh);
		fop.setIgnoreValidate(true);
		user = (UserFo)fop.execute();
		if (user.isError()) {
			setPage(PAGES[1]);	
		} else {
			list();
		}
	}
	private void dodelete() throws Exception{
		user = (UserFo)rh.getSessionAttribute(getName()+"#user");
		user.toDelete();
		UserFop fop = new UserFop(user,rh);
		fop.setIgnoreValidate(true);
		user = (UserFo)fop.execute();
		list();		
	}
	private void backentry() throws Exception{
		setPage(PAGES[1]);
	}
}
