package wisdom.core;

import java.io.Serializable;
import java.util.Map;
import java.util.Iterator;
import java.util.Set;
import java.net.InetAddress;
import java.net.UnknownHostException;

import wisdom.core.connections.ConnectionDef;

/**
 * AvP[VŎgp\t@C̏擾܂B<br>
 * {@link CoreObject CoreObject} CX^Xɓɐ܂B̃NX̃CX^XɎs
 * ꍇAWo͂Ɍ񍐂܂B
 * 
 * @author  Takao Kouda
 * @version 1.0 
 */
 public class ConfigManager implements Serializable ,ConfigConstants {
	public static final long serialVersionUID = 1L;
 	private MessageGenerator messageGenerator = null; 
	private ConfigHandler configHandler = null; 	
	
	private static ConfigManager configManager = new ConfigManager();

	private static String context = null;
	
    private ConfigManager() {
		super();
		try {
			configHandler = ConfigHandler.getInstance();
			messageGenerator =  CoreMessageGenerator.getInstance();
		} catch (Exception e) {
			System.out.println(getClass().getName()+ " initialization failed.");
			e.printStackTrace(System.out);
		}
	}

	/**
	 * ConfigManager̃CX^X擾܂B<br>
	 * 
	 * @return ConfigManager
	 */
	public static synchronized ConfigManager getInstance() {
		if (configManager == null) {
			configManager = new ConfigManager();
		}
 		return configManager;
	}

	/**
	 * w肳ꂽL[Őݒ肳ꂽlString^ŕԂ܂B<br>
	 * 
	 * @param key L[
	 * @return String Ԃliw肳ĂȂꍇnullj
	 */
	public String getString(String key) {
		String val = (String)configHandler.getProps().get(key);
		if (val == null) throw new CoreRuntimeException(messageGenerator.getMessage("WRE0020",key));
		
		return val;
	}
	
	/**
	 * wisdom_config.xmldatasourcevfiddefinNameŐݒ肳Ă
	 * ConnectionDefIuWFNg擾܂B<br>
	 * ȂꍇCoreRuntimeExceptiono܂B<br>
	 * 
	 * @param		defineName	擾ConnectionDef̖O
	 * @return 	ConnectionDef̃CX^X
	 */
	public ConnectionDef getConnectionDef(String defineName) {
		if (configHandler == null) throw new CoreRuntimeException(messageGenerator.getMessage("WRE0030"));
		Map m = configHandler.getDatasources();
		if (m == null || m.size() == 0) throw new CoreRuntimeException(messageGenerator.getMessage("WRE0030"));
		ConnectionDef def = (ConnectionDef)m.get(defineName);
		if (def == null) throw new CoreRuntimeException(messageGenerator.getMessage("WRE0040",defineName));

		return def;
	}
	/**
	 * wisdom_config.xmldatasourcevfdefaulttrueŐݒ肳Ă
	 * ConnectionDefIuWFNg擾܂B<br>
	 * ݒ̖defaulttrueɐݒ肳ĂConnectionDef݂Ȃꍇ
	 * CoreRuntimeExceptiono܂B<br>
	 * 
	 * @return 	ConnectionDef̃CX^X
	 */
	public ConnectionDef getConnectionDef() {
		if (configHandler == null) throw new CoreRuntimeException(messageGenerator.getMessage("WRE0030"));

		Map m = configHandler.getDatasources();
		if (m == null || m.size() == 0) throw new CoreRuntimeException(messageGenerator.getMessage("WRE0030"));
		
		Set keys = m.keySet();
		if (keys == null) throw new CoreRuntimeException(messageGenerator.getMessage("WRE0030"));

		for (Iterator i = keys.iterator(); i != null && i.hasNext(); ) {
			ConnectionDef def = (ConnectionDef)m.get((String)i.next() );				
			if (def.isDefault()) return def;
		}
		throw new CoreRuntimeException(messageGenerator.getMessage("WRE0030"));
	}	
	/**
	 * wisdom_config.xmlservletRuntimeConfigvfclassNameservletNameŐݒ肳Ă
	 * ServletRuntimeConfigIuWFNg擾܂B
	 * ȂꍇCoreRuntimeExceptiono܂B<br>
	 * 
	 * @param		servletName	擾ServletRuntimeConfig̖O
	 * @return 	ServletRuntimeConfig̃CX^X
	 */
	public ServletRuntimeConfig getServletRuntimeConfig(String servletName) {
		if (configHandler == null) 
			throw new CoreRuntimeException(messageGenerator.getMessage("WRE0050", servletName));
		Map m = configHandler.getServletRuntimeConfigs();
		if (m == null || m.size() == 0) 
			throw new CoreRuntimeException(messageGenerator.getMessage("WRE0050", servletName));
		ServletRuntimeConfig def = (ServletRuntimeConfig)m.get(servletName);
		if (def == null) throw new CoreRuntimeException(messageGenerator.getMessage("WRE0050", servletName));
		return def;
	}
	/**
	 * w肳ꂽL[Őݒ肳ꂽlString^ŕԂ܂BL[ݒ肳ĂȂꍇ͎擾
	 * w肵lԂ܂B<br>
	 * 
	 * @param key L[
	 * @param def L[Őݒ肳ĂȂꍇɖ߂l
	 * @return String Ԃliw肳ĂȂꍇdef̒lԂ܂B)
	 */
	public String getString(String key, String def) {
		try {
			return getString(key);
		} catch (Exception e) {}
		return def;
	}

	/**
	 * w肳ꂽL[Őݒ肳ꂽlint^ŕԂ܂B<br>
	 * @param key L[
	 * @return int Ԃliw肳ĂȂꍇnullj
	 */
	public int getInt(String key) {
		return Integer.parseInt(getString(key));
	}

	/**
	 * w肳ꂽL[Őݒ肳ꂽlint^ŕԂ܂BL[ݒ肳ĂȂꍇ͎擾Ɏw肵lԂ܂B<br>
	 * @param key L[
	 * @param def L[Őݒ肳ĂȂꍇɖ߂l
	 * @return int Ԃliw肳ĂȂꍇdef̒lԂ܂B)
	 */
	public int getInt(String key, int def) {
		try {
			return Integer.parseInt(getString(key));
		} catch (Exception e) {}
		
		return def;
	}

	/**
	 * zXg擾܂Bł͍\t@C̒ConfigManager.HOSTNAMEŒT܂L[\t@CɂȂꍇ
	 * }VɊ蓖ĂꂽIPAhX̖̂擾܂B<br>}VɊ蓖ĂꂽIPAhX͗\zǑʂԂꍇ
	 * ̂ŁAlocalhostȊOIPAhX擾ꍇ͖IɃL[ݒ肷邱Ƃ܂B<br.
	 * @return String zXg
	 */
	public static String getHostName() {
		try {
			return getInstance().getString(HOSTNAME);
		} catch (Exception e) {
	    	InetAddress host = null;
	    	try {
				host = InetAddress.getLocalHost();
			} catch (UnknownHostException nhe) {
				return null;
			}
        	return host.getHostName();
        }
    }

    /**
     * s̃ReLXgE[gpXݒ肵܂B<br>
     * 
     * ̃\bh͏T[ubg[hɍs܂B
     * @param		context		s̃T[ubgReĩReLXgE[g
     */
    public void setContext(String context) {
    	ConfigManager.context = context;
    }

    /**
     * s̃ReLXgE[gpX擾܂B<br>
     * ̃\bh͏T[ubg[hɎgp\ɂȂ܂B
     * @return		context		s̃T[ubgReĩReLXgE[g
     * @deprecated ̃\bhWASV4AWASV5AJ2EE 1.3AJ2EE 1,4Ō݊ۂĂ܂B<br>
     * {@link wisdom.core.application.RuntimeContext#getContextPath(HttpServletRequest)}gpĂB
     */
    public static String getContext() {
    	if (context.startsWith("/")) return context;
    	return "/" + context;
    }

}

