package wisdom.core.application;

import java.util.*;
import java.io.*;
import javax.servlet.http.*;

import wisdom.core.ServletRuntimeConfig;
import wisdom.core.runtime.RunTimeServlet;
import wisdom.core.session.MissingSessionObjectException;

/**
 * ZbVւ̃ANZX@`C^[tF[XB<br>
 * ZbVւ̃ANZXHttpSessionł͂ȂÃC^[tF[Xgpčs܂B<br>
 * ̃IuWFNg̃CX^X {@link ServletRuntimeConfig#isEnablesSession()} truêƂɎgp\
 * Ȃ܂BF؍ςۂ{@link ServletRuntimeConfig#isAuthenticateRequired()} ̐ݒɈˑ܂B
 *
 * @author  Takao Kouda
 * @version 1
 * 
 * @see RunTimeServlet
 * @see ServletRuntimeConfig
 * @see IAuthenticate
 *
 */
public interface IUserSession extends Serializable, HttpSessionBindingListener {

	/** 
	 * HttpSessionɂ̃IuWFNg put ۂ̃L[lB
	 */
	public static final String SESSION_NAME = "USER_SESSION";
	
	/**
	 * [U[ID擾܂<br>
	 * @return [U[ID
	 */
	public String getUserid() ;

	/**
	 * [U[擾܂<br>
	 * @return [U[
	 */
	public String getName();
	
	/**
	 * ̃[U[F؍ς܂<br>
	 */
	public boolean isAuthenticated() ;

	/**
	 * ZbVw肳ꂽL[lŐݒ肵܂B
	 * @param		key		ݒ肷ZbṼL[l
	 * param		object	ݒ肷ZbV
	 */
	public void setAttribute(String key, Object object) ;
	
	/**
	 * w肳ꂽL[lŐݒ肳ꂽIuWFNgO܂B
	 * YL[lŐݒ肳ĂȂꍇ͉܂B
	 * @param		key		OZbṼL[l
	 *
	 */
	public void removeAttribute(String key) ;

	/** 
	 * w肳ꂽL[lŃZbV擾܂B
	 * @param		key		擾ZbṼL[l
	 * @exception			MissingSessionObjectException w肳ꂽL[lŃZbV񂪐ݒ肳ĂȂꍇ
	 */
	public Object getAttribute(String key) throws MissingSessionObjectException ;

	/** 
	 * w肳ꂽL[lŃZbV擾܂B
	 * @param		key		擾ZbṼL[l
	 * @param		allowNull	擾ZbVnull̏ꍇB
	 * @exception			MissingSessionObjectException w肳ꂽL[lŃZbV񂪐ݒ肳ĂȂꍇ
	 */
	public Object getAttribute(String key, boolean allowNull) throws MissingSessionObjectException ;
		
	/** 
	 * L[l̃Xg߂܂B
	 * @return		Enumeration		L[l̃Xg
	 */
	public Iterator getAttributeNames() ;
	
	/**
	 * ŐV̑y[Wݒ肵܂B
	 * ̃\bh̓t[[NŐݒ肳܂B
	 * @param		page		ꂽŐṼy[W
	 */
	public void setRecentPage(String page) ;

	/**
	 * ŐVreqidݒ肵܂B
	 * ̃\bh̓t[[NŐݒ肳܂B
	 * @param		reqid		ŐVreqid
	 */
	public void setRecentReqid(String reqid) ;
	/**
	 * y[W̗擾܂B̊Jnԍ0łB
	 * @param		historyNo		
	 * @return		String	
	 */
	public String getPageHistory(int historyNo) ;

	/**
	 * Reqid̗擾܂B̊Jnԍ0łB
	 * @param		historyNo		
	 * @return		String	
	 */
	public String getReqidHistory(int historyNo) ;

	/**
	 * y[W̗String͔zListŎ擾܂B
	 * @return	y[W̗	
	 */
	public List getRecentPages() ;

	/**
	 * Reqid̗܂StingzListŎ擾܂B
	 * @return		Reqid̗
	 */
	public List getRecentReqids() ;

	/**
	 * UserSessionIuWFNgi[ĂHttpSessionIuWFNg擾܂B
	 * @return		HttpSession		UserSessionIuWFNgi[ĂHttpSessionIuWFNg
	 */
	public HttpSession getHttpSession() ;

	/**
	 * \ȃZbVׂăNA܂B<br>
	 * {@link #addUnremovableSessionAttributeName(String) addtUnemovableSessionAttributeName}œo^ꂽȊÕZbV
	 * ׂremove܂B<br>
	 * 
	 */
	public void cleanupRemovableSessionAttributes() ;
	
	/**
	 * s\ȃZbVo^܂B<br>
	 * {@link #cleanupRemovableSessionAttributes cleanupRemovableSessionAttributes}ŃNAΏۊOɂZbVkeyo^܂B
	 * o^ꂽkeyZbV{@link #cleanupRemovableSessionAttributes cleanupRemovableSessionAttributes}ŃNA܂B<br>
	 * @param	key s\ȃZbVƂēo^ZbṼL[
	 */
	public void addUnremovableSessionAttributeName(String key) ;

	
	/**
	 * s\ȃZbVo^܂B<br>
	 * {@link #cleanupRemovableSessionAttributes cleanupRemovableSessionAttributes}ŃNAΏۊOɂZbVkeyo^܂B
	 * o^ꂽkeyZbV{@link #cleanupRemovableSessionAttributes cleanupRemovableSessionAttributes}ŃNA܂B<br>
	 * 
	 * @param	keys s\ȃZbVƂēo^ZbṼL[̔z
	 */
	public void addUnremovableSessionAttributeNames(String[] keys) ;
	
	/**
	 * s\ȃZbV폜܂B<br>
	 * {@link #addUnremovableSessionAttributeName(String) addUnremovableSessionAttributeName}A
	 * {@link #addUnremovableSessionAttributeNames(String[]) addUnremovableSessionAttributeNames}
	 * NAΏۊOƂēo^ꂽkey폜܂B<br>
	 * @param	key s\ȃZbV폜ZbṼL[
	 */
	public void removeUnremovableSessionAttributeName(String key) ;
	

	/**
	 * s\ȃZbṼL[擾܂B<br>
	 * @return	{@link #addUnremovableSessionAttributeName(String) addUnremovableSessionAttributeName}A
	 * {@link #addUnremovableSessionAttributeNames(String[]) addUnremovableSessionAttributeNames}œo^ꂽs\ȃZbṼL[l܂񂾔zB
	 */
	public List getUnremovableSessionAttributeNames() ;

	/**
	 * OAEgs܂B<br>
	 */
	public void logOut() ;


}