package wisdom.core.application;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import wisdom.core.CoreMessageGenerator;
import wisdom.core.CoreObject;
import wisdom.core.request.*;
import wisdom.core.runtime.*;
import wisdom.core.session.SessionTimeOutedException;
import wisdom.core.session.UserSession;

/**
 * AvP[V̎sɍ쐬ꂽIuWFNgAwisdomx.core.applicationpbP[W̎NX擾邽߂̃NX<br>
 * ɓ]JSPwisdomō쐬ꂽIuWFNgɑ΂ăANZX邽߂̐ÓI\bhW߂NXłB
 *
 * @author  Takao Kouda
 * @version 1
 */
public class RuntimeContext extends CoreObject {
	
	/**
	 * forwardꂽJSPŁA{@link IRequestParser }̃CX^X擾܂B<br>
	 * ̃\bh{@link RunTimeServlet }̎sɐꂽ{@link IRequestParser }̃CX^X擾܂B
	 * āA{@link RunTimeServlet }̎sȊOJSPł̃\bhsParameterNotFoundException
	 * o܂B<br>
	 * ̃\bh̓OCĂ邩ۂ܂BOCĂȂꍇASessionTimeOutedException
	 * o܂B<br>
	 * 
	 * @param req HttpServletRequest̃CX^X
	 */
	public static IRequestParser getRequestParserWithSessionCheck(HttpServletRequest req) 
			throws ParameterNotFoundException ,SessionTimeOutedException {
		if (req.getSession(false) == null) 
			throw new SessionTimeOutedException(CoreMessageGenerator.getInstance().getMessage("WSE0020") );
		return getRequestParser(req);
	}

	/**
	 * forwardꂽJSPŁA{@link IRequestParser }̃CX^X擾܂B<br>
	 * ̃\bh{@link RunTimeServlet }̎sɐꂽ{@link IRequestParser }̃CX^X擾܂B
	 * āA{@link RunTimeServlet }̎sȊOJSPł̃\bhsParameterNotFoundException
	 * o܂B<br>
	 * 
	 * @param req HttpServletRequest̃CX^X
	 */
	public static IRequestParser getRequestParser(HttpServletRequest req) throws ParameterNotFoundException {
		IRequestParser rp = (IRequestParser) req.getAttribute(IRequestParser.ATTRIBUTE_NAME);
		
		if ( rp == null) throw new ParameterNotFoundException(CoreMessageGenerator.getInstance().getMessage("WPE0010",IRequestParser.class.getName()));
		return rp;
	}

	/**
	 * forwardꂽJSPŁA{@link IUserSession }̃CX^X擾܂B<br>
	 * ̃\bh{@link RunTimeServlet }̎sɐꂽ{@link IUserSession }̃CX^X擾܂B
	 * 
	 * @param 		req		HttpServletRequest̃CX^X
	 * @return				擾łIUserSessionIuWFNg
	 * @exception			^CAEgAOCĂȂꍇB
	 */
	public static IUserSession getUserSession(HttpServletRequest req) throws SessionTimeOutedException {
		HttpSession hs = req.getSession(false);
		if (hs == null) throw new SessionTimeOutedException(CoreMessageGenerator.getInstance().getMessage("WSE0020"));
		UserSession us = (UserSession)hs.getAttribute(UserSession.SESSION_NAME);
		if (us == null) throw new SessionTimeOutedException(CoreMessageGenerator.getInstance().getMessage("WSE0020"));
		return us;
	}
	
	/**
	 * s̃T[ubgEReLXgpX擾܂B<br>
	 * 
	 * @param req
	 * @return T[ubgEReLXgpX
	 */
	public static String getContextPath(HttpServletRequest req) {
		return req.getContextPath();
	}
	
	/**
	 * {@link IStringValidator }̃CX^X擾܂B<br>
	 * 
	 */
	public static IStringValidator getStringValidator() {
		return new StringValidator();
	}

}