package wisdom.core.command;

import java.sql.*;
import java.util.*;

import wisdom.core.CoreMessageGenerator;
import wisdom.core.CoreObject;
import wisdom.core.MessageGenerator;
import wisdom.core.application.IBatchCommand;
import wisdom.core.application.IBatchHandler;
import wisdom.core.application.IHandler;
import wisdom.core.runtime.BatchHandler;

/**
 * {@link IBatchCommand}̎NX<br>
 * ̃NX̃CX^X͎NXgɂ쐬Kv܂B
 * 
 * 2004/6/9 {@link wisdom.core.application.IHandler}̃CX^Xϐ̒ǉ
 * @author  Takao Kouda
 * @version 1
 */
public abstract class BatchCommand extends CoreObject implements IBatchCommand {

	/**
	 * TuNXŎgpł{@link IHandler }̃CX^XłB
	 */
	protected IHandler h = null;
	
	/**
	 * TuNXŎgpł{@link IBatchHandler }̃CX^XłB
	 */
	protected IBatchHandler bh = null;
	/**
	 * TuNXŎgpł{@link MessageGenerator }̃CX^XłB
	 * {@link CoreMessageGenerator }ɂȂ܂B
	 */
	protected MessageGenerator messageGenerator = null;
		
	/**
	 * RXgN^
	 *
	 */
	public BatchCommand() { 
		super(); 
		setMessageGenerator(CoreMessageGenerator.getInstance());
	}
	
	/**
	 * R}hs܂
	 * @exception Exception 
	 */
	public void execute() throws Exception {
		this.bh = new BatchHandler(this);
		this.h = bh;
		trace("execute","executing.....");
		BatchHandler bh_ = (BatchHandler)bh;
		try {
			_execute();
			if (bh != null) bh_.commitAllConnections();
		} catch (Exception e) {
			error(e);
			if (bh != null) bh_.rollBackAllConnections();
			throw e;
		} finally {
			if (bh != null) bh_.closeAllConnections();
		}		
		trace("execute","executed");
	}

	/**
	 * R}hs܂
	 * @exception Exception 
	 */
	protected abstract void _execute() throws Exception;


	/**
	 * R}h̃NX擾܂B
	 * ̃\bhgetClass().getName()Zk邽߂Ɏgp܂BObject.getClass().getName()łB
	 */
	public String getName() {
		return getClass().getName();
	}	
	public void setMessageGenerator(MessageGenerator messageGenerator) {
		this.messageGenerator = messageGenerator;
	}

}