package wisdom.core.connections;

import java.util.Hashtable;

/**
 * ConnectionManager IuWFNg𐶐 FactoryNX<br>
 *
 * @author  Takao Kouda
 * @version 1
 *
 */
public class ConnectionManagerFactory {

	private static Hashtable ht = new Hashtable();

	/** 
	  * ConnectionManagerIuWFNg𐶐܂B
	  * @param def ConnectionManagerIuWFNgENX
	  * @return ConnPool ꂽConnectionManagerIuWFNg
	  * @exception Exception 
	  */	
	public static synchronized ConnectionManager create(ConnectionDef def) throws Exception {
		ConnectionManager conm = (ConnectionManager)ht.get(def.getDefineName());
		if (conm != null) {
			return conm;
		}
		conm = (ConnectionManager)Class.forName(def.getConnectionManagerName()).newInstance();
		conm.initial(def);
		ht.put(def.getDefineName(), conm);
		return conm;
	}
}
