package wisdom.core.connections;

import java.util.Vector;
import java.util.Iterator;
import java.util.Calendar;

import java.net.URL;
import java.sql.Connection;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.RowId;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.PreparedStatement;
import java.sql.CallableStatement;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Ref;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Array;
import java.sql.SQLException;
import java.sql.SQLWarning;

import java.io.InputStream;
import java.io.Reader;

import wisdom.core.CoreObject;

/**
 * java.sql.Statement bvAN[Y̊ǗManaginConnectionŎNXB
 * 
 * @author  Takao Kouda
 * @version 1
 */
public class ManagedPreparedStatement extends CoreObject implements PreparedStatement {
	private Object invoker = null;	
	protected String sql = null;
	private PreparedStatement stmt = null;
	private Vector vecrs = null;
	private ResultSet rs = null;
	private boolean closed = false;

	/**
	 * RXgN^
	 */	
	public ManagedPreparedStatement(Object invoker, PreparedStatement stmt) {
		super();
		this.invoker = invoker;		
		this.stmt = stmt;
	}
	
    /**
     * PreparedStatementĂ铯\bhs܂B
     *
     * @param 		sql		ʏÓI SQL SELECT 
     * @return 				w肳ꂽNG[ɂč쐬ꂽf[^܂ ResultSet IuWFNgBnull ɂ͂ȂȂ
     * @exception 			f[^x[XANZXG[ꍇ
     */
	public ResultSet executeQuery(String sql) throws SQLException {
		return stmt.executeQuery(sql);
	}

    /**
     * PreparedStatementĂ铯\bhs܂B
     *
     * @param 		sql		SQL INSERT AUPDATE A܂ DELETE A邢͉ԂȂ SQL 
     * @return 				INSERT AUPDATE ADELETE ̏ꍇ͍sBԂȂ SQL ̏ꍇ 0
     * @exception 			f[^x[XANZXG[ꍇ
     */      
	public int executeUpdate(String sql) throws SQLException {
		return stmt.executeUpdate(sql);
	}
 
    /**
     * PreparedStatementĂ铯\bhs܂B
     * 
     * @exception 			f[^x[XANZXG[ꍇ
     */    
	public void close() throws SQLException {
		closeCheck();
		stmt.close();
		closed = true;
	}
 
    /**
     * PreparedStatementĂ铯\bhs܂B
     * 
     * @return 				݂̍ős̐lB[͖Ӗ
     * @exception 			f[^x[XANZXG[ꍇ
     */   
	public int getMaxFieldSize() throws SQLException {
		return stmt.getMaxFieldSize();
	}
 
 
    /**
     * PreparedStatementĂ铯\bhs܂B
     *
     * @param 		max		VőTCY̐lB[͖Ӗ
     * @exception 			f[^x[XANZXG[ꍇ
     */   
	public void setMaxFieldSize(int max) throws SQLException {
		stmt.setMaxFieldSize(max);
	}

    /**
     * PreparedStatementĂ铯\bhs܂B
     * 
     * @return 				݂̍ős̐lB[͖Ӗ
     * @exception 			f[^x[XANZXG[ꍇ
     */ 
	public int getMaxRows() throws SQLException {
		return stmt.getMaxRows();
	}
 
    /**
     * PreparedStatementĂ铯\bhs܂B
     * @param 		max		Vős̐lB[͖Ӗ
     * @exception 			f[^x[XANZXG[ꍇ
     */   
	public void setMaxRows(int max) throws SQLException {
		stmt.setMaxRows(max);
	}

    /**
     * PreparedStatementĂ铯\bhs܂B
     * @param 		enable	Lɂꍇ trueAɂꍇ false
     * @exception 			f[^x[XANZXG[ꍇ
     */            
	public void setEscapeProcessing(boolean enable) throws SQLException {
		stmt.setEscapeProcessing(enable);
	}

    /**
     * PreparedStatementĂ铯\bhs܂B
     *
     * @return 				݂̃NG[^CAEg̐l̕bB[͖Ӗ
     * @exception 			f[^x[XANZXG[ꍇ
     */    
	public int getQueryTimeout() throws SQLException {
		return stmt.getQueryTimeout();
	}
    
    /**
     * PreparedStatementĂ铯\bhs܂B
     * 
     * @param 		seconds	VNG[^CAEg̐l̕bB[͖Ӗ
     * @exception 			f[^x[XANZXG[ꍇ
     */            
	public void setQueryTimeout(int seconds) throws SQLException {
		stmt.setQueryTimeout(seconds);
	}
    
    /**
     * PreparedStatementĂ铯\bhs܂B
     *
     * @exception 			f[^x[XANZXG[ꍇ
     */     
	public void cancel() throws SQLException {
		stmt.cancel();
	}
    
    /**
     * PreparedStatementĂ铯\bhs܂B
     *
     * @return 				IuWFNg܂ null
     * @exception 			f[^x[XANZXG[ꍇ
     */    
	public SQLWarning getWarnings() throws SQLException {
		return stmt.getWarnings();
	}
 
    /**
     * PreparedStatementĂ铯\bhs܂B
     *
     * @exception 			f[^x[XANZXG[ꍇ
     */     
	public void clearWarnings() throws SQLException {
		stmt.clearWarnings();
	}
 
    /**
     * PreparedStatementĂ铯\bhs܂B
     * 
     * @param 		name	VJ[\BڑňӂɂKv
     * @exception 			f[^x[XANZXG[ꍇ
     */   
	public void setCursorName(String name) throws SQLException {
		stmt.setCursorName(name);
	}
  
    /**
     * PreparedStatementĂ铯\bhs܂B
     * @param 		sql		Cӂ SQL 
     * @return 				̌ʂ ResultSet IuWFNg̏ꍇ trueBXVJEgł邩A܂͌ʂȂꍇ false
     * @exception 			f[^x[XANZXG[ꍇ
     */  
	public boolean execute(String sql) throws SQLException {
		return stmt.execute(sql);
	}
 
 
    /**
     * PreparedStatementĂ铯\bhs܂B
     *
     * @return 				ResultSet IuWFNgƂĂ݂̌̌ʁBXVJEgł邩A܂͌ʂȂꍇ null
     * @exception 			f[^x[XANZXG[ꍇ
     */       
	public ResultSet getResultSet() throws SQLException {
		return stmt.getResultSet();
	}
 
    /**
     * PreparedStatementĂ铯\bhs܂B
     *
     * @return 				XVJEgĂ݂̌̌ʁB݂̌ʂ ResultSet IuWFNgł邩A܂͌ʂȂꍇ -1
     * @exception 			f[^x[XANZXG[ꍇ
     */     
	public int getUpdateCount() throws SQLException {
		return stmt.getUpdateCount();
	}
    
    /**
     * PreparedStatementĂ铯\bhs܂B
     *
     * @return 				̌ʂ ResultSet IuWFNg̏ꍇ trueBXVJEgł邩A܂͌ʂȂꍇ false
     * @exception 			f[^x[XANZXG[ꍇ
     */     
	public boolean getMoreResults() throws SQLException {
		return stmt.getMoreResults();
	}
    
    /**
     * PreparedStatementĂ铯\bhs܂B
     *
     * @param direction	s鏉
     * @exception 			f[^x[XANZXG[ꍇA܂͎w肳ꂽ ResultSet.FETCH_FORWARDAResultSet.FETCH_REVERSEA܂ ResultSet.FETCH_UNKNOWN ̂ǂłȂꍇ
     */     
	public void setFetchDirection(int direction) throws SQLException {
		stmt.setFetchDirection(direction);
	}
    
 
    /**
     * PreparedStatementĂ铯\bhs܂B
     *
     * @return 				 Statement IuWFNg琶ꂽʃZbg̃ftHg̃tFb`
     * @exception 			f[^x[XANZXG[ꍇ
     */     
	public int getFetchDirection() throws SQLException {
		return stmt.getFetchDirection();
	}
    
    /**
     * PreparedStatementĂ铯\bhs܂B
     *
     * @param 		rows	tFb`s 
     * @exception 			f[^x[XANZXG[ꍇA܂͏ 0 <= rows <= this.getMaxRows() Ȃꍇ
     */   
	public void setFetchSize(int rows) throws SQLException {
		stmt.setFetchSize(rows);
	}

    /**
     * PreparedStatementĂ铯\bhs܂B
     *
     * @return 			 Statement IuWFNg琶ꂽʃZbg̃ftHg̃tFb`TCY
     * @exception 		f[^x[XANZXG[ꍇ
     */
	public int getFetchSize() throws SQLException {
		return stmt.getFetchSize();
	}

    /**
     * PreparedStatementĂ铯\bhs܂B
     *
     * @return			ResultSet.CONCUR_READ_ONLY ܂ ResultSet.CONCUR_UPDATABLE
     */    
	public int getResultSetConcurrency() throws SQLException {
		return stmt.getResultSetConcurrency();
	}
    
    /**
     * PreparedStatementĂ铯\bhs܂B
     *
     * @return		 		ResultSet.TYPE_FORWARD_ONLYAResultSet.TYPE_SCROLL_INSENSITIVEA܂ ResultSet.TYPE_SCROLL_SENSITIVE ̂ 1 
     */    
	public int getResultSetType()  throws SQLException {
		return stmt.getResultSetType();
	}
    
    /**
     * PreparedStatementĂ铯\bhs܂B
     *
     * @param 		sql 	ʏÓI SQL INSERT A܂ UPDATE 
     * @exception 			f[^x[XANZXG[ꍇA܂̓hCoob`T|[gĂȂꍇ
     */
	public void addBatch(String sql) throws SQLException {
		stmt.addBatch(sql);
	}
	/**
     * PreparedStatementĂ铯\bhs܂B
	 * 
	 * @exception  	f[^x[XANZXG[ꍇA܂̓hCoob`T|[gĂȂꍇ
	 */
	public void clearBatch() throws SQLException {
		stmt.clearBatch();
	}

	/**
     * PreparedStatementĂ铯\bhs܂B
     *
     * @return 				ob`̃R}hƂ 1 ̗vfi[ĂXVJEg̔zB
     *						z̗vf̓R}hob`ɒǉꂽŕׂB
     * @exception			f[^x[XANZXG[ꍇA܂̓hCoob`T|[gĂȂꍇ
     */
    public int[] executeBatch() throws SQLException {
		return stmt.executeBatch();
	}

	/**
     * PreparedStatementĂ铯\bhs܂B
     *
     * @return 				̕𐶐ڑ
     * @exception			f[^x[XANZXG[ꍇ
     */
	public Connection getConnection()  throws SQLException {
		return stmt.getConnection(); 
	}
	
	/**
	 * PreparedStatementcloseĂ邩ׂ܂B
	 * @return 				StatementcloseĂꍇtrueB
	 */
	public boolean isClosed() {
		return closed;
	}
	/**
     * PreparedStatementĂ铯\bhs܂B
     *
     * @return					NG[ɂč쐬ꂽf[^܂ ResultSet IuWFNgBnull ɂ͂ȂȂ
     * @exception				f[^x[XANZXG[ꍇ
     */	
	public ResultSet executeQuery() throws SQLException {
		ManagedResultSet mrs = new ManagedResultSet(invoker, stmt.executeQuery());
		if (vecrs == null) vecrs = new Vector();
		vecrs.add(mrs);
		return mrs;
	}
	
	/**
     * PreparedStatementĂ铯\bhs܂B
     *
     * @exception				f[^x[XANZXG[ꍇ
     */	
	public boolean execute() throws SQLException {
		return stmt.execute();
	}

	/**
     * PreparedStatementĂ铯\bhs܂B
     * 
     * @return 					INSERT AUPDATE ADELETE ̏ꍇ͍sBԂȂ SQL ̏ꍇ 0
     * @exception				f[^x[XANZXG[ꍇ
     */	
	public int executeUpdate() throws SQLException {
		return stmt.executeUpdate();
	}
	
	/**
     * PreparedStatementĂ铯\bhs܂B
     *
     * @exception				f[^x[XANZXG[ꍇ
     */	
	public void addBatch() throws SQLException {
		stmt.addBatch();
	}
	/**
     * PreparedStatementĂ铯\bhs܂B
     *
     * @param	parameterIndex	ŏ̃p[^ 1A2 Ԗڂ̃p[^ 2AȂǂƂ
     * @param	sqlType			java.sql.Types Œ` SQL ^R[h
     * @exception				f[^x[XANZXG[ꍇ
     */	
	public void setNull(int parameterIndex, int sqlType) throws SQLException {
		stmt.setNull(parameterIndex, sqlType);
	}
	/**
     * PreparedStatementĂ铯\bhs܂B
     *
     * @param	parameterIndex	ŏ̃p[^ 1A2 Ԗڂ̃p[^ 2AȂǂƂ
     * @param	x				p[^l
     * @exception				f[^x[XANZXG[ꍇ
     */	
	public void setBoolean(int parameterIndex, boolean x) throws SQLException {
		stmt.setBoolean(parameterIndex, x);
	}
	/**
     * PreparedStatementĂ铯\bhs܂B
     *
     * @param	parameterIndex	ŏ̃p[^ 1A2 Ԗڂ̃p[^ 2AȂǂƂ
     * @param	x				p[^l
     * @exception				f[^x[XANZXG[ꍇ
     */	
	public void setByte(int parameterIndex, byte x) throws SQLException {
		stmt.setByte(parameterIndex, x);
	}
	/**
     * PreparedStatementĂ铯\bhs܂B
     *
     * @param	parameterIndex	ŏ̃p[^ 1A2 Ԗڂ̃p[^ 2AȂǂƂ
     * @param	x				p[^l
     * @exception				f[^x[XANZXG[ꍇ
     */	
	public void setShort(int parameterIndex, short x) throws SQLException {
		stmt.setShort(parameterIndex, x);
	}
	/**
     * PreparedStatementĂ铯\bhs܂B
     *
     * @param	parameterIndex	ŏ̃p[^ 1A2 Ԗڂ̃p[^ 2AȂǂƂ
     * @param	x				p[^l
     * @exception				f[^x[XANZXG[ꍇ
     */	
	public void setInt(int parameterIndex, int x) throws SQLException {
		stmt.setInt(parameterIndex, x);
	}
	/**
     * PreparedStatementĂ铯\bhs܂B
     *
     * @param	parameterIndex	ŏ̃p[^ 1A2 Ԗڂ̃p[^ 2AȂǂƂ
     * @param	x				p[^l
     * @exception				f[^x[XANZXG[ꍇ
     */	
	public void setLong(int parameterIndex, long x) throws SQLException {
		stmt.setLong(parameterIndex, x);
	}
	/**
     * PreparedStatementĂ铯\bhs܂B
     *
     * @param	parameterIndex	ŏ̃p[^ 1A2 Ԗڂ̃p[^ 2AȂǂƂ
     * @param	x				p[^l
     * @exception				f[^x[XANZXG[ꍇ
     */	
	public void setFloat(int parameterIndex, float x) throws SQLException {
		stmt.setFloat(parameterIndex, x);
	}
	/**
     * PreparedStatementĂ铯\bhs܂B
     *
     * @param	parameterIndex	ŏ̃p[^ 1A2 Ԗڂ̃p[^ 2AȂǂƂ
     * @param	x				p[^l
     * @exception				f[^x[XANZXG[ꍇ
     */	
	public void setDouble(int parameterIndex, double x) throws SQLException {
		stmt.setDouble(parameterIndex, x);
	}
	/**
     * PreparedStatementĂ铯\bhs܂B
     *
     * @param	parameterIndex	ŏ̃p[^ 1A2 Ԗڂ̃p[^ 2AȂǂƂ
     * @param	x				p[^l
     * @exception				f[^x[XANZXG[ꍇ
     */	
	public void setBigDecimal(int parameterIndex, java.math.BigDecimal x) throws SQLException {
		stmt.setBigDecimal(parameterIndex, x);
	}
	/**
     * PreparedStatementĂ铯\bhs܂B
     *
     * @param	parameterIndex	ŏ̃p[^ 1A2 Ԗڂ̃p[^ 2AȂǂƂ
     * @param	x				p[^l
     * @exception				f[^x[XANZXG[ꍇ
     */	
	public void setString(int parameterIndex, String x) throws SQLException{
		stmt.setString(parameterIndex, x);
	}
	/**
     * PreparedStatementĂ铯\bhs܂B
     *
     * @param	parameterIndex	ŏ̃p[^ 1A2 Ԗڂ̃p[^ 2AȂǂƂ
     * @param	x				p[^l
     * @exception				f[^x[XANZXG[ꍇ
     */	
	public void setBytes(int parameterIndex, byte x[]) throws SQLException {
		stmt.setBytes(parameterIndex, x);
	}
	/**
     * PreparedStatementĂ铯\bhs܂B
     *
     * @param	parameterIndex	ŏ̃p[^ 1A2 Ԗڂ̃p[^ 2AȂǂƂ
     * @param	x				p[^l
     * @exception				f[^x[XANZXG[ꍇ
     */	
	public void setDate(int parameterIndex, java.sql.Date x) throws SQLException {
		stmt.setDate(parameterIndex, x);
	}
	/**
     * PreparedStatementĂ铯\bhs܂B
     *
     * @param	parameterIndex	ŏ̃p[^ 1A2 Ԗڂ̃p[^ 2AȂǂƂ
     * @param	x				p[^l
     * @exception				f[^x[XANZXG[ꍇ
     */	
	public void setTime(int parameterIndex, java.sql.Time x)  throws SQLException {
		stmt.setTime(parameterIndex, x);
	}
	/**
     * PreparedStatementĂ铯\bhs܂B
     *
     * @param	parameterIndex	ŏ̃p[^ 1A2 Ԗڂ̃p[^ 2AȂǂƂ
     * @param	x				p[^l
     * @exception				f[^x[XANZXG[ꍇ
     */	
	public void setTimestamp(int parameterIndex, java.sql.Timestamp x) throws SQLException {
		stmt.setTimestamp(parameterIndex, x);
	}
	/**
     * PreparedStatementĂ铯\bhs܂B
     *
     * @param	parameterIndex	ŏ̃p[^ 1A2 Ԗڂ̃p[^ 2AȂǂƂ
     * @param	x				ASCII p[^l܂ Java ̓Xg[
     * @param	length 			Xg[̃oCg
     * @exception				f[^x[XANZXG[ꍇ
     */	
	public void setAsciiStream(int parameterIndex, java.io.InputStream x, int length) throws SQLException {
		stmt.setAsciiStream(parameterIndex, x, length);
	}
	/**
     * PreparedStatementĂ铯\bhs܂B
     *
     * @param	parameterIndex	ŏ̃p[^ 1A2 Ԗڂ̃p[^ 2AȂǂƂ
     * @param	x				UNICODE p[^l܂ Java ̓Xg[
     * @param	length 			Xg[̃oCg
     * @exception				f[^x[XANZXG[ꍇ
     */
	public void setUnicodeStream(int parameterIndex, java.io.InputStream x, int length) throws SQLException {
		stmt.setUnicodeStream(parameterIndex, x, length);
	}
	/**
     * PreparedStatementĂ铯\bhs܂B
     *
     * @param	parameterIndex	ŏ̃p[^ 1A2 Ԗڂ̃p[^ 2AȂǂƂ
     * @param	x				oCip[^l܂ Java ̓Xg[
     * @param	length 			Xg[̃oCg
     * @exception				f[^x[XANZXG[ꍇ
     */	
	public void setBinaryStream(int parameterIndex, java.io.InputStream x,  int length) throws SQLException {
		stmt.setBinaryStream(parameterIndex, x, length);
	}
	/**
     * PreparedStatementĂ铯\bhs܂B
     *
     * @exception				f[^x[XANZXG[ꍇ
     */	
	public void clearParameters() throws SQLException {
		stmt.clearParameters();
	}
	/**
     * PreparedStatementĂ铯\bhs܂B
     *
     * @param	parameterIndex	ŏ̃p[^ 1A2 Ԗڂ̃p[^ 2AȂǂƂ
     * @param	x				̓p[^l܂ރIuWFNg
     * @param	targetSqlType	f[^x[Xɑ (java.sql.Types Œ`) SQL ^BXP[ŁAɌ^ł
     * @param 	scale			java.sql.Types.DECIMAL  java.sql.Types.NUMERIC ^ł́A_ȉ̌Bقׂ̂Ă̌^ł́A̒l͖
     * @exception				f[^x[XANZXG[ꍇ
     */	
	public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
		stmt.setObject(parameterIndex, x, targetSqlType, scale);
	}
	/**
     * PreparedStatementĂ铯\bhs܂B
     *
     * @param	parameterIndex	ŏ̃p[^ 1A2 Ԗڂ̃p[^ 2AȂǂƂ
     * @param	x				̓p[^l܂ރIuWFNg
     * @param	targetSqlType	f[^x[Xɑ (java.sql.Types Œ`) SQL ^BXP[ŁAɌ^ł
     * @exception				f[^x[XANZXG[ꍇ
     */	
	public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
		stmt.setObject(parameterIndex, x, targetSqlType);
	}
	/**
     * PreparedStatementĂ铯\bhs܂B
     *
     * @param	parameterIndex	ŏ̃p[^ 1A2 Ԗڂ̃p[^ 2AȂǂƂ
     * @param	x				̓p[^l܂ރIuWFNg
     * @exception				f[^x[XANZXG[ꍇ
     */	
	public void setObject(int parameterIndex, Object x) throws SQLException {
		stmt.setObject(parameterIndex, x);
	}
	/**
     * PreparedStatementĂ铯\bhs܂B
     *
     * @param	parameterIndex	ŏ̃p[^ 1A2 Ԗڂ̃p[^ 2AȂǂƂ
     * @param	reader			UNICODE f[^܂ Java [_
     * @param	length			Xg[̕
     * @exception				f[^x[XANZXG[ꍇ
     */	
	public void setCharacterStream(int parameterIndex, java.io.Reader reader, int length) throws SQLException {
		stmt.setCharacterStream(parameterIndex, reader, length);
	}
	/**
     * PreparedStatementĂ铯\bhs܂B
     *
     * @param	i				ŏ̃p[^ 1A2 Ԗڂ̃p[^ 2AȂǂƂ
     * @param	x				SQL REF l
     * @exception				f[^x[XANZXG[ꍇ
     */	
	public void setRef(int i, Ref x) throws SQLException {
		stmt.setRef(i, x);
	}
	/**
     * PreparedStatementĂ铯\bhs܂B
     *
     * @param	i				ŏ̃p[^ 1A2 Ԗڂ̃p[^ 2AȂǂƂ
     * @param	x				SQL BLOB l}bsO Blob IuWFNg
     * @exception				f[^x[XANZXG[ꍇ
     */	
	public void setBlob(int i, Blob x) throws SQLException {
		stmt.setBlob(i, x);
	}
	/**
     * PreparedStatementĂ铯\bhs܂B
     *
     * @param	i				ŏ̃p[^ 1A2 Ԗڂ̃p[^ 2AȂǂƂ
     * @param	x				SQL CLOB l}bsO Clob IuWFNg
     * @exception				f[^x[XANZXG[ꍇ
     */	
	public void setClob(int i, Clob x) throws SQLException {
		stmt.setClob(i, x);
	}
	/**
     * PreparedStatementĂ铯\bhs܂B
     *
     * @param	i				ŏ̃p[^ 1A2 Ԗڂ̃p[^ 2AȂǂƂ
     * @param	x				SQL ARRAY l}bsO Array IuWFNg
     * @exception				f[^x[XANZXG[ꍇ
     */	
	public void setArray(int i, Array x) throws SQLException {
		stmt.setArray(i, x);
	}
	/**
     * PreparedStatementĂ铯\bhs܂B
     *
     * @return 					IuWFNg̃J̋Lq
     * @exception				f[^x[XANZXG[ꍇ
     */	
	public ResultSetMetaData getMetaData() throws SQLException {
		return stmt.getMetaData();
	}
	/**
     * PreparedStatementĂ铯\bhs܂B
     *
     * @param	parameterIndex	ŏ̃p[^ 1A2 Ԗڂ̃p[^ 2AȂǂƂ
     * @param	x				p[^l
     * @param	cal				hCot쐬邽߂Ɏgp Calendar IuWFNg
     * @exception				f[^x[XANZXG[ꍇ
     */	
	public void setDate(int parameterIndex, java.sql.Date x, Calendar cal) throws SQLException {
		stmt.setDate(parameterIndex, x, cal);
	}
	/**
     * PreparedStatementĂ铯\bhs܂B
     *
     * @param	parameterIndex	ŏ̃p[^ 1A2 Ԗڂ̃p[^ 2AȂǂƂ
     * @param	x				p[^l
     * @param	cal				hCot쐬邽߂Ɏgp Calendar IuWFNg
     * @exception				f[^x[XANZXG[ꍇ
     */	
	public void setTime(int parameterIndex, java.sql.Time x, Calendar cal) throws SQLException {
		stmt.setTime(parameterIndex, x, cal);
	}
	/**
     * PreparedStatementĂ铯\bhs܂B
     *
     * @param	parameterIndex	ŏ̃p[^ 1A2 Ԗڂ̃p[^ 2AȂǂƂ
     * @param	x				p[^l
     * @param	cal				hCot쐬邽߂Ɏgp Calendar IuWFNg
     * @exception				f[^x[XANZXG[ꍇ
     */	
	public void setTimestamp(int parameterIndex, java.sql.Timestamp x, Calendar cal) throws SQLException {
		stmt.setTimestamp(parameterIndex, x, cal);
	}
	/**
     * PreparedStatementĂ铯\bhs܂B
     *
     * @param	parameterIndex	ŏ̃p[^ 1A2 Ԗڂ̃p[^ 2AȂǂƂ
     * @param	sqlType			java.sql.Types ̒l
     * @param	typeName		SQL [U`^̊Sw̖OBp[^[U`^ł REF łȂꍇ͖
     * @exception				f[^x[XANZXG[ꍇ
     */	
	public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
		stmt.setNull(parameterIndex, sqlType, typeName);
	}
	/**
     * ResultSetcloseĂ邩ׂ܂B
     * AN[YĂȂResultSetꍇɂ́Ã\bhɂN[YsAxo͂܂B
     */	
	private void closeCheck()  {
		StringBuffer sb = new StringBuffer();
		/* ResultSetIuWFNg̃`FbN */
		if (vecrs != null) {
			for (Iterator i = vecrs.iterator(); i.hasNext() ;) {
				ManagedResultSet rs = (ManagedResultSet)i.next();
				if (!rs.isClosed()) {
					sb.append("\n\t\t\t -> ")
					.append(rs.getClass().getName())
					.append("(").append(rs.hashCode()).append(")")
					.append(" (Statement) ")
					.append(sql)
					.append("\n\t\t\t\t -> ");
					try {
						rs.close();
						sb.append("closed.");
					} catch (SQLException sqe) {
						sb.append("failured to close.\t").append(sqe.getMessage());
					}
				}
				rs.toNull();
				rs = null;
			}
		}

		if (sb.length() == 0) { return; }

		warning(new StringBuffer("\n[warning] Some SQL statement resources ware not closed, attempted to close below \n")
							.append("\n           invoker class : ").append(invoker.getClass().getName())
							.append(sb.toString())
				);
	}
	protected void toNull() {
		stmt = null;		
	}
	
	// java 1.6 
	public boolean getMoreResults(int current) throws SQLException {
		return stmt.getMoreResults(current);
	}
	public ResultSet getGeneratedKeys() throws SQLException {
		ManagedResultSet mrs = new ManagedResultSet(invoker, stmt.getGeneratedKeys());
		if (vecrs == null) vecrs = new Vector();
		vecrs.add(mrs);
		return mrs;
	}
	public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
		return stmt.executeUpdate(sql, autoGeneratedKeys);
	}
	public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
		return stmt.executeUpdate(sql, columnIndexes);
	}
	public int executeUpdate(String sql, String[] columnNames) throws SQLException {
		return stmt.executeUpdate(sql, columnNames);
	}
	public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
		return stmt.execute(sql, autoGeneratedKeys);
	}
	public boolean execute(String sql,  int[] columnIndexes) throws SQLException {
		return stmt.execute(sql, columnIndexes);
	}
	public boolean execute(String sql, String[] columnNames) throws SQLException {
		return stmt.execute(sql, columnNames);
	}
	public int getResultSetHoldability() throws SQLException {
		return stmt.getResultSetHoldability();
	}
	public void setPoolable(boolean poolable) throws SQLException {
		stmt.setPoolable(poolable);
	}
	public boolean isPoolable() throws SQLException {
		return stmt.isPoolable();
	}
	
	public void setURL(int parameterIndex, URL x) throws SQLException {
		stmt.setURL(parameterIndex, x);
	}

	public ParameterMetaData getParameterMetaData() throws SQLException {
		return stmt.getParameterMetaData();
	}

	public void setRowId(int parameterIndex, RowId x) throws SQLException {
		stmt.setRowId(parameterIndex, x);
	}

	public void setNString(int parameterIndex, String value)
			throws SQLException {
		stmt.setNString(parameterIndex, value);
	}

	public void setNCharacterStream(int parameterIndex, Reader value,
			long length) throws SQLException {
		stmt.setNCharacterStream(parameterIndex, value, length);
	}

	public void setNClob(int parameterIndex, NClob value) throws SQLException {
		stmt.setNClob(parameterIndex, value);
	}

	public void setClob(int parameterIndex, Reader reader, long length)
			throws SQLException {
		stmt.setClob(parameterIndex, reader, length);
	}

	public void setBlob(int parameterIndex, InputStream inputStream, long length)
			throws SQLException {
		stmt.setBlob(parameterIndex, inputStream, length);
	}

	public void setNClob(int parameterIndex, Reader reader, long length)
			throws SQLException {
		stmt.setNClob(parameterIndex, reader, length);
	}

	public void setSQLXML(int parameterIndex, SQLXML xmlObject)
			throws SQLException {
		stmt.setSQLXML(parameterIndex, xmlObject);
	}

	public void setAsciiStream(int parameterIndex, InputStream x, long length)
			throws SQLException {
		stmt.setAsciiStream(parameterIndex, x, length);
	}

	public void setBinaryStream(int parameterIndex, InputStream x, long length)
			throws SQLException {
		stmt.setBinaryStream(parameterIndex, x, length);
	}

	public void setCharacterStream(int parameterIndex, Reader reader,
			long length) throws SQLException {
		stmt.setCharacterStream(parameterIndex, reader, length);
	}

	public void setAsciiStream(int parameterIndex, InputStream x)
			throws SQLException {
		stmt.setAsciiStream(parameterIndex, x);
	}

	public void setBinaryStream(int parameterIndex, InputStream x)
			throws SQLException {
		stmt.setBinaryStream(parameterIndex, x);
	}

	public void setCharacterStream(int parameterIndex, Reader reader)
			throws SQLException {
		stmt.setCharacterStream(parameterIndex, reader);
	}

	public void setNCharacterStream(int parameterIndex, Reader value)
			throws SQLException {
		stmt.setNCharacterStream(parameterIndex, value);
	}

	public void setClob(int parameterIndex, Reader reader) throws SQLException {
		stmt.setClob(parameterIndex, reader);
	}

	public void setBlob(int parameterIndex, InputStream inputStream)
			throws SQLException {
		stmt.setBlob(parameterIndex, inputStream);
	}

	public void setNClob(int parameterIndex, Reader reader) throws SQLException {
		stmt.setNClob(parameterIndex, reader);
	}

	// java.sql.Wrapper
	public boolean isWrapperFor(Class iface) throws SQLException {
		return stmt.isWrapperFor(iface);
	}
	public Object  unwrap(Class iface) throws SQLException {
		return stmt.unwrap(iface);
	}	
	
	
}
