package wisdom.core.connections;

import java.io.*;
import java.sql.*;
import java.math.*;
import java.net.URL;
import java.util.*;

import wisdom.core.CoreObject;
import wisdom.core.Log;
import wisdom.core.LogFactory;

/**
 *
 * java.sql.ResultSet bvAResultSetNXŎsꂽg[XNXB
 * 
 * @author  Tatsuya Inaba 
 * @version 0.90, 16/Dec/2002
 */
public class TraceResultSet extends CoreObject implements ResultSet {
	private Object invoker = null;

	private ResultSet rs = null;
	private Log l = LogFactory.create();
	private TraceHelper th = TraceHelper.getInstance();
	private PrintWriter out = null;

	/**
	 * RXgN^
	 */	
	public TraceResultSet(Object invoker, ResultSet rs) {
		super();
		this.invoker = invoker;
		this.rs = rs;
		out = l.getWriter();		
	}
	public void close() throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "close()"));
		out.flush();
		rs.close();
	}
	public boolean absolute(int row) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "absolute(row)", Integer.toString(row)));
		out.flush();
		return rs.absolute(row);
	}
	public void afterLast() throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "afterLast()"));
		out.flush();
		rs.afterLast();
	}
	public void beforeFirst() throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "beforeFirst()"));
		out.flush();
		rs.beforeFirst();
	}
	public void cancelRowUpdates() throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "cancelRowUpdates()"));
		out.flush();
		rs.cancelRowUpdates();
	}
	public void clearWarnings() throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "clearWarnings()"));
		out.flush();
		rs.clearWarnings();
	}
	public void deleteRow() throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "deleteRow()"));
		out.flush();
		rs.deleteRow();
	}
	public int findColumn(String columnName) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "findColumn(columnName)", columnName));
		out.flush();
		return rs.findColumn(columnName);
	}
	public boolean first() throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "first()"));
		out.flush();
		return rs.first();
	}
	public Array getArray(int i) throws SQLException {
		Array o = rs.getArray(i);
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "getArray(i)", Integer.toString(i), o));
		out.flush();
		return o;
	}
	public Array getArray(String colName) throws SQLException {
		Array o = rs.getArray(colName);
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "getArray(colName)", colName, o));
		out.flush();
		return o;
	}
	public InputStream getAsciiStream(int columnIndex) throws SQLException {
		InputStream o = rs.getAsciiStream(columnIndex);
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "getAsciiStream(columnIndex)", Integer.toString(columnIndex), o));
		out.flush();
		return o;
	}
	public InputStream getAsciiStream(String columnName) throws SQLException {
		InputStream o = rs.getAsciiStream(columnName);
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "getAsciiStream(columnName)", columnName, o));
		out.flush();
		return o;
	}
	public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
		BigDecimal o = rs.getBigDecimal(columnIndex);
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "getBigDecimal(columnIndex)", Integer.toString(columnIndex), o));
		out.flush();
		return o;
	}
	public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
		BigDecimal o = rs.getBigDecimal(columnIndex, scale);
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "getBigDecimal(columnIndex, scale)", columnIndex + " " + scale, o));
		out.flush();
		return o;
	}
	public BigDecimal getBigDecimal(String columnName) throws SQLException {
		BigDecimal o = rs.getBigDecimal(columnName);
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "getBigDecimal(columnName)", columnName, o));
		out.flush();
		return o;
	}
	public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
		BigDecimal o = rs.getBigDecimal(columnName, scale);
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "getBigDecimal(columnName, scale)", columnName + " " + scale, o));
		out.flush();
		return o;
	}
	public InputStream getBinaryStream(int columnIndex) throws SQLException {
		InputStream o = rs.getBinaryStream(columnIndex);
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "getBinaryStream(columnIndex)", Integer.toString(columnIndex), o));
		out.flush();
		return o;
	}
	public InputStream getBinaryStream(String columnName) throws SQLException {
		InputStream o = rs.getBinaryStream(columnName);
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "getBinaryStream(columnName)", columnName, o));
		out.flush();
		return o;
	}
	public Blob getBlob(int i) throws SQLException {
		Blob o = rs.getBlob(i);
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "getBlob(i)", Integer.toString(i), o));
		out.flush();
		return o;
	}
	public Blob getBlob(String colName) throws SQLException {
		Blob o = rs.getBlob(colName);
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "getBlob(colName)", colName, o));
		out.flush();
		return o;
	}
	public boolean getBoolean(int columnIndex) throws SQLException {
		Boolean o = new Boolean(rs.getBoolean(columnIndex));
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "getBoolean(columnIndex)", Integer.toString(columnIndex), o));
		out.flush();
		return o.booleanValue();
	}
	public boolean getBoolean(String columnName) throws SQLException {
		Boolean o = new Boolean(rs.getBoolean(columnName));
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "getBoolean(columnName)", columnName, o));
		out.flush();
		return o.booleanValue();
	}
	public byte getByte(int columnIndex) throws SQLException {
		Byte o = new Byte(rs.getByte(columnIndex));
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "getByte(columnIndex)", Integer.toString(columnIndex), o));
		out.flush();
		return o.byteValue();
	}
	public byte getByte(String columnName) throws SQLException {
		Byte o = new Byte(rs.getByte(columnName));
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "getByte(columnName)", columnName, o));
		out.flush();
		return o.byteValue();
	}
	public byte[] getBytes(int columnIndex) throws SQLException {
		byte[] o = rs.getBytes(columnIndex);
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "getBytes(columnIndex)", Integer.toString(columnIndex), o));
		out.flush();
		return o;
	}
	public byte[] getBytes(String columnName) throws SQLException {
		byte[] o = rs.getBytes(columnName);
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "getBytes(columnName)", columnName, o));
		out.flush();
		return o;
	}
	public Reader getCharacterStream(int columnIndex) throws SQLException {
		Reader o = rs.getCharacterStream(columnIndex);
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "getCharacterStream(columnIndex)", Integer.toString(columnIndex), o));
		out.flush();
		return o;
	}
	public Reader getCharacterStream(String columnName) throws SQLException {
		Reader o = rs.getCharacterStream(columnName);
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "getCharacterStream(columnName)", columnName, o));
		out.flush();
		return o;
	}
	public Clob getClob(int i) throws SQLException {
		Clob o = rs.getClob(i);
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "getClob(i)", Integer.toString(i), o));
		out.flush();
		return o;
	}
	public Clob getClob(String colName) throws SQLException {
		Clob o = rs.getClob(colName);
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "getClob(colName)", colName, o));
		out.flush();
		return o;
	}
	public int getConcurrency() throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "getConcurrency()"));
		out.flush();
		return rs.getConcurrency();
	}
	public String getCursorName() throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "getCursorName()"));
		out.flush();
		return rs.getCursorName();
	}
	public java.sql.Date getDate(int columnIndex) throws SQLException {
		java.sql.Date o = rs.getDate(columnIndex);
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "getDate(columnIndex)", Integer.toString(columnIndex), o));
		out.flush();
		return o;
	}
	public java.sql.Date getDate(int columnIndex, Calendar cal) throws SQLException {
		java.sql.Date o = rs.getDate(columnIndex, cal);
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "getDate(columnIndex, cal)", columnIndex + " " + cal, o));
		out.flush();
		return o;
	}
	public java.sql.Date getDate(String columnName) throws SQLException {
		java.sql.Date o = rs.getDate(columnName);
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "getDate(columnName)", columnName, o));
		out.flush();
		return o;
	}
	public java.sql.Date getDate(String columnName, Calendar cal) throws SQLException {
		java.sql.Date o = rs.getDate(columnName, cal);
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "getDate(columnName, cal)", columnName + " " + cal, o));
		out.flush();
		return o;
	}
	public double getDouble(int columnIndex) throws SQLException {
		Double o = new Double(rs.getDouble(columnIndex));
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "getDouble(columnIndex)", Integer.toString(columnIndex), o));
		out.flush();
		return o.doubleValue();
	}
	public double getDouble(String columnName) throws SQLException {
		Double o = new Double(rs.getDouble(columnName));
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "getDouble(columnName)", columnName, o));
		out.flush();
		return o.doubleValue();
	}
	public int getFetchDirection() throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "getFetchDirection()"));
		out.flush();
		return rs.getFetchDirection();
	}
	public int getFetchSize() throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "getFetchSize()"));
		out.flush();
		return rs.getFetchSize();
	}
	public float getFloat(int columnIndex) throws SQLException {
		Float o = new Float(rs.getFloat(columnIndex));
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "getFloat(columnIndex)", Integer.toString(columnIndex), o));
		out.flush();
		return o.floatValue();
	}
	public float getFloat(String columnName) throws SQLException {
		Float o = new Float(rs.getFloat(columnName));
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "getFloat(columnName)", columnName, o));
		out.flush();
		return o.floatValue();
	}
	public int getInt(int columnIndex) throws SQLException {
		Integer o = new Integer(rs.getInt(columnIndex));
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "getInt(columnIndex)", Integer.toString(columnIndex), o));
		out.flush();
		return o.intValue();
	}
	public int getInt(String columnName) throws SQLException {
		Integer o = new Integer(rs.getInt(columnName));
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "getInt(columnName)", columnName, o));
		out.flush();
		return o.intValue();
	}
	public long getLong(int columnIndex) throws SQLException {
		Long o = new Long(rs.getLong(columnIndex));
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "getLong(columnIndex)", Integer.toString(columnIndex), o));
		out.flush();
		return o.longValue();
	}
	public long getLong(String columnName) throws SQLException {
		Long o = new Long(rs.getLong(columnName));
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "getLong(columnName)", columnName, o));
		out.flush();
		return o.longValue();
	}
	public ResultSetMetaData getMetaData() throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "getMetaData()"));
		out.flush();
		return rs.getMetaData();
	}
	public Object getObject(int columnIndex) throws SQLException {
		Object o = rs.getObject(columnIndex);
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "getObject(columnIndex)", Integer.toString(columnIndex), o));
		out.flush();
		return o;
	}
	public Object getObject(int i, Map map) throws SQLException {
		Object o = rs.getObject(i, map);
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "getObject(i, map)", i + " " + map, o));
		out.flush();
		return o;
	}
	public Object getObject(String columnName) throws SQLException {
		Object o = rs.getObject(columnName);
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "getObject(columnName)", columnName, o));
		out.flush();
		return o;
	}
	public Object getObject(String colName, Map map) throws SQLException {
		Object o = rs.getObject(colName, map);
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "getObject(colName)", colName + " " + map, o));
		out.flush();
		return o;
	}
	public Ref getRef(int i) throws SQLException {
		Ref o = rs.getRef(i);
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "getRef(i)", Integer.toString(i), o));
		out.flush();
		return o;
	}
	public Ref getRef(String colName) throws SQLException {
		Ref o = rs.getRef(colName);
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "getRef(colName)", colName, o));
		out.flush();
		return o;
	}
	public int getRow() throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "getRow()"));
		out.flush();
		return rs.getRow();
	}
	public short getShort(int columnIndex) throws SQLException {
		Short o = new Short(rs.getShort(columnIndex));
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "getShort(columnIndex)", Integer.toString(columnIndex), o));
		out.flush();
		return o.shortValue();
	}
	public short getShort(String columnName) throws SQLException {
		Short o = new Short(rs.getShort(columnName));
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "getShort(columnName)", columnName, o));
		out.flush();
		return o.shortValue();
	}
	public Statement getStatement() throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "getStatement()"));
		out.flush();
		return rs.getStatement();
	}
	public String getString(int columnIndex) throws SQLException {
		String o = rs.getString(columnIndex);
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "getString(columnIndex)", Integer.toString(columnIndex), o));
		out.flush();
		return o;
	}
	public String getString(String columnName) throws SQLException {
		String o = rs.getString(columnName);
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "getString(columnName)", columnName, o));
		out.flush();
		return o;
	}
	public Time getTime(int columnIndex) throws SQLException {
		Time o = rs.getTime(columnIndex);
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "getTime(columnIndex)", Integer.toString(columnIndex), o));
		out.flush();
		return o;
	}
	public Time getTime(int columnIndex, Calendar cal) throws SQLException {
		Time o = rs.getTime(columnIndex, cal);
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "getTime(columnIndex, cal)", columnIndex + " " + cal, o));
		out.flush();
		return o;
	}
	public Time getTime(String columnName) throws SQLException {
		Time o = rs.getTime(columnName);
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "getTime(columnName)", columnName, o));
		out.flush();
		return o;
	}
	public Time getTime(String columnName, Calendar cal) throws SQLException {
		Time o = rs.getTime(columnName, cal);
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "getTime(columnName, cal)", columnName + " " + cal, o));
		out.flush();
		return o;
	}
	public Timestamp getTimestamp(int columnIndex) throws SQLException {
		Timestamp o = rs.getTimestamp(columnIndex);
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "getTimestamp(columnIndex)", Integer.toString(columnIndex), o));
		out.flush();
		return o;
	}
	public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
		Timestamp o = rs.getTimestamp(columnIndex, cal);
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "getTimestamp(columnIndex, cal)", columnIndex + " " + cal, o));
		out.flush();
		return o;
	}
	public Timestamp getTimestamp(String columnName) throws SQLException {
		Timestamp o = rs.getTimestamp(columnName);
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "getTimestamp(columnName)", columnName, o));
		out.flush();
		return o;
	}
	public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
		Timestamp o = rs.getTimestamp(columnName, cal);
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "getTimestamp(columnName, cal)", columnName + " " + cal, o));
		out.flush();
		return o;
	}
	public int getType() throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "getType()"));
		out.flush();
		return rs.getType();
	}
	public InputStream getUnicodeStream(int columnIndex) throws SQLException {
		InputStream o = rs.getUnicodeStream(columnIndex);
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "getUnicodeStream(columnIndex)", Integer.toString(columnIndex), o));
		out.flush();
		return o;
	}
	public InputStream getUnicodeStream(String columnName) throws SQLException {
		InputStream o = rs.getUnicodeStream(columnName);
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "getUnicodeStream(columnName)", columnName, o));
		out.flush();
		return o;
	}
	public SQLWarning getWarnings() throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "getWarnings()"));
		out.flush();
		return rs.getWarnings();
	}
	public void insertRow() throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "insertRow()"));
		out.flush();
		rs.insertRow();
	}
	public boolean isAfterLast() throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "isAfterLast()"));
		out.flush();
		return rs.isAfterLast();
	}
	public boolean isBeforeFirst() throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "isBeforeFirst()"));
		out.flush();
		return rs.isBeforeFirst();
	}
	public boolean isFirst() throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "isFirst()"));
		out.flush();
		return rs.isFirst();
	}
	public boolean isLast() throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "isLast()"));
		out.flush();
		return rs.isLast();
	}
	public boolean last() throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "last()"));
		out.flush();
		return rs.last();
	}
	public void moveToCurrentRow() throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "moveToCurrentRow()"));
		out.flush();
		rs.moveToCurrentRow();
	}
	public void moveToInsertRow() throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "moveToInsertRow()"));
		out.flush();
		rs.moveToInsertRow();
	}
	public boolean next() throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "next()"));
		out.flush();
		return rs.next();
	}
	public boolean previous() throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "previous()"));
		out.flush();
		return rs.previous();
	}
	public void refreshRow() throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "refreshRow()"));
		out.flush();
		rs.refreshRow();
	}
	public boolean relative(int rows) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "relative(rows)", Integer.toString(rows)));
		out.flush();
		return rs.relative(rows);
	}
	public boolean rowDeleted() throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "rowDeleted()"));
		out.flush();
		return rs.rowDeleted();
	}
	public boolean rowInserted() throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "rowInserted()"));
		out.flush();
		return rs.rowInserted();
	}
	public boolean rowUpdated() throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "rowUpdated()"));
		out.flush();
		return rs.rowUpdated();
	}
	public void setFetchDirection(int direction) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "setFetchDirection(direction)", Integer.toString(direction)));
		out.flush();
		rs.setFetchDirection(direction);
	}
	public void setFetchSize(int rows) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "setFetchSize(rows)", Integer.toString(rows)));
		out.flush();
		rs.setFetchSize(rows);
	}
	public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "updateAsciiStream(columnIndex, x, length)", (columnIndex + " " + x + " " + length)));
		out.flush();
		rs.updateAsciiStream(columnIndex, x, length);
	}
	public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "updateAsciiStream(columnName, x, length)", (columnName + " " + x + " " + length)));
		out.flush();
		rs.updateAsciiStream(columnName, x, length);
	}
	public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "updateBigDecimal(columnIndex, x)", (columnIndex + " " + x)));
		out.flush();
		rs.updateBigDecimal(columnIndex, x);
	}
	public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "updateBigDecimal(columnName, x)", (columnName + " " + x)));
		out.flush();
		rs.updateBigDecimal(columnName, x);
	}
	public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "updateBinaryStream(columnIndex, x, length)", (columnIndex + " " + x + " " + length)));
		out.flush();
		rs.updateBinaryStream(columnIndex, x, length);
	}
	public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "updateBinaryStream(columnName, x, length)", (columnName + " " + x + " " + length)));
		out.flush();
		rs.updateBinaryStream(columnName, x, length);
	}
	public void updateBoolean(int columnIndex, boolean x) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "updateBoolean(columnIndex, x)", (columnIndex + " " + x)));
		out.flush();
		rs.updateBoolean(columnIndex, x);
	}
	public void updateBoolean(String columnName, boolean x) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "updateBoolean(columnName, x)", (columnName + " " + x)));
		out.flush();
		rs.updateBoolean(columnName, x);
	}
	public void updateByte(int columnIndex, byte x) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "updateByte(columnIndex, x)", (columnIndex + " " + x)));
		out.flush();
		rs.updateByte(columnIndex, x);
	}
	public void updateByte(String columnName, byte x) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "updateByte(columnName, x)", (columnName + " " + x)));
		out.flush();
		rs.updateByte(columnName, x);
	}
	public void updateBytes(int columnIndex, byte[] x) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "updateBytes(columnIndex, x)", (columnIndex + " " + x)));
		out.flush();
		rs.updateBytes(columnIndex, x);
	}
	public void updateBytes(String columnName, byte[] x) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "updateBytes(columnName, x)", (columnName + " " + x)));
		out.flush();
		rs.updateBytes(columnName, x);
	}
	public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "updateCharacterStream(columnIndex, x, length)", (columnIndex + " " + x + " " + length)));
		out.flush();
		rs.updateCharacterStream(columnIndex, x, length);
	}
	public void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "updateCharacterStream(columnName, reader, length)", (columnName + " " + reader + " " + length)));
		out.flush();
		rs.updateCharacterStream(columnName, reader, length);
	}
	public void updateDate(int columnIndex, java.sql.Date x) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "updateDate(columnIndex, x)", (columnIndex + " " + x)));
		out.flush();
		rs.updateDate(columnIndex, x);
	}
	public void updateDate(String columnName, java.sql.Date x) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "updateDate(columnName, x)", (columnName + " " + x)));
		out.flush();
		rs.updateDate(columnName, x);
	}
	public void updateDouble(int columnIndex, double x) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "updateDouble(columnIndex, x)", (columnIndex + " " + x)));
		out.flush();
		rs.updateDouble(columnIndex, x);
	}
	public void updateDouble(String columnName, double x) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "updateDouble(columnName, x)", (columnName + " " + x)));
		out.flush();
		rs.updateDouble(columnName, x);
	}
	public void updateFloat(int columnIndex, float x) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "updateFloat(columnIndex, x)", (columnIndex + " " + x)));
		out.flush();
		rs.updateFloat(columnIndex, x);
	}
	public void updateFloat(String columnName, float x) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "updateFloat(columnName, x)", (columnName + " " + x)));
		out.flush();
		rs.updateFloat(columnName, x);
	}
	public void updateInt(int columnIndex, int x) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "updateInt(columnIndex, x)", (columnIndex + " " + x)));
		out.flush();
		rs.updateInt(columnIndex, x);
	}
	public void updateInt(String columnName, int x) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "updateInt(columnName, x)", (columnName + " " + x)));
		out.flush();
		rs.updateInt(columnName, x);
	}
	public void updateLong(int columnIndex, long x) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "updateLong(columnIndex, x)", (columnIndex + " " + x)));
		out.flush();
		rs.updateLong(columnIndex, x);
	}
	public void updateLong(String columnName, long x) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "updateLong(columnName, x)", (columnName + " " + x)));
		out.flush();
		rs.updateLong(columnName, x);
	}
	public void updateNull(int columnIndex) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "updateNull(columnIndex)", Integer.toString(columnIndex)));
		out.flush();
		rs.updateNull(columnIndex);
	}
	public void updateNull(String columnName) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "updateNull(columnName)", columnName));
		out.flush();
		rs.updateNull(columnName);
	}
	public void updateObject(int columnIndex, Object x) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "updateObject(columnIndex, x)", (columnIndex + " " + x)));
		out.flush();
		rs.updateObject(columnIndex, x);
	}
	public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "updateObject(columnIndex, x, scale)", (columnIndex + " " + x + " " + scale)));
		out.flush();
		rs.updateObject(columnIndex, x, scale);
	}
	public void updateObject(String columnName, Object x) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "updateObject(columnName, x)", (columnName + " " + x)));
		out.flush();
		rs.updateObject(columnName, x);
	}
	public void updateObject(String columnName, Object x, int scale) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "updateObject(columnName, x, scale)", (columnName + " " + x + " " + scale)));
		out.flush();
		rs.updateObject(columnName, x, scale);
	}
	public void updateRow() throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "updateRow()"));
		out.flush();
		rs.updateRow();
	}
	public void updateShort(int columnIndex, short x) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "updateShort(columnIndex, x)", (columnIndex + " " + x)));
		out.flush();
		rs.updateShort(columnIndex, x);
	}
	public void updateShort(String columnName, short x) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "updateShort(columnName, x)", (columnName + " " + x)));
		out.flush();
		rs.updateShort(columnName, x);
	}
	public void updateString(int columnIndex, String x) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "updateString(columnIndex, x)", (columnIndex + " " + x)));
		out.flush();
		rs.updateString(columnIndex, x);
	}
	public void updateString(String columnName, String x) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "updateString(columnName, x)", (columnName + " " + x)));
		out.flush();
		rs.updateString(columnName, x);
	}
	public void updateTime(int columnIndex, Time x) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "updateTime(columnIndex, x)", (columnIndex + " " + x)));
		out.flush();
		rs.updateTime(columnIndex, x);
	}
	public void updateTime(String columnName, Time x) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "updateTime(columnName, x)", (columnName + " " + x)));
		out.flush();
		rs.updateTime(columnName, x);
	}
	public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "updateTimestamp(columnIndex, x)", (columnIndex + " " + x)));
		out.flush();
		rs.updateTimestamp(columnIndex, x);
	}
	public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "updateTimestamp(columnName, x)", (columnName + " " + x)));
		out.flush();
		rs.updateTimestamp(columnName, x);
	}
	public boolean wasNull() throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.RESULTSET, "wasNull()"));
		out.flush();
		return rs.wasNull();
	}
	
	public URL getURL(int columnIndex) throws SQLException { return rs.getURL(columnIndex); }
	public URL getURL(String columnLabel) throws SQLException { return rs.getURL(columnLabel); }
	public void updateRef(int columnIndex,Ref x) throws SQLException { rs.updateRef(columnIndex,x); }
	public void updateRef(String columnLabel, Ref x) throws SQLException { rs.updateRef(columnLabel, x); }
	public void updateBlob(int columnIndex, Blob x) throws SQLException { rs.updateBlob(columnIndex, x); }
	public void updateBlob(String columnLabel, Blob x) throws SQLException { rs.updateBlob(columnLabel, x); }
	public void updateClob(int columnIndex, Clob x) throws SQLException { rs.updateClob(columnIndex, x); }
	public void updateClob(String columnLabel,Clob x) throws SQLException { rs.updateClob(columnLabel,x); }
	public void updateArray(int columnIndex, Array x) throws SQLException { rs.updateArray(columnIndex, x); }
	public void updateArray(String columnLabel, Array x) throws SQLException { rs.updateArray(columnLabel, x); }
	public RowId getRowId(int columnIndex) throws SQLException { return rs.getRowId(columnIndex); }
	public RowId getRowId(String columnLabel) throws SQLException { return rs.getRowId(columnLabel); }
	public void updateRowId(int columnIndex, RowId x) throws SQLException { rs.updateRowId(columnIndex, x); }
	public void updateRowId(String columnLabel, RowId x) throws SQLException { rs.updateRowId(columnLabel, x); }
	public int getHoldability() throws SQLException { return rs.getHoldability(); }
	public boolean isClosed() throws SQLException { return rs.isClosed(); }
	public void updateNString(int columnIndex, String nString) throws SQLException { rs.updateNString(columnIndex, nString); }
	public void updateNString(String columnLabel, String nString) throws SQLException { rs.updateNString(columnLabel, nString); }
	public void updateNClob(int columnIndex, NClob nClob) throws SQLException { rs.updateNClob(columnIndex, nClob); }
	public void updateNClob(String columnLabel, NClob nClob) throws SQLException { rs.updateNClob(columnLabel, nClob); }
	public NClob getNClob(int columnIndex) throws SQLException { return rs.getNClob(columnIndex); }
	public NClob getNClob(String columnLabel) throws SQLException { return rs.getNClob(columnLabel); }
	public SQLXML getSQLXML(int columnIndex) throws SQLException { return rs.getSQLXML(columnIndex); }
	public SQLXML getSQLXML(String columnLabel) throws SQLException { return rs.getSQLXML(columnLabel); }
	public void updateSQLXML(int columnIndex,SQLXML xmlObject) throws SQLException { rs.updateSQLXML(columnIndex,xmlObject); }
	public void updateSQLXML(String columnLabel,SQLXML xmlObject) throws SQLException { rs.updateSQLXML(columnLabel,xmlObject); }
	public String getNString(int columnIndex) throws SQLException { return rs.getNString(columnIndex); }
	public String getNString(String columnLabel) throws SQLException { return rs.getNString(columnLabel); }
	public Reader getNCharacterStream(int columnIndex) throws SQLException { return rs.getNCharacterStream(columnIndex); }
	public Reader getNCharacterStream(String columnLabel) throws SQLException { return rs.getNCharacterStream(columnLabel); }
	public void updateNCharacterStream(int columnIndex,Reader x,long length) throws SQLException { rs.updateNCharacterStream(columnIndex, x,length); }
	public void updateNCharacterStream(String columnLabel,Reader reader,long length) throws SQLException { rs.updateNCharacterStream(columnLabel, reader,length); }
	public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException { rs.updateAsciiStream(columnIndex, x, length); }
	public void updateBinaryStream(int columnIndex,InputStream x,long length) throws SQLException { rs.updateBinaryStream(columnIndex,x,length); }
	public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException { rs.updateCharacterStream(columnIndex,  x, length); }
	public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException { rs.updateAsciiStream(columnLabel, x, length); }
	public void updateBinaryStream(String columnLabel,InputStream x,long length)throws SQLException { rs.updateBinaryStream(columnLabel,x,length); }
	public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException { rs.updateCharacterStream(columnLabel,  reader, length); }
	public void updateBlob(int columnIndex,InputStream inputStream,long length) throws SQLException { rs.updateBlob(columnIndex,inputStream,length); }
	public void updateBlob(String columnLabel,InputStream inputStream,long length) throws SQLException { rs.updateBlob(columnLabel,inputStream,length); }
	public void updateClob(int columnIndex,Reader reader,long length) throws SQLException { rs.updateClob(columnIndex, reader,length); }
	public void updateClob(String columnLabel,Reader reader,long length) throws SQLException { rs.updateClob(columnLabel, reader,length); }
	public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException { rs.updateNClob(columnIndex,  reader, length); }
	public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException { rs.updateNClob(columnLabel,  reader, length); }
	public void updateNCharacterStream(int columnIndex,Reader x) throws SQLException { rs.updateNCharacterStream(columnIndex, x); }
	public void updateNCharacterStream(String columnLabel,Reader reader) throws SQLException { rs.updateNCharacterStream(columnLabel, reader); }
	public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException { rs.updateAsciiStream(columnIndex, x); }
	public void updateBinaryStream(int columnIndex,InputStream x) throws SQLException { rs.updateBinaryStream(columnIndex,x); }
	public void updateCharacterStream(int columnIndex, Reader x) throws SQLException { rs.updateCharacterStream(columnIndex,  x); }
	public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException { rs.updateAsciiStream(columnLabel, x); }
	public void updateBinaryStream(String columnLabel,InputStream x) throws SQLException { rs.updateBinaryStream(columnLabel,x); }
	public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException { rs.updateCharacterStream(columnLabel,  reader); }
	public void updateBlob(int columnIndex,InputStream inputStream) throws SQLException { rs.updateBlob(columnIndex,inputStream); }
	public void updateBlob(String columnLabel,InputStream inputStream) throws SQLException { rs.updateBlob(columnLabel,inputStream); }
	public void updateClob(int columnIndex,Reader reader) throws SQLException { rs.updateClob(columnIndex, reader); }
	public void updateClob(String columnLabel,Reader reader) throws SQLException { rs.updateClob(columnLabel, reader); }
	public void updateNClob(int columnIndex, Reader reader) throws SQLException { rs.updateNClob(columnIndex,  reader); }
	public void updateNClob(String columnLabel, Reader reader)  throws SQLException { rs.updateNClob(columnLabel,  reader) ; }

	// java.sql.Wrapper
	public boolean isWrapperFor(Class iface) throws SQLException {
		return rs.isWrapperFor(iface);
	}
	public Object  unwrap(Class iface) throws SQLException {
		return rs.unwrap(iface);
	}
}
