package wisdom.core.connections;

import java.sql.*;
import java.io.*;

import wisdom.core.CoreObject;
import wisdom.core.Log;
import wisdom.core.LogFactory;


/**
 * java.sql.Statement bvAStatementNXŎsꂽg[XNXB
 * 
 *
 * @author  Takao Kouda
 * @version 0.90, 1/1/2001
 */
public class TraceStatement extends CoreObject implements Statement {
	private Object invoker = null;
	private Statement stmt = null;
	private Log l = LogFactory.create();
	private TraceHelper th = TraceHelper.getInstance();
	private PrintWriter out = null;
	
	/**
	 * RXgN^
	 * @param		invoker		ĂяõNX
	 * @param		stmt		g[X StatementIuWFNg
	 */	
	public TraceStatement(Object invoker, Statement stmt)  {
		super();
		this.invoker = invoker;
		this.stmt = stmt;
		out = l.getWriter();
	}
	
    /**
     * g[Xo͂AStatementĂ铯\bhs܂B
     *
     * @param 		sql		ʏÓI SQL SELECT 
     * @return 				w肳ꂽNG[ɂč쐬ꂽf[^܂ ResultSet IuWFNgBnull ɂ͂ȂȂ
     * @exception 			f[^x[XANZXG[ꍇ
     */
	public ResultSet executeQuery(String sql) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.STATEMENT, "executeQuery(sql)", sql));
		out.flush();		
		return new TraceResultSet(invoker, stmt.executeQuery(sql));
	}

    /**
     * g[Xo͂AStatementĂ铯\bhs܂B
     *
     * @param 		sql		SQL INSERT AUPDATE A܂ DELETE A邢͉ԂȂ SQL 
     * @return 				INSERT AUPDATE ADELETE ̏ꍇ͍sBԂȂ SQL ̏ꍇ 0
     * @exception 			f[^x[XANZXG[ꍇ
     */      
	public int executeUpdate(String sql) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.STATEMENT, "executeUpdate(sql)", sql));		
		out.flush();
		return stmt.executeUpdate(sql);
	}
 
    /**
     * g[Xo͂AStatementĂ铯\bhs܂B
     * 
     * @exception 			f[^x[XANZXG[ꍇ
     */    
	public void close() throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.STATEMENT, "close()"));
		out.flush();
		stmt.close();
	}
 
    /**
     * g[Xo͂AStatementĂ铯\bhs܂B
     * 
     * @return 				݂̍ős̐lB[͖Ӗ
     * @exception 			f[^x[XANZXG[ꍇ
     */   
	public int getMaxFieldSize() throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.STATEMENT, "getMaxFieldSize()"));		
		out.flush();
		return stmt.getMaxFieldSize();
	}
 
 
    /**
     * g[Xo͂AStatementĂ铯\bhs܂B
     *
     * @param 		max		VőTCY̐lB[͖Ӗ
     * @exception 			f[^x[XANZXG[ꍇ
     */   
	public void setMaxFieldSize(int max) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.STATEMENT, "setMaxFieldSize(max)", Integer.toString(max)));				
		out.flush();
		stmt.setMaxFieldSize(max);
	}

    /**
     * g[Xo͂AStatementĂ铯\bhs܂B
     * 
     * @return 				݂̍ős̐lB[͖Ӗ
     * @exception 			f[^x[XANZXG[ꍇ
     */ 
	public int getMaxRows() throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.STATEMENT, "getMaxRows()"));
		out.flush();
		return stmt.getMaxRows();
	}
 
    /**
     * g[Xo͂AStatementĂ铯\bhs܂B
     * @param 		max		Vős̐lB[͖Ӗ
     * @exception 			f[^x[XANZXG[ꍇ
     */   
	public void setMaxRows(int max) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.STATEMENT, "setMaxRows(max)", Integer.toString(max)));		
		out.flush();
		stmt.setMaxRows(max);
	}

    /**
     * g[Xo͂AStatementĂ铯\bhs܂B
     * @param 		enable	Lɂꍇ trueAɂꍇ false
     * @exception 			f[^x[XANZXG[ꍇ
     */            
	public void setEscapeProcessing(boolean enable) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.STATEMENT, "setEscapeProcessing(enable)", new Boolean(enable).toString()));
		out.flush();
		stmt.setEscapeProcessing(enable);
	}

    /**
     * g[Xo͂AStatementĂ铯\bhs܂B
     *
     * @return 				݂̃NG[^CAEg̐l̕bB[͖Ӗ
     * @exception 			f[^x[XANZXG[ꍇ
     */    
	public int getQueryTimeout() throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.STATEMENT, "getQueryTimeout()"));		
		out.flush();
		return stmt.getQueryTimeout();
	}
    
    /**
     * g[Xo͂AStatementĂ铯\bhs܂B
     * 
     * @param 		seconds	VNG[^CAEg̐l̕bB[͖Ӗ
     * @exception 			f[^x[XANZXG[ꍇ
     */            
	public void setQueryTimeout(int seconds) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.STATEMENT, "setQueryTimeout(seconds)", Integer.toString(seconds)));		
		out.flush();
		stmt.setQueryTimeout(seconds);
	}
    
    /**
     * g[Xo͂AStatementĂ铯\bhs܂B
     *
     * @exception 			f[^x[XANZXG[ꍇ
     */     
	public void cancel() throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.STATEMENT, "cancel()"));				
		out.flush();
		stmt.cancel();
	}
    
    /**
     * g[Xo͂AStatementĂ铯\bhs܂B
     *
     * @return 				IuWFNg܂ null
     * @exception 			f[^x[XANZXG[ꍇ
     */    
	public SQLWarning getWarnings() throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.STATEMENT, "getWarnings()"));
		out.flush();
		return stmt.getWarnings();
	}
 
    /**
     * g[Xo͂AStatementĂ铯\bhs܂B
     *
     * @exception 			f[^x[XANZXG[ꍇ
     */     
	public void clearWarnings() throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.STATEMENT, "clearWarnings()"));	
		out.flush();
		stmt.clearWarnings();
	}
 
    /**
     * g[Xo͂AStatementĂ铯\bhs܂B
     * 
     * @param 		name	VJ[\BڑňӂɂKv
     * @exception 			f[^x[XANZXG[ꍇ
     */   
	public void setCursorName(String name) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.STATEMENT, "setCursorName(name)", name));			
		out.flush();
		stmt.setCursorName(name);
	}
  
    /**
     * g[Xo͂AStatementĂ铯\bhs܂B
     * @param 		sql		Cӂ SQL 
     * @return 				̌ʂ ResultSet IuWFNg̏ꍇ trueBXVJEgł邩A܂͌ʂȂꍇ false
     * @exception 			f[^x[XANZXG[ꍇ
     */  
	public boolean execute(String sql) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.STATEMENT, "execute(sql)", sql));					
		out.flush();
		return stmt.execute(sql);
	}
 
 
    /**
     * g[Xo͂AStatementĂ铯\bhs܂B
     *
     * @return 				ResultSet IuWFNgƂĂ݂̌̌ʁBXVJEgł邩A܂͌ʂȂꍇ null
     * @exception 			f[^x[XANZXG[ꍇ
     */       
	public ResultSet getResultSet() throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.STATEMENT, "getResultSet()"));
		out.flush();
		return stmt.getResultSet();
	}
 
    /**
     * g[Xo͂AStatementĂ铯\bhs܂B
     *
     * @return 				XVJEgĂ݂̌̌ʁB݂̌ʂ ResultSet IuWFNgł邩A܂͌ʂȂꍇ -1
     * @exception 			f[^x[XANZXG[ꍇ
     */     
	public int getUpdateCount() throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.STATEMENT, "getUpdateCount()"));		
		out.flush();
		return stmt.getUpdateCount();
	}
    
    /**
     * g[Xo͂AStatementĂ铯\bhs܂B
     *
     * @return 				̌ʂ ResultSet IuWFNg̏ꍇ trueBXVJEgł邩A܂͌ʂȂꍇ false
     * @exception 			f[^x[XANZXG[ꍇ
     */     
	public boolean getMoreResults() throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.STATEMENT, "getMoreResults()"));		
		out.flush();
		return stmt.getMoreResults();
	}
    
    /**
     * g[Xo͂AStatementĂ铯\bhs܂B
     *
     * @param direction	s鏉
     * @exception 			f[^x[XANZXG[ꍇA܂͎w肳ꂽ ResultSet.FETCH_FORWARDAResultSet.FETCH_REVERSEA܂ ResultSet.FETCH_UNKNOWN ̂ǂłȂꍇ
     */     
	public void setFetchDirection(int direction) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.STATEMENT, "setFetchDirection(direction)", Integer.toString(direction)));
		out.flush();
		stmt.setFetchDirection(direction);
	}
    
 
    /**
     * g[Xo͂AStatementĂ铯\bhs܂B
     *
     * @return 				 Statement IuWFNg琶ꂽʃZbg̃ftHg̃tFb`
     * @exception 			f[^x[XANZXG[ꍇ
     */     
	public int getFetchDirection() throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.STATEMENT, "getFetchDirection()"));		
		out.flush();
		return stmt.getFetchDirection();
	}
    
    /**
     * g[Xo͂AStatementĂ铯\bhs܂B
     *
     * @param 		rows	tFb`s 
     * @exception 			f[^x[XANZXG[ꍇA܂͏ 0 <= rows <= this.getMaxRows() Ȃꍇ
     */   
	public void setFetchSize(int rows) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.STATEMENT, "setFetchSize(rows)", Integer.toString(rows)));
		out.flush();
		stmt.setFetchSize(rows);
	}

    /**
     * g[Xo͂AStatementĂ铯\bhs܂B
     *
     * @return 			 Statement IuWFNg琶ꂽʃZbg̃ftHg̃tFb`TCY
     * @exception 		f[^x[XANZXG[ꍇ
     */
	public int getFetchSize() throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.STATEMENT, "getFetchSize()"));		
		out.flush();
		return stmt.getFetchSize();
	}

    /**
     * g[Xo͂AStatementĂ铯\bhs܂B
     *
     * @return			ResultSet.CONCUR_READ_ONLY ܂ ResultSet.CONCUR_UPDATABLE
     */    
	public int getResultSetConcurrency() throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.STATEMENT, "getResultSetConcurrency()"));
		out.flush();
		return stmt.getResultSetConcurrency();
	}
    
    /**
     * g[Xo͂AStatementĂ铯\bhs܂B
     *
     * @return		 		ResultSet.TYPE_FORWARD_ONLYAResultSet.TYPE_SCROLL_INSENSITIVEA܂ ResultSet.TYPE_SCROLL_SENSITIVE ̂ 1 
     */    
	public int getResultSetType()  throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.STATEMENT, "getResultSetType()"));		
		out.flush();
		return stmt.getResultSetType();
	}
    
    /**
     * g[Xo͂AStatementĂ铯\bhs܂B
     *
     * @param 		sql 	ʏÓI SQL INSERT A܂ UPDATE 
     * @exception 			f[^x[XANZXG[ꍇA܂̓hCoob`T|[gĂȂꍇ
     */
	public void addBatch(String sql) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.STATEMENT, "addBatch(sql)", sql));
		out.flush();
		stmt.addBatch(sql);
	}
	/**
     * g[Xo͂AStatementĂ铯\bhs܂B
	 * 
	 * @exception  	f[^x[XANZXG[ꍇA܂̓hCoob`T|[gĂȂꍇ
	 */
	public void clearBatch() throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.STATEMENT, "clearBatch()"));		
		out.flush();
		stmt.clearBatch();
	}

	/**
     * g[Xo͂AStatementĂ铯\bhs܂B
     *
     * @return 				ob`̃R}hƂ 1 ̗vfi[ĂXVJEg̔zB
     *						z̗vf̓R}hob`ɒǉꂽŕׂB
     * @exception			f[^x[XANZXG[ꍇA܂̓hCoob`T|[gĂȂꍇ
     */
    public int[] executeBatch() throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.STATEMENT, "executeBatch()"));				
		out.flush();
		return stmt.executeBatch();
	}

	/**
     * g[Xo͂AStatementĂ铯\bhs܂B
     *
     * @return 				̕𐶐ڑ
     * @exception			f[^x[XANZXG[ꍇ
     */
	public Connection getConnection()  throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.STATEMENT, "getConnection()"));
		out.flush();
		return stmt.getConnection(); 
	}
	
	// java 1.6 
	public boolean getMoreResults(int current) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.STATEMENT, "getMoreResults(current)",current+""));
		out.flush();
		return stmt.getMoreResults(current);
	}
	public ResultSet getGeneratedKeys() throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.STATEMENT, "getGeneratedKeys()"));
		out.flush();
		return stmt.getGeneratedKeys();
	}
	public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.STATEMENT, "executeUpdate(sql,autoGeneratedKeys)",sql+" "+autoGeneratedKeys));
		out.flush();
		return stmt.executeUpdate(sql, autoGeneratedKeys);
	}
	public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.STATEMENT, "executeUpdate(sql,columnIndexes)",sql+" "+columnIndexes));
		out.flush();
		return stmt.executeUpdate(sql, columnIndexes);
	}
	public int executeUpdate(String sql, String[] columnNames) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.STATEMENT, "executeUpdate(sql,columnNames)",sql+" "+columnNames));
		out.flush();
		return stmt.executeUpdate(sql, columnNames);
	}
	public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.STATEMENT, "execute(sql,autoGeneratedKeys)",sql+" "+autoGeneratedKeys));
		out.flush();
		return stmt.execute(sql, autoGeneratedKeys);
	}
	public boolean execute(String sql,  int[] columnIndexes) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.STATEMENT, "execute(sql,columnIndexes)",sql+" "+columnIndexes));
		out.flush();
		return stmt.execute(sql, columnIndexes);
	}
	public boolean execute(String sql, String[] columnNames) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.STATEMENT, "execute(sql,columnNames)",sql+" "+columnNames));
		out.flush();
		return stmt.execute(sql, columnNames);
	}
	public int getResultSetHoldability() throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.STATEMENT, "getResultSetHoldability()"));
		out.flush();
		return stmt.getResultSetHoldability();
	}
	public void setPoolable(boolean poolable) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.STATEMENT, "setPoolable(poolable)",""+poolable));
		out.flush();
		stmt.setPoolable(poolable);
	}
	public boolean isPoolable() throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.STATEMENT, "isPoolable()"));
		out.flush();
		return stmt.isPoolable();
	}
	public boolean isClosed() throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.STATEMENT, "isClosed()"));
		out.flush();
		return stmt.isClosed();
	} 
	// java.sql.Wrapper
	public boolean isWrapperFor(Class iface) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.STATEMENT, "isWrapperFor(iface)",iface+""));
		out.flush();
		return stmt.isWrapperFor(iface);
	}
	public Object  unwrap(Class iface) throws SQLException {
		out.println(th.header(this, invoker, TraceHelper.STATEMENT, "unwrap(iface)",iface+""));
		out.flush();
		return stmt.unwrap(iface);
	}	
	
}
