package wisdom.core.request;

import java.util.List;
import java.util.ArrayList;
import java.util.Iterator;

import javax.servlet.http.HttpServletRequest;

import wisdom.core.application.IRequestParser;

/**
 * }`p[g͂{@link IRequestParser}̎NX<br>
 * 
 * 2005/7/7 WA0039 Ή<br>
 * 
 * @author  Takao Kouda
 * @version 1
 */
public class MultiPartParameterParser extends ParameterParser  {

	List parts = null;
	/**
	 *  RXgN^<br>
	 *  @param req ͂HttpServletRequestIuWFNg
	 */
	public MultiPartParameterParser(HttpServletRequest req) throws Exception {
		super(req);
		MultiPartFormDataParser parser = new MultiPartFormDataParser(req.getContentType(), req.getInputStream());
		parts = parser.parse();	
	}
	
	/**
	 *  String^̃p[^擾<BR>
	 *
	 *  @param 		name 擾p[^
	 *  @return 		 String^Ŏ擾ꂽl
	 *  @exception 		 ParameterNotFoundException œnꂽp[^̕ϐHttpServletRequest̒ɂȂꍇ
	 */	
	public String getString(String name) throws ParameterNotFoundException {
		String value = partAsInput(name);
		if (value == null) throw new ParameterNotFoundException(messageGenerator.getMessage("WPE0010", name));
		else return value.trim();
	}
	
	public String getStringNoTrim(String name) throws ParameterNotFoundException {
		String value = partAsInput(name);
		if (value == null) throw new ParameterNotFoundException(name, messageGenerator.getMessage("WPE0010", name));
		else return value;
	}
	
	public String getStringNoTrim(String name, String def) {
		try { 
			return getStringNoTrim(name); 
		} catch (ParameterNotFoundException e) { 
			return def; 
		}
	}	
	/**
	 *  Part^̃p[^擾܂B<br>
	 *
	 *  @param name 擾p[^
	 *  @return 擾łPart
	 *  @exception ParameterNotFoundException œnꂽp[^̕ϐHttpServletRequest̒ɂȂꍇ
	 */
	 
	public Part getPart(String name) throws ParameterNotFoundException {
		for (Iterator i = parts.iterator() ; i.hasNext() ;) {
			Part part = (Part)i.next();
			if (part.getName().equals(name) && part.getType() == Part.FILE) return part;
		}
		return null;
	}	

	
	/**
	 *  Part^̔z擾܂B<br>
	 *
	 *  @param name 擾p[^
	 *  @return Part܂ListIuWFNg
	 *  @exception ParameterNotFoundException œnꂽp[^̕ϐHttpServletRequest̒ɂȂꍇ
	 */
	 
	public List getPartArray(String name) throws ParameterNotFoundException {
		List l = new ArrayList();
		for (Iterator i = parts.iterator() ; i.hasNext() ;) {
			Part part = (Part)i.next();
			if (part.getName().equals(name) && part.getType() == Part.FILE) l.add(part);
		}
		return l;
	}	
	/**
	 *  String^z̃p[^擾܂<BR>
	 *
	 *  @param name 擾p[^
	 *  @return String[] String^Ŏ擾ꂽl
	 *  @exception ParameterNotFoundException œnꂽp[^̕ϐHttpServletRequest̒ɂȂꍇ
	 */	
	public String[] getStringArray(String name) throws ParameterNotFoundException {
		String[] value = partArrayAsInput(name);
		if (value == null) return new String[]{""};
		else return value;
	}

	/**
	 *  HttpServletRequest̓e𕶎ŕԂ܂B
	 *  @return String HttpServletRequest̓e
	 */	
	public String parse() {
		StringBuffer sb = new StringBuffer("\n<-Parsed Requrest is ----------------------------------------------------->\n");
		sb.append(partArrayAsString());
		sb.append(getArrayValues(req.getAttributeNames(),  ATTRIBUTE));
		sb.append(getArrayValues(req.getHeaderNames(), HEADER));
		return sb.toString();
	}
	
	/**
	 *  HttpServletRequest̓e𕶎ŕԂ܂B
	 *  @param type RequestParser.PARAMETER HttpServletRequestɊ܂܂p[^B<br>
	 *			   RequestParser.ATTRIBUTE HttpServletRequestɊ܂܂鑮B<br>
	 * 									iHttpServletRequest.setAttibute(String key, Object value)Őݒ肳ꂽlj<br>
	 *			   RequestParser.HEADER HttpServletRequestɊ܂܂wb_[B
	 *  @return String HttpServletRequest̓e
	 */	
	public String parse(int type) {
		switch (type) {
			case IRequestParser.PARAMETER	:	return partArrayAsString();
			case IRequestParser.ATTRIBUTE	:	return getArrayValues(req.getAttributeNames(), IRequestParser.ATTRIBUTE);
			case IRequestParser.HEADER		:	return getArrayValues(req.getHeaderNames(), IRequestParser.HEADER);
		}
		return "";
	}	
		
	private String partAsInput(String name) {
		for (Iterator i = parts.iterator() ; i.hasNext() ;) {
			Part part = (Part)i.next();
			if (part.getName().equals(name) && part.getType() == Part.INPUT)  {
				String[] val = new String[]{(String)part.getContent()};
				return val[0];
			}
		}
		return null;
	}

	private String[] partArrayAsInput(String name) {
		List l = new ArrayList();
		for (Iterator i = parts.iterator() ; i.hasNext() ;) {
			Part part = (Part)i.next();
			if (part.getName().equals(name) && part.getType() == Part.INPUT) l.add((String)part.getContent());
		}
		return (String[])l.toArray(new String[l.size()]);
	}
	private String partArrayAsString() {
		StringBuffer sb = new StringBuffer();
		sb.append("\t- Parameters -\n");

		for (Iterator i = parts.iterator() ; i.hasNext() ;) {
			Part part = (Part)i.next();
			sb.append("\t\t" +  part.getName() + " = ");
			String value = null;
			if (part.getType() == Part.INPUT) {
				value = (String)part.getContent();
			} else if (part.getType() == Part.FILE) {
				 value = (String)part.getFileName();
			}
			sb.append(value + "\n");
		}
		return sb.toString();		
	}

	public Iterator getParameterNames() {
		List list = new ArrayList();
		if ( parts == null || parts.size() == 0 ) return null;
		for (Iterator i = parts.iterator() ; i.hasNext() ;) {
			Part part = (Part)i.next();
			list.add(part.getName());
		}
		try {
			return (Iterator)list.iterator();
		} catch (ClassCastException e) {
			return null;
		}
	}
}
