package wisdom.core.request;

import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Iterator;
import java.util.Enumeration;

import javax.servlet.http.HttpServletRequest;

import wisdom.core.CoreObject;
import wisdom.core.CoreRuntimeException;
import wisdom.core.application.IRequestParser;
import wisdom.core.command.RequestCommand;
import wisdom.core.util.Base64Util;
import wisdom.core.util.StringUtil;


/**
 * IRequestParser̎NX<br>
 * ̃NX͒ʏHttpServletRequest͂܂BZbVփANZXꍇA
 * UnsupportedExceptiono܂B<br>
 * 
 * 2004/10/29 WA0028Ή
 * 2005/5/24 WA0037̑Ή
 * 2005/9/12 WA0041̑Ή
 * @author  Takao Kouda
 * @version 1.0
 */
public class ParameterParser extends CoreObject implements IRequestParser {
	public static final String REQUEST_PARAMETER_ENCODEING = "request.parameter.encoding";
	private String encoding = null;
	protected static final String[] authType = {"Basic"};
	
	protected static final String authorization = "authorization";
	
	protected static final String delim = ":";
	protected HttpServletRequest req = null;
	protected String reqId = null;
	
	/**
	 *  RXgN^<BR>
	 *  @param req ͂HttpServletRequestIuWFNg
	 */
	public ParameterParser(HttpServletRequest req) {
		this.req = req;
		encoding = configManager.getString(REQUEST_PARAMETER_ENCODEING,null);
	}
	
	public String getString(String name) throws ParameterNotFoundException {
		String[] value = req.getParameterValues(name);
		value = encode(value);
		if (value == null) {
			throw new ParameterNotFoundException(name, messageGenerator.getMessage("WPE0010", name) );
		}
		return value[0].trim();
	}
	
	public String getString(String name, String def) {
		try { 
			return getString(name); 
		} catch (ParameterNotFoundException e) { 
			return def; 
		}
	}
	protected String[] encode(String[] values) {
		if (StringUtil.notEmpty(encoding) && values != null) {
			String[] values_ = new String[values.length];
			for (int i = 0 ; i < values.length ; i++) {
				try {
					values_[i] = new String(values[i].getBytes("iso-8859-1"), encoding);
				} catch (UnsupportedEncodingException uee) {
					throw new CoreRuntimeException(messageGenerator.getMessage("WPE0050",encoding));
				} catch (NullPointerException uee) {
					throw new CoreRuntimeException(messageGenerator.getMessage("WPE0050",encoding));					
				}
			}
			return values_;
		} else {
			return values;
		}
	}
	public String getStringNoTrim(String name) throws ParameterNotFoundException {
		String[] value = req.getParameterValues(name);
		value = encode(value);
		if (value == null) throw new ParameterNotFoundException(name, messageGenerator.getMessage("WPE0010", name));
		else return value[0];
	}
	
	public String getStringNoTrim(String name, String def) {
		try { 
			return getStringNoTrim(name); 
		} catch (ParameterNotFoundException e) { 
			return def; 
		}
	}	

	public int getInt(String name) throws ParameterNotFoundException, NumberFormatException {
		String val = null;
		try { 
			val = getString(name);		
			return Integer.parseInt(val);
		} catch (NumberFormatException nfe) {
			throw new ParameterNotFoundException(name, messageGenerator.getMessage("WPE0020", new String[] {name, val, "int"}));			
		}
	}

	public int getInt(String name, int def) {
		try { return getInt(name); }
		catch (ParameterNotFoundException e) { return def; }
		catch (NumberFormatException ne) { return def; }		
	}

	public double getDouble(String name) throws ParameterNotFoundException, NumberFormatException {
		String val = null;		
		try { 
			val = getString(name);		
			return Double.parseDouble(val);
		} catch (NumberFormatException nfe) {
			throw new ParameterNotFoundException(name, messageGenerator.getMessage("WPE0020", new String[]{name, val, "double"}));			
		}
		
	}

	public double getDouble(String name, double def) {
		try { return getDouble(name); }
		catch (ParameterNotFoundException e) { return def; }
		catch (NumberFormatException ne) { return def; }
	}
	
	public Part getPart(String name) throws ParameterNotFoundException {
		throw new UnsupportedOperationException(getClass().getName()+" not spports getPart() method.");
	}	

	public List getPartArray(String name) throws ParameterNotFoundException {
		throw new UnsupportedOperationException(getClass().getName()+" not spports getPart() method.");
	}
			
	public String[] getStringArray(String name) throws ParameterNotFoundException {
		String[] value = req.getParameterValues(name);
		value = encode(value);
		if (value == null) return new String[]{""};
		else return value;
	}
	public String[] getStringArrayWithNull(String name)  {
		String[] value = req.getParameterValues(name);
		value = encode(value);
		return value;
	}	
	public HttpServletRequest getRequest() { return req;}

	public String getContextPath() { return req.getContextPath(); }

	public Object getAttribute(String key) throws AttributeNotFoundException {
		Object o = (Object)req.getAttribute(key);
		if (o == null) throw new AttributeNotFoundException(key, messageGenerator.getMessage("WPE0010",key) );
		return o;
	}

	public String getHeader(String key) throws AttributeNotFoundException{ 
		String  o = req.getHeader(key);
		if (o == null) throw new AttributeNotFoundException(key, messageGenerator.getMessage("WPE0040",key));
		return o;
	}

	public Object getAttribute(String key, boolean allowNull) throws AttributeNotFoundException {
		Object o = (Object)req.getAttribute(key);
		if (o == null && !allowNull) throw new AttributeNotFoundException(key, messageGenerator.getMessage("WPE0010",key));
		return o;
	}
	
	public String getHeader(String key ,boolean allowNull) throws AttributeNotFoundException {
		String o = req.getHeader(key);
		if (o == null && !allowNull) throw new AttributeNotFoundException(key, messageGenerator.getMessage("WPE0040",key));
		return o;
	}
	
	/**
	 *  HTTP BASICF؂̃[U[ID擾B<>
	 *
	 *  @param req ͂HttpServletRequestIuWFNg
	 *  @param type F؃^Cv
	 *  @return String ͂ꂽ[U[IDB̒lBase64fR[hꂽlłB
	 */	
 	public static String getUserId(HttpServletRequest req, int type) {
		try {
			String header = req.getHeader(authorization);
			String userInfo = header.substring(authType[type].length());

			String encordedId = new Base64Util().decode(userInfo.trim());

			if (encordedId.length() == 0) return "";

			int i = encordedId.indexOf(delim);
			if (i != -1) return encordedId.substring(0, i);
			else return encordedId;
		} catch (Exception e) {
			return "";			
		}
	}

	/**
	 *  HTTP BASICF؂̃pX[h擾B<BR>
	 *  @param req ͂HttpServletRequestIuWFNg
	 *  @param type F؃^Cv
	 *  @param encode truȅꍇBase64fR[hꂽlAfalsȅꍇBase64ŃGR[hꂽ܂ܖ߂܂B
	 *  @return String ͂ꂽpX[h
	 */	
	public static String getPassword(HttpServletRequest req, int type, boolean encode) {
		try {
			String header = req.getHeader(authorization);
			String userInfo = header.substring(authType[type].length());
			Base64Util b64 = new Base64Util();
			
			String encordedId = b64.decode(userInfo.trim());
			if (encordedId.length() == 0) return "";
			
			int i = encordedId.indexOf(delim);
			if (i != -1) {
				if (encode) return encordedId.substring(i + 1);
				else return b64.encode(encordedId.substring(i + 1));
			}
			else return "";
		} catch (Exception e) {
			return "";			
		}
	}	

	public String parse() {
		StringBuffer sb = new StringBuffer("\n<-Parsed Requrest is ----------------------------------------------------->\n");
		sb.append(getArrayValues(req.getParameterNames(), PARAMETER));
		sb.append(getArrayValues(req.getAttributeNames(),  ATTRIBUTE));
		sb.append(getArrayValues(req.getHeaderNames(), HEADER));
		return sb.toString();
	}
	
	public String parse(int type) {
		switch (type) {
			case IRequestParser.PARAMETER	:	return getArrayValues(req.getParameterNames(), IRequestParser.PARAMETER);
			case IRequestParser.ATTRIBUTE	:	return getArrayValues(req.getAttributeNames(), IRequestParser.ATTRIBUTE);
			case IRequestParser.HEADER		:	return getArrayValues(req.getHeaderNames(), IRequestParser.HEADER);
		}
		return "";
	}	

	String getArrayValues(Enumeration e, int type) {
		if (e == null) return "";

		StringBuffer sb = new StringBuffer();
		switch (type) {
			case IRequestParser.PARAMETER	:	sb.append("\t- Parameters -\n")	;	break;
			case IRequestParser.ATTRIBUTE	:	sb.append("\t- Attributes -\n")	;	break;	
			case IRequestParser.HEADER		:	sb.append("\t- Headers -\n")	;	break;
		}

		String key = null;
		String value = null;
		while(e.hasMoreElements()) {
			key = (String)e.nextElement();
			sb.append("\t\t" +  key + " = ");
			switch(type) {
				case IRequestParser.PARAMETER	:	value = (String)req.getParameter(key)	;	break;
				case IRequestParser.ATTRIBUTE	:	Object temp = req.getAttribute(key);
									if (temp != null) {
										value = temp.getClass().getName();
										Object temp_ = req.getAttribute(key);
										if (temp_ != null) value += " " + temp_.toString();
										else value += " " + "null";
									} else value = "null";
									break;
				case IRequestParser.HEADER		:	value = (String)req.getHeader(key)		;	break;								
			} 
			sb.append(value + "\n");
		}
		return sb.toString();
	}

	public Iterator getParameterNames() {
		try {
			return (Iterator)req.getParameterNames();
		} catch (ClassCastException e) {
			return null;
		}
	}

	public RequestCommand getCommand() {
		return (RequestCommand)req.getAttribute(IRequestParser.COMMAND);
	}
	
	public String getCommandName() {
		return getCommand().getClass().getName();	
	}
	
	public void setReqId(String reqId) {
		this.reqId = reqId;
	}
	
	public String getReqId() {
		return reqId;
	}
}
