package wisdom.core.runtime;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.Map;
import java.util.Hashtable;
import java.util.Collection;
import java.sql.Connection;
import java.sql.SQLException;

import javax.servlet.ServletContext;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import wisdom.core.CoreMessageGenerator;
import wisdom.core.CoreObject;
import wisdom.core.MessageGenerator;
import wisdom.core.application.IBatchHandler;
import wisdom.core.connections.ConnectionDef;
import wisdom.core.connections.ConnectionManager;
import wisdom.core.connections.ConnectionManagerFactory;

import wisdom.core.util.StringUtil;

/**
 * IBatchtHandler̎NX<br>
 * 
 * @author  Takao Kouda
 * @version 1
 *
 */
public class BatchHandler extends CoreObject implements IBatchHandler  {
	
	protected ConnectionManager conm 	= null;
	protected Object invoker 			= null;
	protected Map attribute			= null;	
	private Map connections = new Hashtable();

	/**
	 * RXgN^
	 */
	public BatchHandler(Object invoker) throws Exception {
		super();
		this.invoker = invoker;
		attribute = new HashMap();
	}

	public void setAttribute(String key, Object value) {
		attribute.put(key, value);
	} 

	public Object getAttribute(String key) {
		return attribute.get(key);
	} 


	public Connection getConnection(String defineName) throws Exception {
		Connection c_ = (Connection)connections.get(defineName);
		if (c_ == null) {
			ConnectionDef def = configManager.getConnectionDef(defineName);
			ConnectionManager cmgr = ConnectionManagerFactory.create(def);
			c_ = cmgr.getConnection(invoker);
			connections.put(def.getDefineName(),c_);
		}
		return c_;
	}	

	public Connection getConnection(String defineName, String user, String password) throws Exception {
		Connection c_ = (Connection)connections.get(defineName);
		if (c_ == null) {
			ConnectionDef def = configManager.getConnectionDef(defineName);
			ConnectionManager cmgr = ConnectionManagerFactory.create(def);
			c_ = cmgr.getConnection(invoker, user, password);
			connections.put(def.getDefineName(),c_);
		}
		return c_;
	}
	
	public Connection getConnection() throws Exception {
		ConnectionDef def = configManager.getConnectionDef();
		Connection c_ = (Connection)connections.get(def.getDefineName());
		if (c_ == null) {
			ConnectionManager cmgr = ConnectionManagerFactory.create(def);
			c_ = cmgr.getConnection(invoker);
			connections.put(def.getDefineName(),c_);
		}
		return c_;
	}	
	
	public Connection getConnection(String user, String password) throws Exception {
		ConnectionDef def = configManager.getConnectionDef();
		Connection c_ = (Connection)connections.get(def.getDefineName());
		if (c_ == null) {
			ConnectionManager cmgr = ConnectionManagerFactory.create(def);
			c_ = cmgr.getConnection(invoker, user, password);
			connections.put(def.getDefineName(),c_);
		}
		return c_;
	}
	
	public Connection getConnection(Object invoker) throws Exception {
		ConnectionDef def = configManager.getConnectionDef();
		Connection c_ = (Connection)connections.get(def.getDefineName());
		if (c_ == null) {
			ConnectionManager cmgr = ConnectionManagerFactory.create(def);
			c_ = cmgr.getConnection(invoker);
			connections.put(def.getDefineName(),c_);
		}
		return c_;
	}	
	
	public Connection getConnection(Object invoker, String user, String password) throws Exception {
		ConnectionDef def = configManager.getConnectionDef();
		Connection c_ = (Connection)connections.get(def.getDefineName());
		if (c_ == null) {
			ConnectionManager cmgr = ConnectionManagerFactory.create(def);
			c_ = cmgr.getConnection(invoker, user, password);
			connections.put(def.getDefineName(),c_);
		}
		return c_;
	}	
	public Connection getConnection(Object invoker, String defineName) throws Exception {
		Connection c_ = (Connection)connections.get(defineName);
		if (c_ == null) {
			ConnectionDef def = configManager.getConnectionDef(defineName);
			ConnectionManager cmgr = ConnectionManagerFactory.create(def);
			c_ = cmgr.getConnection(invoker);
			connections.put(def.getDefineName(),c_);
		}
		return c_;
	}	
	public Connection getConnection(Object invoker, String defineName, String user , String password) throws Exception {
		Connection c_ = (Connection)connections.get(defineName);
		if (c_ == null) {
			ConnectionDef def = configManager.getConnectionDef(defineName);
			ConnectionManager cmgr = ConnectionManagerFactory.create(def);
			c_ = cmgr.getConnection(invoker, user, password);
			connections.put(def.getDefineName(),c_);
		}
		return c_;
	}	


	public void commitAllConnections() {
		for (Iterator i = connections.values().iterator() ; i != null && i.hasNext();) {
			Connection c = (Connection)i.next();
			if (c == null) continue;
			try {
				c.commit();
			} catch (Exception e) {}
		}		
	}
	public void closeAllConnections() {
		for (Iterator i = connections.values().iterator() ; i != null && i.hasNext();) {
			Connection c = (Connection)i.next();
			if (c == null) continue;
			try {
				c.close();
			} catch (Exception e) {}
		}		
	}	
	public void rollBackAllConnections() {
		for (Iterator i = connections.values().iterator() ; i != null && i.hasNext();) {
			Connection c = (Connection)i.next();
			if (c == null) continue;
			try {
				c.rollback();
			} catch (Exception e) {}
		}		
	}
	public void closeConnection(Connection c) throws Exception {
		for (Iterator i = connections.values().iterator() ; i != null && i.hasNext();) {
			Connection c_ = (Connection)i.next();
			boolean isClosed = false;
			try {
				isClosed = c_.isClosed();
			} catch (SQLException e) {}
			
			if (c_ == null || isClosed) continue;
			c_.commit();
			c_.close();
			connections.values().remove(c_);		
		}		
	}	
	public Object getInvoker() {
		return (Object)invoker;
	}
}