package wisdom.core.runtime;

import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;

import wisdom.core.CoreObject;
import wisdom.core.Log;
import wisdom.core.LogFactory;
import wisdom.core.application.IRequestCommand;
import wisdom.core.application.IUserSession;
import wisdom.core.command.RequestCommand;
import wisdom.core.session.MissingSessionObjectException;


/**
 * 1R}hNXɑ΂2dTu~bg̗}sNXB
 * 
 * [U[ZbVɑ΂1R}hNX̓s1ɗ}܂B
 * R}hNXɑ΂ēɕ̗vꍇAŏ̃NGXgȍ~̃R}hNX̎s
 * }Aȍ~̃R}hNX̌ʂŏ̃NGXg̉ɒuĖ߂܂B
 * 
 * ̃NXFrontControllerŎgpĂ܂AŝRequestHanlder̃CX^X
 * SSHRHandleȑꍇɂ̂ݗLłB
 *
 * @author  Takao Kouda
 * @version 0.90, 1/1/2001
 *
 */
public final class ProcessController extends CoreObject {
	private static final ProcessController self = new ProcessController();
	
	private Hashtable stackByCommandName = null;
	
	/**
	 * RXgN^
	 * ͓ŃOo͂邽߂̃RXgN^ŋ[IɃVOgɂĂ܂B
	 * ͎g܂B
	 */
	private ProcessController() {
		super();		
	}
	/**
	 * Ŏgp郍Op̃CX^X擾܂B
	 */
	private static ProcessController getInstance() {
		return self;
	}
	
	/**
	 * RXgN^
	 * ftHgERXgN^͎gpł܂B
	 */
	private ProcessController(RequestHandler rh) {
		super();
		stackByCommandName = new Hashtable();	
	}

	protected  static boolean isCommandProcessing(RequestHandler rh) throws Exception {
		Log l = LogFactory.create();
		
		if (!(rh instanceof SessionRequestHandler)) {
			return false;
		}
		
		SessionRequestHandler rh_ = (SessionRequestHandler)rh;			
		
		ProcessController proc = null;
		
		/* SessionProcessContollerꍇ͎擾Aꍇ͐put*/
		try {
			proc = (ProcessController)rh.getSessionAttribute(ProcessController.class.getName());
		} catch (MissingSessionObjectException mse) {
			proc = new ProcessController(rh);
		}
		rh.setSessionAttribute(ProcessController.class.getName(), proc);
		rh_.hs.setAttribute(IUserSession.SESSION_NAME, rh_.us);
			
		
		/* Command擾 */
		RequestCommand cmd = (RequestCommand)rh.getInvoker();
		String cmdName = cmd.getClass().getName();
		cmd.setProcesController(proc);
				
		/* RequestHandler̎sStack쐬 */
		Stack processingCommands = (Stack)proc.stackByCommandName.get(cmdName);
		if (processingCommands == null) {
			processingCommands = new Stack();
		}

		/* StackłȂꍇARequestHandler𒆒f */
		if (!processingCommands.empty()) {
l.inform(self,"isCommandProcessing", 
					new StringBuffer("[U[(")
									.append(rh_.getUserSession().getUserid())
									.append(")R}h(")
									.append(cmd.getName())
									.append(")ɑ΂2dTu~bgv܂B")
									.append("O̗vI܂őҋ@܂B")
									.append("(ҋ@̃NGXg ")
									.append(rh)
									.append(")")
									.toString());
			processingCommands.push(rh);	
			proc.stackByCommandName.put(cmdName, processingCommands);
			return true;
		} else {
			processingCommands.push(rh);
			proc.stackByCommandName.put(cmdName, processingCommands);
			return false;			
		}
	}
	
	public void notifyCommandFinished(RequestHandler rh) throws Exception {
		if (!(rh instanceof SessionRequestHandler)) {
			return ;
		}
		
		RequestCommand cmd = (RequestCommand)rh.invoker;		
												
		/* CommandStack擾 */
		Stack processingCommands = (Stack)stackByCommandName.get(cmd.getName());

		/* !  null͂肦Ȃ͂ */
		if (processingCommands == null) {
			return;
		}
		
		/* sCommandiStack̐擪j̏ꍇ͑CommandI*/
		if (!rh.suspend) {
			boolean isFirst = true;
			boolean singleReqeust = true;
			Vector preDuplicateRequestHandler = new Vector();
			RequestHandler topStackHandler = null;
			while(!processingCommands.empty()) {

				RequestHandler rh_ = (RequestHandler)processingCommands.pop();

				if (isFirst) {
					rh_.req 		= rh.req;
					rh_.res 		= rh.res;
					rh_.invoker 	= rh.invoker;
					rh_.pp 			= rh.pp;
					rh_.conm 		= rh.conm;
					rh_.cancel 		= false;										
					rh_.suspend 	= false;
					topStackHandler = rh_;
					isFirst 		= false;
				} else {
					rh_.cancel 		= true;
					singleReqeust 	= false;
					preDuplicateRequestHandler.add(rh_);
				}
				
			}
			topStackHandler.preDuplicateRequestHandler = preDuplicateRequestHandler;
			if (!singleReqeust) {
				rh.suspend();
			}
		}
	}
		

	public String toString() {
		return new StringBuffer(
			getClass().getName()).append
			(" ").append
			(stackByCommandName)
			.toString();
	}
}