package wisdom.core.runtime;
import java.io.IOException;
import java.sql.Connection;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import wisdom.core.ConfigManager;
import wisdom.core.CoreException;
import wisdom.core.CoreMessageGenerator;
import wisdom.core.CoreServletException;
import wisdom.core.Log;
import wisdom.core.LogFactory;
import wisdom.core.MessageGenerator;
import wisdom.core.ServletRuntimeConfig;
import wisdom.core.application.IAuthenticate;
import wisdom.core.application.IBatchCommand;
import wisdom.core.application.IExceptionHandler;
import wisdom.core.application.IRequestCommand;
import wisdom.core.application.IRequestHandler;
import wisdom.core.application.IRequestParser;
import wisdom.core.command.CommandSet;
import wisdom.core.command.RequestCommand;
import wisdom.core.request.ParameterNotFoundException;
import wisdom.core.request.ParameterParser;
import wisdom.core.request.PasswordNotFoundException;
import wisdom.core.session.UserSessionFactory;
import wisdom.core.util.DateUtil;
import wisdom.core.util.StringUtil;

/**
* AvP[V̓ƂȂT[ubg<br>
* {@link ServletRuntimeConfig RuntimeServet̍\NX}炷ׂĂ̏擾܂B
* ʂ̍\T[ubg𓯂AvP[Vō쐬ꍇ͂̃NXpT[ubg쐬A
* \ǉ܂B<br>
*
* 2004/7/21 2dTu~bg~
* 2004/7/10 G[y[W̊Oy[WΉiړqhttp̏ꍇAforwardł͂ȂsendRedirectj 
* 2004/6/7  IExceptionHandlerΉ<br>
* 2004/5/21 WAS V4Ή<br>
* 2005/03/03 WA0036 Ή<br>
* TODO ReqidNotFoundExceptionoꍇAOȂ
* TODO OSServletExceptionɂȂĂ܂
*  
* @author Takao Kouda
* @version 1
*/
public class RunTimeServlet extends HttpServlet {
	/**
	 * T[ubgReLXg擾邽߂̑(WAS4.X)
	 */
	public static final String APPLICATION_NAME_WASV4 = "com.ibm.websphere.servlet.application.name";

	protected ServletRuntimeConfig servletRuntimConfig = null;
	protected MessageGenerator messageGenerator = null;
	protected Log l = null;
	protected CommandSet commandSet = null;
	protected Map headers = null;
	protected Map onInitBatchCommands = null;
	protected String contentType = null;

	/**
	 * 	HTMLŎgp郆[U[ID̃tB[h
	 * 	l"user_"łB
	 */
	public static final String USER = "user_";

	/**
	 * 	HTMLŎgppX[h̃tB[h
	 *  l"password_"łB
	 */
	public static final String PASSWORD = "password_";


	/**
	 * <br>
	 * {@link ConfigManager#getServletRuntimeConfig(String) }As̃T[ubgNXgp
	 * {@link ServletRuntimeConfig RuntimeServet̍\NX}擾܂B
	 *
	 */
	public void init(ServletConfig config) throws ServletException {
		super.init(config);
		
		l = LogFactory.create();
		
		l.trace(this, "init", "entry");

		ConfigManager configManager = ConfigManager.getInstance();
		messageGenerator = CoreMessageGenerator.getInstance();

		/* T[ubgReLXg̎擾 WAS V4 Ή@2004/5/21*/
		String context = (String)getServletContext().getAttribute(APPLICATION_NAME_WASV4);
		if (StringUtil.isEmpty(context)) { /* if ǉ 2004/5/21*/
			configManager.setContext(config.getServletContext().getServletContextName());
		}


		servletRuntimConfig = configManager.getServletRuntimeConfig(getClass().getName());
		l.inform(this, "init", "\n" + servletRuntimConfig.asString());

		try {
			 commandSet = new CommandSet(config.getServletContext(), servletRuntimConfig.getCommandFileName());
		} catch (Exception e) {
			l.error(this, "init" , e);
		}
		headers = servletRuntimConfig.getHeaders();
		contentType = servletRuntimConfig.getContentType();
		onInitBatchCommands = servletRuntimConfig.getOnInitBatchCommands();

		for (Iterator keys = onInitBatchCommands.keySet().iterator(); keys != null && keys.hasNext() ; ) {
			String seq = (String)keys.next();
			String className = (String)onInitBatchCommands.get(seq);
			try {
				IBatchCommand batch = (IBatchCommand)Class.forName(className).newInstance();
				batch.execute();
			} catch (Exception e ){
				l.error(this,e);
			}
		}
		l.trace(this, "init", "exit");
	}

	/**
	 * HTTP GETs܂B<br>
	 * sOɂ̃NXێ{@link ServletRuntimeConfig#isAllowGetMethod() }falsȅꍇ
	 * A{@link ForbiddenMethodException }o܂B
	 * @param req
	 * @param res
	 */
	public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
		l.trace(this, "doGet", "Entry");

		if (!servletRuntimConfig.isAllowGetMethod())
			throw new ForbiddenMethodException(messageGenerator.getMessage("SRC0010","GET"));

		try {
			main(req,res);
		} catch (Exception e) {
			if (e instanceof CoreServletException) {
				//l.error(this, "doGet", ((CoreServletException)e).getSourceException());
				l.error(this, "doGet", e);
			} else {
				l.error(this, "doGet", e);
			}
			res.sendError(HttpServletResponse.SC_INTERNAL_SERVER_ERROR,
				"[" + e.getClass().getName() + "] \n message "  + e.getMessage()+"j");
		}

		l.trace(this, "doGet", "Exit");
	}
	/**
	 * HTTP GETs܂B<br>
	 * sOɂ̃NXێ{@link ServletRuntimeConfig#isAllowGetMethod() }falsȅꍇ
	 * A{@link ForbiddenMethodException }o܂B
	 * @param req
	 * @param res
	 */
	public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
		l.trace(this, "doPost", "Entry");

		if (!servletRuntimConfig.isAllowPostMethod())
			throw new ForbiddenMethodException(messageGenerator.getMessage("SRC0010","POST"));

		try {
			main(req,res);
		} catch (Exception e) {
			if (e instanceof CoreServletException) {
				//l.error(this, "doPost", ((CoreServletException)e).getSourceException());
				l.error(this, "doPost", e);	
			} else {
				l.error(this, "doPost", e);
			}
			res.sendError(HttpServletResponse.SC_INTERNAL_SERVER_ERROR,
				"[" + e.getClass().getName() + "] \n message "  + e.getMessage()+"j");
		}

		l.trace(this, "doPost", "Exit");
	}

	protected void main(HttpServletRequest req, HttpServletResponse res) throws Exception {
		String page = null;
		RequestHandler rh = null;
		boolean isCommandProcessing = false;

		RequestCommand command = null;

		try {

			/* ZbV̎gpۂɂHandlerNX̐؂ւ */
			if (servletRuntimConfig.isEnablesSession()) {
				rh = new SessionRequestHandler(req, res, getServletConfig());

			} else {
				rh = new RequestHandler(req, res, getServletConfig());
			}
			/* F؂Kvȏꍇ */
			if (servletRuntimConfig.isAuthenticateRequired()) {
				authenticate(rh);


			/* F؂svŃZbVgp\ȏꍇ 2004/5/6 c */
			} else if (servletRuntimConfig.isEnablesSession()) {
				UserSessionFactory.create(rh);
			}

			/* BASICF؂̏ꍇ̋󃊃NGXgp̃gbv */
			if (rh.isEnterUserId()) {
				return;
			}

			/* ZbṼ`FbN(RequestHandler͏ĂȂ)*/
			rh.sessionCheck();

			command = (RequestCommand)rh.getCommand(commandSet, servletRuntimConfig);

// ȉǉ 2004/7/21
			page = command.execute(rh);
// ȉRg 2004/7/21
//			if (ProcessController.isCommandProcessing(rh)) {						/* 2dTu~bg */
//				rh.suspend();
//				page = ((RequestCommand)rh.invoker).sendPage();
//			} else {
//				page = command.execute(rh);
//			}
//			if (rh.cancel) {
//				rh.suspend = false;		/* ǉĂ݂ */
//				return;
//			}
			
			req.setAttribute(IRequestParser.ATTRIBUTE_NAME, rh.getRequestParser());		/* ̃Zbg */
			req.setAttribute(IRequestParser.COMMAND , command);							/* sR}hݒ */

			if (!command.isUseDownLoad()) {											/* DownLoadgp*/

				if (headers.size() != 0 ){
					for (Iterator i = headers.keySet().iterator() ;
							i != null && i.hasNext(); ) {
						String key = (String)i.next();
						String value = (String)headers.get(key);
						res.setHeader(key, value);
					}
				}
				if (StringUtil.notEmpty(contentType)) {
					res.setContentType(contentType);
				}

				if (page == null) {
					throw new CoreException(messageGenerator.getMessage("WCE0110", command.getClass().getName()));
				}
				if (!command.isUseRedirect())  {
					forward(page, req, res);
				} else {

					String referer = req.getHeader("referer");
					String protocol = null;
					if (referer != null && referer.length() > 5) protocol = referer.substring(0, 5);
					String host = req.getHeader("host");

					if (protocol != null &&  protocol.equalsIgnoreCase("https") && !page.startsWith("http")) {
						StringBuffer sendRoot = new StringBuffer("https://");
						sendRoot.append(host).append(req.getContextPath());
						if (!page.startsWith("/")) {
							sendRoot.append("/");
						}
						l.trace(this, "sendRedirect", "Entry > " + sendRoot +  page);
						res.sendRedirect(sendRoot +  page);			/* sendRedirect */
						l.trace(this, "sendRedirect", "Exit > " + sendRoot +  page);
					} else {
						l.trace(this, "sendRedirect", "Entry > " + page);
						res.sendRedirect(page);						/* sendRedirect */
						l.trace(this, "sendRedirect", "Exit > " + page);
					}
				}
			} else {
				ResponseDownLoader d = (ResponseDownLoader) command.getDownLoader();
				if (d.isGetWriter()) {
					command.getDownLoader().getWriter().flush();
					command.getDownLoader().getWriter().close();
				}
			}
			rh.commitAllConnections();
		} catch (Exception e) {
			if (rh != null) {
				rh.rollBackAllConnections();
				rh.setAttribute("Exception", e);
				req.setAttribute(IRequestParser.ATTRIBUTE_NAME, rh.getRequestParser());
			}
			List exceptionHandlers = servletRuntimConfig.getExceptionHandler();
			for (int i = 0 ; i < exceptionHandlers.size() ; i++) {
				String className = (String)exceptionHandlers.get(i);
				try {
					IExceptionHandler exceptionHandler = (IExceptionHandler)Class.forName(className).newInstance();
					exceptionHandler.handleException(this, command, rh, e);
				} catch (Exception ex) {
					l.error(this, "O" + className + "̎sɎs܂B" + ex.getMessage());
					l.error(this, ex);
				}
			}
			String errorPage = servletRuntimConfig.getErrorPage(e.getClass().getName());
			if (command != null) {
				l.error(command, e.getMessage());
			} else if (rh != null){
				l.error(rh, e.getMessage());
			} else {
				l.error(this, e.getMessage());
			}

			if (StringUtil.notEmpty(errorPage) ) {
				l.inform(this, "O " + e.getClass().getName() +" \y[W " + errorPage + " \܂B");
				if (! errorPage.startsWith("http") ) {
					forward(errorPage, req, res);
				} else {
					l.trace(this, "sendRedirect", "Entry > " +errorPage);
					res.sendRedirect(errorPage);						/* sendRedirect */
					l.trace(this, "sendRedirect", "Exit > " + errorPage);
				}
			} else {
				l.inform(this, "O " + e.getClass().getName() +" \y[Wݒ肳Ă܂BO𑗏o܂B");
				throw e;
				//throw new CoreServletException(e);
			}

		} finally {
			if (rh != null) rh.sessionStateChange(page);											/* ZbVԕύX */
// ȉRg 2004/7/21			
//			rh.finish();															/* 2dTu~bg */
			if (rh != null) rh.closeAllConnections();
		}
		
	}
	/**
	 * CB[U[F؂s܂B
	 * @param req NGXg
	 * @param res X|X
	 * @exception Exception sɑoO
	 */
	private void authenticate(RequestHandler rh) throws Exception {
		l.trace("authenticate", "Entry");
		HttpServletRequest req = rh.getRequest();
		HttpServletResponse res = rh.getResponse();
		IRequestParser rp = rh.getRequestParser();
		boolean isLogonPage = false;
		String user = null;
		try {
			user = rp.getString(USER);
			isLogonPage = true;

		} catch (ParameterNotFoundException pnfe) {}

		/* OIy[WłȂAZbVłɂꍇ͖ɒʂ*/
		if (req.getSession(false) != null && !isLogonPage) {
			return;
		}
		/* BASICF؎gp*/
		if (servletRuntimConfig.getAuthenticateType()
				== ServletRuntimeConfig.AUTH_TYPE_BASIC) {
			authBasic(rh,req,res);

		} else {
			if (!isLogonPage) throw new AuthenticateException(messageGenerator.getMessage("WAE0030"));
			
			/* WA0036 Ή 2005/03/03 */
			String password = null;
			try {
				password = rp.getString(PASSWORD);
			} catch (ParameterNotFoundException pnfe) {
				throw new PasswordNotFoundException(messageGenerator.getMessage("WPW0010"));
			}
			
			//authenticate(rh, user , rp.getString(PASSWORD));
			authenticate(rh, user ,password);
		}
		l.trace("authenticate", "Exit");
	}

	/**
	 * BASICF؂s܂B
	 */
	private void authBasic(RequestHandler rh, HttpServletRequest req,HttpServletResponse res) throws Exception {
		l.trace("authBasic", "Entry");

		String userid = ParameterParser.getUserId(req, ParameterParser.BASIC);
		String password = ParameterParser.getPassword(req, ParameterParser.BASIC, true);

		if ( StringUtil.isEmpty(userid) || check(rh, userid, password) ) {
			enterUserId(res, req.getContextPath());
			rh.setEnterUserId(true);
		} else {
			authenticate(rh, userid, password);
		}
		l.trace("authBasic", "Exit");
	}

	private boolean check(IRequestHandler rh,  String userid, String password) throws Exception {
		l.trace("check", "Entry");
		boolean error = false;
		try {
			authenticate(rh, userid, password);
		} catch (AuthenticateException e) { error = true;}
		l.trace("check", "Exit");
		return error;
	}

	/**
	 * [U[F؂sNXpermission(String,String)s܂B
	 * @param res X|X
	 * @param userid [U[ID
	 * @param password pX[h
	 * @exception Exception [U[F؎NX̏̎sA[U[F؎s
	 */
	private void authenticate(IRequestHandler rh, String userid, String password) throws Exception {
		IAuthenticate a = (IAuthenticate)Class.forName(servletRuntimConfig.getAuthenticateClass()).newInstance();
		a.authenticate(rh, userid, password);
	}

	/**
	 * HTTP BASICF؂pꍇ̃[U[ApX[h͉ʕ\
	 * @param res X|X
	 * @param context ReLXgE[giF؂realmijƂĎgp܂Bj
	 * @exception Exception
	 */
	private void enterUserId(HttpServletResponse res, String context) throws Exception {
		res.setStatus(HttpServletResponse.SC_UNAUTHORIZED);
		res.setHeader("WWW-Authenticate", "Basic realm=\"" + context + "\"");
		res.sendError(HttpServletResponse.SC_UNAUTHORIZED);
	}


	private void forward(String page, HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
		l.trace(this, "forward", "Entry > " + page);		
		RequestDispatcher rd = getServletContext().getRequestDispatcher(page);
		rd.forward(req, res);
		l.trace(this, "forward", "Exit > " + page);
	}

	/**
	private String getUserInfo(HttpServletRequest req) {
		StringBuffer sb = new StringBuffer();
		sb.append("("+ req.getRemoteAddr() + "," +req.getRemoteHost() + ")");
		Cookie cookie[] = req.getCookies();
		boolean found = false;
		if (cookie != null) {
			for (int i = 0 ; i < cookie.length ; i++) {
				if (cookie[i].getName().trim().equals("OPPOPCUSERID") ) {
					sb.append(" OPPOPCUSERID =[" + cookie[i].getValue());
					sb.append("]");
					found = true;
					break; 

				}
			}
		}
		if (! found ) {
			sb.append(" OPPOPCUSERID =[null]");
		}
		return sb.toString();
	}
	*/

}

