package wisdom.core.runtime;

import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import wisdom.core.application.IUserSession;
import wisdom.core.command.CommandSet;
import wisdom.core.command.MissConfiguredException;
import wisdom.core.session.MissingSessionObjectException;
import wisdom.core.session.SessionTimeOutedException;

/**
 * RequestHandlerpāASessionIuWFNgւ̑ɑΉNXB<br>
 * ̃NXł̓RXgN^sHttpSessionUserSession.SESSION_NAMẼL[gp<br>
 * UserSessionIuWFNg擾܂B̂ƂHttpSessionnullAUserSessionnull̏ꍇɂ<br>
 * SessionTimedOutException𑗏o܂B<br>
 * SSHRHandlerSessionStateHandleRequestHandler̗łB<br>
 * 
 * WA0030Ή 2004/11/09
 * @author  Takao Kouda
 * @version 0.90, 1/1/2001
 *
 */
public final class SessionRequestHandler extends RequestHandler  {
	private boolean enterUserId = false;
	private boolean logout = false;
	IUserSession us = null;
	HttpSession hs = null;

	private RequestHandler processingHandler = null;

	/**
	 * RXgN^
	 * @param 		req 	HttpServletRequest̃CX^X
	 * @param 		res 	HttpServletResponsẽCX^X
	 * @param 		servletconfig 
	 * @exception Exception
	 */	
	public SessionRequestHandler(HttpServletRequest req, HttpServletResponse res, ServletConfig servletconfig) throws Exception {
		super(req,res,servletconfig);
	}	
	/**
	 * IuWFNg̏Ԃ`FbN郁\bhłB<br>
	 * ̃\bh͓Ŏgp邽߂ɗpӂĂ܂B<br>
	 * AvP[V͎gpȂłB<br>
	 */
	protected void sessionCheck() throws SessionTimeOutedException {
		HttpSession hs = getRequest().getSession(false);
		if (hs == null) throw new SessionTimeOutedException(messageGenerator.getMessage("WSE0020"));
		this.hs = hs;
		us = (IUserSession)hs.getAttribute(IUserSession.SESSION_NAME);
		if (us == null) throw new SessionTimeOutedException(messageGenerator.getMessage("WSE0020"));
	}
	
	
	/**
	 * ZbVɎw肳ꂽL[Œlݒ肵܂B
	 * @param key ݒ肷IuWFNg̃L[
	 * @param object ݒ肷IuWFNg̒l
	 */
	public void setSessionAttribute(String key, Object object) {
		us.setAttribute(key, object);
	}
	
	/**
	 * ZbV񂩂w肳ꂽL[̃IuWFNg܂B
	 * @param key IuWFNg̃L[
	 */
	public void removeSessionAttribute(String key) {
		us.removeAttribute(key);		
	}
		
	/**
	 * ZbV񂩂w肳ꂽL[̃IuWFNg擾܂B
	 */
	public Object getSessionAttribute(String key) throws MissingSessionObjectException {
		return us.getAttribute(key);		
	}
	
	/**
	 * ZbV񂩂w肳ꂽL[̃IuWFNg擾܂B
	 */
	public Object getSessionAttribute(String key, boolean allowNull) throws MissingSessionObjectException {
		return us.getAttribute(key,allowNull);		
	}
	/**
	 * ZbVHttpSessionIuWFNgput܂B
	 */
	public void sessionStateChange(String page) throws Exception {
		if (us == null || logout == true) {
			return;
		}
		us.setRecentPage(page);
		us.setRecentReqid(reqid);
		if (! res.isCommitted()) {
			hs.setAttribute(IUserSession.SESSION_NAME, us);
		}
	}
	/**
	 * \ȃZbVׂăNA܂B<br>
	 * {@link #addUnremovableSessionAttributeName(String) addUnemovableSessionAttbuteName}œo^ꂽȊÕZbV
	 * ׂremove܂B<br>
	 * 
	 */
	public void cleanupRemovableSessionAttributes() {
		us.cleanupRemovableSessionAttributes();
	}
	
	/**
	 * s\ȃZbVo^܂B<br>
	 * {@link #cleanupRemovableSessionAttributes cleanupRemovableSessionAttributes}ŃNAΏۊOɂZbVkeyo^܂B
	 * o^ꂽkeyZbV{@link #cleanupRemovableSessionAttributes cleanupRemovableSessionAttributes}ŃNA܂B<br>
	 * @param	key s\ȃZbVƂēo^ZbṼL[
	 */
	public void addUnremovableSessionAttributeName(String key){
		us.addUnremovableSessionAttributeName(key);
	}
	
	/**
	 * s\ȃZbVo^܂B<br>
	 * {@link #cleanupRemovableSessionAttributes cleanupRemovableSessionAttributes}ŃNAΏۊOɂZbVkeyo^܂B
	 * o^ꂽkeyZbV{@link #cleanupRemovableSessionAttributes cleanupRemovableSessionAttributes}ŃNA܂B<br>
	 * 
	 * @param	keys s\ȃZbVƂēo^ZbṼL[̔z
	 */
	public void addUnremovableSessionAttributeNames(String[] keys) {
		us.addUnremovableSessionAttributeNames(keys);		
	}
	
	/**
	 * s\ȃZbV폜܂B<br>
	 * {@link #addUnremovableSessionAttributeName(String) addUnremovableSessionAttributeName}A
	 * {@link #addUnremovableSessionAttributeNames(String[]) addUnremovableSessionAttributeNames}
	 * NAΏۊOƂēo^ꂽkey폜܂B<br>
	 * @param	key s\ȃZbV폜ZbṼL[
	 */
	public void removeUnremovableSessionAttributeName(String key) {
		us.removeUnremovableSessionAttributeName(key);
	}
	
	
	/**
	 * s\ȃZbṼL[擾܂B<br>
	 * @return	{@link #addUnremovableSessionAttributeName(String) addUnremovableSessionAttributeName}A
	 * {@link #addUnremovableSessionAttributeNames(String[]) addUnremovableSessionAttributeNames}œo^ꂽs\ȃZbṼL[l܂񂾔zB
	 */
	public List getUnremovableSessionAttributeNames() {
		return us.getUnremovableSessionAttributeNames();
	}

	/**
	 * RequestHandler𒆒f܂B
	 * <b>̃\bh2dTu~bg邽߂ɎgpĂ郁\bhłB</b>
	 * sƁARequestHandlerThread.sleep()s܂B
	 * 
	 */
	protected final void suspend() throws Exception { 
		suspend= true;
		cancel= true;
		int count = 0;		
		int count2 = 0;				
		while(suspend) {
			count++;
			count2++;
			if (count2 == 20) {
inform("suspend", 
					new StringBuffer("[U[(")
									.append(getUserSession().getUserid())
									.append(")R}h(")
									.append(invoker.getClass().getName())
									.append(")̑O̗vI܂őҋ@܂B")
									.append("(ҋ@̃NGXg ")
									.append(this)
									.append(")")
									.toString());
				count2 = 0;
			}

			Thread.sleep(5000);
			if (count > 600) {	/* 5 ďIȂꍇ͔*/
inform("suspend", 
					new StringBuffer("[U[(")
									.append(getUserSession().getUserid())
									.append(")R}h(")
									.append(invoker.getClass().getName())
									.append(")̑O̗v5҂܂B")
									.append("(ҋ@̃NGXg ")
									.append(this)
									.append(")͏܂)")
									.toString());	
					cancel = true;
					return;
			}
		}
inform("suspend", 
					new StringBuffer("[U[(")
									.append(getUserSession().getUserid())
									.append(")R}h(")
									.append(invoker.getClass().getName())
									.append(")̑O̗vI܂B")
									.append("(ҋ@̃NGXg ")
									.append(this)
									.append(")͊J܂B")
									.toString());
	}
	
	/**
	 * RequestHandeȑIƂ2dTu~bgĂꍇsuspendĂقRequestHandlerJ܂B
	 * <b>̃\bh2dTu~bg邽߂ɎgpĂ郁\bhłB</b>
	 * AvP[V͎gpȂłB
	 * 
	 */
	protected final void finish() {
		if (preDuplicateRequestHandler != null) {
			for (Iterator i = preDuplicateRequestHandler.iterator(); i.hasNext();) {
				RequestHandler rh = (RequestHandler)i.next();
				rh.suspend = false;
			}
		}
	}		
	/**
	 * OEAEgԂɂ܂B
	 * ̃\bhs̓OCy[Wɖ߂܂B
	 */
	public void logOut() {
		us.logOut();
		logout = true;	

	}
	/**
	 * ĂUserSessionIuWFNg擾܂B<br>
	 * @return	UserSession	ĂUserSessionIuWFNg
	 */
	public IUserSession getUserSession() {
		return us;
	}	
	
	/**
	 * ĂIUserSessionIuWFNgݒ肵܂B<br>
	 * ̃\bh<@link wisdom.core.application.IAuthenticate>̒Őݒ肳ꂽZbVIuWFNgɑ΂
	 * p̃R}hŎs\Ȃ悤ɒǉ܂B̃\bh̎gp<@link wisdom.core.application.IAuthenticate#authenticate(IRequestHandler, String, String)>
	 * Ɍ肵ĂB<br>
	 * <@link wisdom.core.application.IAuthenticate#authenticate(IRequestHandler, String, String)>ňɓnIRequestHandler̃CX^X
	 * łSessionRequestHandlerɂȂĂ̂ŁÃIuWFNgSessionRequestHandlerɃLXgẴ\bhgp܂B
	 * 
	 * WA0030Ή 2004/11/09
	 * @param us
	 */
	public void setUserSession(IUserSession us) {
		this.us = us;
		
	}
	/**
	 * Gets the enterUserId
	 * @return Returns a boolean
	 */
	public boolean isEnterUserId() {
		return enterUserId;
	}
	/**
	 * Sets the enterUserId
	 * @param enterUserId The enterUserId to set
	 */
	public void setEnterUserId(boolean enterUserId) {
		this.enterUserId = enterUserId;
	}

}