package wisdom.core.runtime;

import java.io.*;
import java.lang.reflect.Field;
import java.math.*;

import wisdom.core.CoreMessageGenerator;
import wisdom.core.CoreRuntimeException;
import wisdom.core.application.IStringValidator;
import wisdom.core.util.StringUtil;

/**
 * IStringValidatorNX̎łB<br><br>
 *
 * 2004/10/29 WA0029Ή<br>
 * 2004/12/09 WA0034Ή
 * @author  Takao Kouda 
 * @version 1
 */
public class StringValidator implements IStringValidator {
	
	private static final BigDecimal zero = new BigDecimal("-1");
	
    private BigDecimal numericValue = null;

    public StringValidator()  {
    	super();
    }

	public int checkString(int checkType, String checkString, int length , String prohibitCharcters) {
		checkParameter(checkType);
		if (containsProhibitCharcters(checkString, prohibitCharcters)) return ERROR_PROHIBIT_CHAR_DETECTED;
		return checkString(checkType, checkString, length);		
	}
	
	public int checkNotEmptyString(int checkType, String checkString, int length , String prohibitCharcters) {
		checkParameter(checkType);	
		if (containsProhibitCharcters(checkString, prohibitCharcters)) return ERROR_PROHIBIT_CHAR_DETECTED;
		if (StringUtil.isEmpty(checkString)) return ERROR_EMPTY_STRING;		
		return checkString(checkType, checkString, length);		
	}

	public int checkString(int checkType, String checkString, int length) {
		checkParameter(checkType);		
		if (StringUtil.isEmpty(checkString)) return VALID_VALUE;
		if (checkString.getBytes().length > length) return ERROR_CHAR_LENGTH_OVERFLOW;		
		
		switch (checkType) {
			case TYPE_ALPHA_NUMERIC :
					if (containsDoubeByte(checkString)) return ERROR_DOUBLE_BYTE_CHAR_DETECTED;
					if (containsKANA(checkString)) return ERROR_SINGLE_BYTE_KANA_DETECTED;
					break;
					
			case TYPE_CHAR:
					break;
								
			case TYPE_DOUBLE_BYTE_CHAR:
					if (containsSingleByte(checkString)) return ERROR_SINGLE_BYTE_CHAR_DETECTED;			
					break;
													
			case TYPE_DOUBLE_BYTE_KANA:
					throw new CoreRuntimeException(
						CoreMessageGenerator.getInstance().getMessage("WRE0070","checkString(TYPE_DOUBLE_BYTE_KANA")
					);
					
			case TYPE_SINGLE_BYTE_CHAR:
					if (containsDoubeByte(checkString)) return ERROR_DOUBLE_BYTE_CHAR_DETECTED;
					break;
					
			case TYPE_SINGLE_BYTE_KANA:
					if (!onlyKANA(checkString)) return ERROR_ANY_CHAR_DETECTED;
					break;					
		}
		return VALID_VALUE;		
	}
	
	public int checkNotEmptyString(int checkType, String checkString, int length) {
		checkParameter(checkType);		
		if (StringUtil.isEmpty(checkString)) return ERROR_EMPTY_STRING;
		return checkString(checkType, checkString, length);
	}


	public int checkNotEmptyNumeric(String checkString, int length, int scale) {
		if (StringUtil.isEmpty(checkString)) return ERROR_EMPTY_STRING;
		return checkNumeric(checkString, length, scale);
	}
	
	public int checkNumeric(String checkString, int length, int scale) {
		/* WA0029 ΉJn */
		if (StringUtil.isEmpty(checkString)) {
			return VALID_VALUE;
		}
		/* WA0029 ΉI */
		
		if (containsDoubeByte(checkString)) return ERROR_DOUBLE_BYTE_CHAR_DETECTED;
		
		try {
			numericValue = new BigDecimal(checkString);
			if(checkString.length() > 18 ) return ERROR_NUMERIC_LENGTH_OVERFLOW;
		//} catch (NumberFormatException nfe) { WA0034Ή
		} catch (Exception nfe) {				// WA0034Ή
			return ERROR_ANY_CHAR_DETECTED;
		}

		long longValue = numericValue.longValue();
		if (Long.toString(longValue).length() > length) 
			return ERROR_NUMERIC_LENGTH_OVERFLOW;
		
		if (scale > 0 && numericValue.scale() > scale) 
			return ERROR_NUMERIC_NUMBER_OF_DECIMAL_OVERFLOW;

		return VALID_VALUE;

	}

	/**
	 * ɑSp܂܂Ă邩A܂܂Ăꍇtrue߂܂B
	 * 
	 * @param	source	镶
	 * @return	Sp܂܂ꂢďꍇtrue
	 */
    protected boolean containsDoubeByte(String source){
        byte[] b  =  source.getBytes();
        if( source.length() == b.length ) return false;
		else return true;
    }
	
	/**
	 * ɔp܂܂Ă邩A܂܂Ăꍇtrue߂܂B
	 * 
	 * @param	source	镶
	 * @return	Sp܂܂ꂢďꍇtrue
	 */
    protected boolean containsSingleByte(String source){
    	for (int i = 0 ; i < source.length() ; i++ ) {
    		String s  = String.valueOf(source.charAt(i));
    		if (s.getBytes().length != 2) return true;
    	}
		return false;
    }
	/**
	 * ɋ֎~܂܂Ă邩A܂܂Ăꍇtrue߂܂B
	 * 
	 * @param	source	镶
	 * @param prohibitCharcters ֎~镶
	 * @return	Sp܂܂ꂢďꍇtrue
	 */
    protected boolean containsProhibitCharcters(String source, String prohibitCharcters){
		boolean found = false;  	
    	for (int i = 0 ; i < source.length() ; i++ ) {
    		String s  = String.valueOf(source.charAt(i));
    		if (prohibitCharcters.indexOf(s) != -1) {
    			found = true;
    			break;
    		} 
    	}
		return found;
    }    	
	/**
	 * ΏەɈȉ͈͓̌̔Ȁ͈͓ꍇ
	 * true߂܂Biz͔pJiłj
	 * Jń͈@	0xff62 
	 * I͈    0xff9f
	 * 
	 * @param	checkString	镶
	 * @return	܂܂Ăꍇtrue
	 */
	protected boolean containsKANA(String checkString) {
		for (int i = 0 ; i < checkString.length() ; i++) {
			char c = checkString.charAt(i);
			if (c >= 0xff62 && c <= 0xff9f) return true;
		}
		return false;
	}	

	/**
	 * ΏەɈȉ͈͓̌̔Ȁ͈͓ꍇ
	 * true߂܂Biz͔pJiłj
	 * Jń͈@	0xff62 
	 * I͈    0xff9f
	 * 
	 * @param	checkString	镶
	 * @return	܂܂Ăꍇtrue
	 */
	protected boolean onlyKANA(String checkString) {
		for (int i = 0 ; i < checkString.length() ; i++) {
			char c = checkString.charAt(i);
			if (c <= 0xff62 || c >= 0xff9f) return false;
		}
		return true;
	}
	
	private void checkParameter(int type) {
		Field[] field = IStringValidator.class.getDeclaredFields();
		boolean found = false;
		for (int i = 0 ; i < field.length ; i++ ) {
			if (field[i].getName().startsWith("TYPE")) {
				try {
					if (type == field[i].getInt(field[i])) found = true; 
				} catch (IllegalAccessException iae) {}
			}
		}
		if (!found) 
		throw new CoreRuntimeException(
			CoreMessageGenerator.getInstance().getMessage("WRE0060","checkType",String.valueOf(type))
		);

	}
	public String errorString(int error) {
		if (error == VALID_VALUE) return "VALID_VALUE"; 
		Field[] field = IStringValidator.class.getDeclaredFields();
		for (int i = 0 ; i < field.length ; i++ ) {
			if (field[i].getName().startsWith("ERROR")) {
				try {
					if (error == field[i].getInt(field[i])) return field[i].getName();
				} catch (IllegalAccessException iae) {}
			}
		}		
		return null;
	}
	public static void main(String[] args) {
		StringValidator c = new StringValidator();
		System.err.println(
		c.errorString(c.checkNotEmptyString(StringValidator.TYPE_ALPHA_NUMERIC,"ABC",10,"A"))
		);
	}
}
