package wisdom.core.util;

import java.util.*;
import java.sql.*;

import wisdom.core.*;

/**
 * tiNjԁibj܂񂾌̂߂̃[eBeBENX<br>
 * tAԂ̑ÓђlTimestampŎ擾邱Ƃł܂B
 * 
 * @author Takao Kouda
 * @version 1
 * 
 */
public class TimestampUtil extends CoreObject {
	private boolean valid = false;
	private int validateLvl = 6;
	private String year = null;
	private String month  = null;
	private String day = null;
	private String hour = null;
	private String minute = null;
	private String second = null;
	
	private boolean[] errors = null;
	private boolean[] entered = null;	
	private int errorNo = 0;
	private static final String[] errorMeesages = new String[] {" ","b","","","","","N"};
	
	/**
	 * RXgN^<br>
	 * x{@link #VALIDATE_LVL_YYYYMMDD_HHMMSS VALIDATE_LVL_YYYYMMDD_HHMMSS}łB
	 * 
	 */
	public TimestampUtil() {
		errors = new boolean[] {false,false,false,false,false,false};		
		entered = new boolean[] {false,false,false,false,false,false};			
	}
	/**
	 * RXgN^
	 * @param	validateLvl x
	 */
	public TimestampUtil(int validateLvl) {
		this();
		this.validateLvl = validateLvl;
	}	
	
	/**
	 * ̃IuWFNg̒l̍ŏljava.sql.TimestampŎ擾܂B<br>
	 * ̃\bhs{@link #isValid() TimestampUtil#isValid() }̖߂l0̏ꍇɓ̒l<br>
	 * Timestampɕϊ܂BK{͍ڂƂȂĂȂl̏ꍇAŏlݒ肳܂B<br>
	 * 
	 * @return ϊꂽTimestamp@{@link #isValid() TimestampUtil#isValid() }sĂȂA܂͓\bh̖߂l0ȊÕIuWFNg̏ꍇnullB
	 */
	public Timestamp getMinTimestamp() {
		if (!valid) return null;
		StringBuffer sb = new StringBuffer();
		if (entered[5]) sb.append(DateUtil.fillDigits(4,Integer.parseInt(year),0));			
		else sb.append("0001");								
		sb.append("-");
		if (entered[4]) sb.append(DateUtil.fillDigits(2,Integer.parseInt(month),0));			
		else sb.append("01");								
		sb.append("-");
		if (entered[3]) sb.append(DateUtil.fillDigits(2,Integer.parseInt(day),0));			
		else sb.append("01");								
		sb.append(" ");
		if (entered[2]) sb.append(DateUtil.fillDigits(2,Integer.parseInt(hour),0));			
		else sb.append("00");								
		sb.append(":");
		if (entered[1]) sb.append(DateUtil.fillDigits(2,Integer.parseInt(minute),0));			
		else sb.append("00");								
		sb.append(":");
		if (entered[0]) sb.append(DateUtil.fillDigits(2,Integer.parseInt(second),0));			
		else sb.append("0");								
		sb.append(".000000000");

		return Timestamp.valueOf(sb.toString());		
	}
	/**
	 * ̃IuWFNg̒l̍őljava.sql.TimestampŎ擾܂B<br>
	 * ̃\bhs{@link #isValid() TimestampUtil#isValid() }̖߂l0̏ꍇɓ̒l<br>
	 * Timestampɕϊ܂BK{͍ڂƂȂĂȂl̏ꍇAőlݒ肳܂B<br>
	 * 
	 * @return ϊꂽTimestamp@{@link #isValid() TimestampUtil#isValid() }sĂȂA܂͓\bh̖߂l0ȊÕIuWFNg̏ꍇnullB
	 */
	public Timestamp getMaxTimestamp() {
		if (!valid) return null;
		StringBuffer sb = new StringBuffer();
		if (entered[5]) sb.append(DateUtil.fillDigits(4,Integer.parseInt(year),0));			
		else sb.append("9999");								
		sb.append("-");
		if (entered[4]) sb.append(DateUtil.fillDigits(2,Integer.parseInt(month),0));			
		else sb.append("12");								
		sb.append("-");
		if (entered[3]) sb.append(DateUtil.fillDigits(2,Integer.parseInt(day),0));			
		else if (entered[4] && entered[5]){
			/*mȌ*/
			int dayOfMonth = DateUtil.daysOfMonth[Integer.parseInt(month)-1];
			if (new GregorianCalendar().isLeapYear(Integer.parseInt(year))
					 && Integer.parseInt(month) == 2) {
				dayOfMonth++;
			}					
			sb.append(DateUtil.fillDigits(2,dayOfMonth,0));
		} else sb.append("31");						
		sb.append(" ");
		if (entered[2]) sb.append(DateUtil.fillDigits(2,Integer.parseInt(hour),0));			
		else sb.append("23");								
		sb.append(":");
		if (entered[1]) sb.append(DateUtil.fillDigits(2,Integer.parseInt(minute),0));			
		else sb.append("59");								
		sb.append(":");
		if (entered[0]) sb.append(DateUtil.fillDigits(2,Integer.parseInt(second),0));			
		else sb.append("59");								
		sb.append(".599999999");

		return Timestamp.valueOf(sb.toString());		
	}	
	/**
	 * ̃IuWFNgԂ܂ޓtƂđÓۂ܂B<br>
	 * ̓IuWFNgɎw肳ꂽxɂK{͍ڂfANAAAAAbׂ̂Ă̒l<br>
	 * ȏꍇ0߂܂B<br>
	 * w肳ꂽxႢڂ́Alݒ肳Ă̑Ώۂɂ͂Ȃ܂<br>
	 * w肳ꂽڂ̏ʁiȂΔNAłΌjw肠邢͑ÓȂꍇAʍڂG[ƂȂ܂B<br>
	 * <br>͂A2̏ꍇ邤Ňs܂B<br>
	 * ߂l<br>
	 * <table BORDER="1" CELLPADDING="3" CELLSPACING="0">
	 * <tr BGCOLOR="#CCCCFF"><td>߂l</td><td>G[e</td></tr>
	 * <tr><td>0</td><td></td></tr>
	 * <tr><td>1</td><td>b</td></tr>
	 * <tr><td>2</td><td></td></tr>
	 * <tr><td>3</td><td></td></tr>
	 * <tr><td>4</td><td></td></tr>
	 * <tr><td>5</td><td></td></tr>
	 * <tr><td>6</td><td>N</td></tr>
	 * </table><br>
	 * łB
	 * 
	 * 
	 * @return 	ꍇ0
	 */
	public int isValid() {
		init();
		errorNo = 0;	
		if ((validateLvl == 0 && year != null) || validateLvl >= VALIDATE_LVL_YYYY) {
			if (year == null || ( !StringUtil.isNumeric(year) || Integer.parseInt(year) > 9999 || Integer.parseInt(year) < 1) ) {
				errors[5] = true;
				setErrorNo(6);
			} else {
				errors[5] = false;
				entered[5] = true;
			}
		}
		if (( validateLvl == 0 && month != null) || validateLvl >= VALIDATE_LVL_YYYYMM) {		
			if (!StringUtil.isMonth(month)) {
				errors[4] = true;	
				setErrorNo(5);				
			} else {
				errors[4] = false;	
				entered[4] = true;	
			}
		}
		if (( validateLvl == 0 && day != null) || validateLvl >= VALIDATE_LVL_YYYYMMDD) {	
			if ( day == null ||  (!StringUtil.isNumeric(day) || Integer.parseInt(day) < 1 || Integer.parseInt(day) > 31)) {
				errors[3] = true;
				setErrorNo(4);			
			} else {
				if (!errors[5] && !errors[4] && entered[5] && entered[4]){
					int dayOfMonth = DateUtil.daysOfMonth[Integer.parseInt(month)-1];
					/* [N */
					if (new GregorianCalendar().isLeapYear(Integer.parseInt(year))
														 && Integer.parseInt(month) == 2) {
						dayOfMonth++;
					}
					if (Integer.parseInt(day) > dayOfMonth) {
						errors[3] = true;					
						setErrorNo(4);						
					} else {
						errors[3] = false;
						entered[3] = true;						
					}
				} else {
					errors[3] = false;
					entered[3] = true;
				}
			}
		}
		
		if (( validateLvl == 0 && hour != null) || validateLvl >= VALIDATE_LVL_YYYYMMDD_HH) {	
			if (!StringUtil.isHour(hour)) {
				errors[2] = true;			
				setErrorNo(3);				
			} else {
				errors[2] = false;			
				entered[2] = true;
			}
		}
		if (( validateLvl == 0 && minute != null) || validateLvl >= VALIDATE_LVL_YYYYMMDD_HHMM) {
			if (!StringUtil.isMinute(minute)) {
				errors[1] = true;			
				setErrorNo(2);				
			} else {
				errors[1] = false;
				entered[1] = true;						
			}
		}
		if (( validateLvl == 0 && second != null) || validateLvl >= VALIDATE_LVL_YYYYMMDD_HHMMSS) {
			if (!StringUtil.isSecond(second)) {
				errors[0] = true;			
				setErrorNo(1);			
			} else {
				errors[0] = false;
				entered[0] = true;						
			}
		}
		boolean check = false;
		boolean error = false;
		for (int i = 0 ; i < entered.length ; i++ ) {
			if (entered[i] == true) {
				check = true;
			} else {
				if (check) {
					error = true;
				 	setErrorNo2(i+1);					
				}
			}
		}	
		if (errorNo == 0) {
			valid = true;
		} else {
			valid = false;			
		}
		return errorNo;
	}
	/**
	 * <br>
	 * eڂ̑ÓG[ꍇɖ߂lݒ肵ĂB
	 */
	private void setErrorNo(int errorNo) {
		if (this.errorNo < errorNo) {
			this.errorNo = errorNo; 
		}
	}
	/**
	 * 
	 * ʍڂw肳ĂȂꍇɖ߂lݒ肵ĂB
	 */
	private void setErrorNo2(int errorNo) {
			this.errorNo = errorNo; 
	}	
	/**
	 * isValid()̖߂lǂ̍ڂ̒lȂ̂A\Ŏ擾܂B<br>
	 * @param	errorNo {@link #isValid() TimestampUtil#isValid()̖߂l}
	 * @return Ȃڂ̕\
	 */
	public  String getMessage(int errorNo) {
		if (errorNo == -1) {
			return errorMeesages[(errorMeesages.length-1) - validateLvl];
		}
		if (errorNo < 7) {
			return errorMeesages[errorNo];
		} else return null;
	}
	
	/**
	 * Nw肵܂B
	 * 
	 * @param year w肷N
	 * @param month w肷錎
	 * @param day w肷
	 */
	public void setDate(int year, int month, int day) {
		setYear(year);
		setMonth(month);
		setDay(day);
	}
	/**
	 * Nw肵܂B
	 * 
	 * @param year w肷N
	 * @param month w肷錎
	 * @param day w肷
	 */
	public void setDate(String year, String month, String day) {
		setYear(year);
		setMonth(month);
		setDay(day);
	}	
	/**
	 * Ԃw肵܂B
	 * 
	 * @param hour w肷鎞
	 * @param minute w肷镪
	 * @param second w肷b
	 */
	public void setTime(int hour, int minute, int second) {
		setHour(hour);
		setMinute(minute);
		setSecond(second);
	}
	/**
	 * Ԃw肵܂B
	 * 
	 * @param hour w肷鎞
	 * @param minute w肷镪
	 * @param second w肷b
	 */
	public void setTime(String hour, String minute, String second) {
		setHour(hour);
		setMinute(minute);
		setSecond(second);
	}		
	/**
	 * Nݒ肵܂B
	 * 
	 * @param	year	ݒ肷N
	 */
	public void setYear(int year) {
		this.year = String.valueOf(year);
	}
	
	/**
	 * ݒ肵܂B
	 * 
	 * @param	month	ݒ肷錎
	 */
	public void setMonth(int month) {
		this.month = String.valueOf(month);
	}

	/**
	 * ݒ肵܂B
	 * 
	 * @param	day	ݒ肷
	 */
	public void setDay(int day) {
		this.day = String.valueOf(day);
	}	
	
	/**
	 * Ԃݒ肵܂B
	 * 
	 * @param	hour	ݒ肷鎞
	 */
	public void setHour(int hour) {
		this.hour = String.valueOf(hour);
	}	
	/**
	 * ݒ肵܂B
	 * 
	 * @param	minute	ݒ肷镪
	 */
	public void setMinute(int minute) {
		this.minute = String.valueOf(minute);
	}
	/**
	 * bݒ肵܂B
	 * 
	 * @param	second	ݒ肷b
	 */
	public void setSecond(int second) {
		this.second = String.valueOf(second);
	}
	/**
	 * Nݒ肵܂B
	 * 
	 * @param	year	ݒ肷N
	 */
	public void setYear(String year) {
		this.year = year;
	}
	
	/**
	 * ݒ肵܂B
	 * 
	 * @param	month	ݒ肷錎
	 */
	public void setMonth(String month) {
		this.month = month;
	}

	/**
	 * ݒ肵܂B
	 * 
	 * @param	day	ݒ肷
	 */
	public void setDay(String day) {
		this.day = day;
	}	
	
	/**
	 * Ԃݒ肵܂B
	 * 
	 * @param	hour	ݒ肷鎞
	 */
	public void setHour(String hour) {
		this.hour = hour;
	}	
	/**
	 * ݒ肵܂B
	 * 
	 * @param	minute	ݒ肷镪
	 */
	public void setMinute(String minute) {
		this.minute = minute;
	}
	/**
	 * bݒ肵܂B
	 * 
	 * @param	second	ݒ肷b
	 */
	public void setSecond(String second) {
		this.second = second;
	}
	
	/**
	 * fobOpvg\bh
	 * gpĂbooelanzdebugo͂B
	 */
	private void debugPrint() {
		debug("errors\n");
		for (int i = 0 ; i < errors.length; i++) {
			debug("errors["+i+"]="+errors[i]);
		}
		debug("\nentered\n");		
		for (int i = 0 ; i < entered.length; i++) {
			debug("entered["+i+"]="+entered[i]);
		}		
	}
	
	/**
	 * x擾܂B
	 * @return	x
	 */
	public int getValidateLvl() {
		return validateLvl;
	}
	
	/**
	 * 
	 * gpĂbooleanzׂfalseɐݒ肵ĂB
	 * 
	 */
	private void init() {
		for (int i = 0 ; i < errors.length; i++) {
			errors[i] = false;
		}
		for (int i = 0 ; i < entered.length; i++) {
			entered[i] = false;
		}		
	}	
	/**
	 * Ó̂߂̒萔<br>
	 * ׂĂ̖͂܂B
	 */
	public static final int VALIDATE_LVL_NONE = 0;
	
	/**
	 * Ó̂߂̒萔<br>
	 * Nȍ~̖͂܂B
	 */
	public static final int VALIDATE_LVL_YYYY = 1;

	/**
	 * Ó̂߂̒萔<br>
	 * ȍ~̖͂܂B
	 */
	public static final int VALIDATE_LVL_YYYYMM = 2;

	/**
	 * Ó̂߂̒萔<br>
	 * ȍ~̖͂܂B
	 */
	public static final int VALIDATE_LVL_YYYYMMDD = 3;

	/**
	 * Ó̂߂̒萔<br>
	 * NAAAȍ~̖͂܂B
	 */
	public static final int VALIDATE_LVL_YYYYMMDD_HH = 4;

	/**
	 * Ó̂߂̒萔<br>
	 * NAAAAȍ~̖͂܂B
	 */
	public static final int VALIDATE_LVL_YYYYMMDD_HHMM = 5;

	/**
	 * Ó̂߂̒萔<br>
	 * ׂĕK{wƂȂ܂B
	 */
	public static final int VALIDATE_LVL_YYYYMMDD_HHMMSS = 6;

}