package wisdomx.logic.formtemplate;

import java.io.*;

import wisdom.core.CoreObject;
import wisdom.core.MessageGenerator;
import wisdom.core.application.AppMessageGenerator;
import wisdom.core.application.IRequestHandler;
import wisdom.core.application.IRequestParser;

/**
 * {@link AbstractFormObject }̃CX^X쐬NXB<br>
 * AbstractFormObject̃TuNXŒ`ꂽtB[ĥ߂̃f[^擾AAbstractFormObject̃CX^X쐬܂B
 * ̃NX̗p҂͈ȉ̏Ŏgp܂B<br>
 *  
 * <b>o^̗</b><br>
 * <pre>
 * rh.setSessionAttribute("fCustomer", new CustomerFormObject().createEmpty()));
 * setPage("customerEdit.jsp");
 * <br>
 * </pre>
 * <b>XV̗</b><br>
 * <pre> 
 * ParameterInputForm inputForm = new ParameterInputForm();
 * inputForm.saveString(rp, "customerNo");
 * rh.setSessionAttribute("fCustomer", new CustFormObjectGenerator(inputForm, rh).generate()));
 * setPage("customerEdit.jsp");
 * </pre>
 * <br>
 *  
 * @author Takao Kouda
 * @version 1
 * @see AbstractFormObject
 */
public abstract class AbstractFormObjectGenerator extends CoreObject implements Serializable {
	/**
	 * TuNXŎgpłParameterInputFormIuWFNg
	 */
  	protected ParameterInputForm inputForm = null;
	/**
	 * TuNXŎgpłIRequestHandlerIuWFNg
	 */
  	protected IRequestHandler rh = null;
	/**
	 * TuNXŎgpłIRequestParserIuWFNg
	 */
  	protected IRequestParser rp = null;  	
	/** 
	 * TuNXŃbZ[W擾邽߂MessageGenerator̃CX^X<br>
	 * IuWFNg{@link AppMessageGenerator }̃CX^X擾܂B
	 */
	protected MessageGenerator messageGenerator = null;
  	
	/**
	 * RXgN^iȂ͔Jj
	 */  	
  	private AbstractFormObjectGenerator() { super(); }

	/**
	 * RXgN^<br>
	 * 
	 * @param inputForm
	 * @param rh
	 * @throws Exception
	 */
  	public AbstractFormObjectGenerator(ParameterInputForm inputForm, IRequestHandler rh) throws Exception { 
  		this();
  		this.inputForm = inputForm;
		this.rh = rh;
		if (rh != null) this.rp = rh.getRequestParser();
		messageGenerator = AppMessageGenerator.getInstance();
  	}
	
	/**
	 * NXp҂s郁\bh<br>
	 * {@link #_generate()}s܂B<br>
	 * 
	 * @return AbstractFormObject̎NX̃CX^X
	 * @throws Exception
	 */
	public AbstractFormObject generate() throws Exception {
		trace("generate", "entry");
		AbstractFormObject p = _generate();
		trace("generate", "exit");		
		return p;
	}
	/**
	 * AbstractFormObjectIuWFNg̍쐬܂B<br>
	 * 
	 * @return AbstractFormObject̎NX̃CX^X
	 * @throws Exception
	 */
	protected abstract AbstractFormObject _generate() throws Exception;	
	

}
