/**
 * Define
 * @version 1.0 2007/7/17
 * @author stsd
 */
package wisdomx.logic.formtemplate;

import java.lang.reflect.Field;

import wisdom.core.util.StringUtil;


/**
 * wisdomxňtB[h`NXB<br>
 * tB[h̃^Cv̓C^[tF[X {@link Types } Œ`Ăϐgp܂B<br>
 * ̃NX́AAvP[VŎgp1f[^ڂNXƂĒ`܂B1ȏ̂̃NX̃CX^X
 * A1e[u\{@link wisdomx.rdbo.RDBODefine }NX`܂B̃NXAvP[VŕKv
 * ȍڂ̏擾܂B<br>
 * ̃NXÓIo[ϐƂĒ`C^[tF[X쐬ĂB̃C^[tF[X̓AvP[V
 * Ŝ̃f[^EfBNVi[ɂȂ܂B<br>
 * j<br>
 * <pre>
 * public interface DataDictionary implements Types {
 *     pubic static final Define USERID    = new Define(CHAR, "USERID" , 10, "[U[ID");
 *     pubic static final Define USERNAME  = new Define(CHAR, "USERNAME" , 30, "[U[");
 * }
 * </pre><br>
 * ꍇɂĖcȐDefineNX`Kvꍇ܂ȀꍇTuVXeŃC^[tF[X
 * ʂɂAōڂ`܂B<br>
 * j<br><pre>
 * publlic interface ASystemDataDisctionay implements Types {
 *     pubic static final Define USERID    = new Define(CHAR, "USERID" , 10, "[U[ID");
 *     pubic static final Define USERNAME  = new Define(CHAR, "USERNAME" , 30, "[U[");
 * }
 * publlic interface BSystemDataDisctionay extends ASystemDataDisctionay {
 *     pubic static final Define SYSTEMID    = new Define(CHAR, "SYSTEMID" , 10, "VXeID");
 *     pubic static final Define SYSTEMNAME  = new Define(CHAR, "SYSTEMNAME" , 30, "VXe");
 * } 
 * publlic interface DataDictionary extends BSystemDataDisctionay {
 * } 
 * </pre>
 * dvȂ̂̓AvP[VŎgp鍀ڂڃxŐ􂢏oAd邱ƂȂ`邱ƂłB
 * 
 * @author  Takao Kouda
 * @version 1
 * TODO TimestampȂǂ̌B-validate()̎
 */
public class Define implements Types {

	protected int type = -1;
	protected String id = null;
	protected int length = -1;
	protected int numberOfDecimals	= 0;
	protected boolean notNull = false;
	protected String label = null;
	protected Object defaultValue = null;
	
	/**
	 * RXgN^<br>
	 * 
	 * @param type	tB[h^Cv
	 * @param id		tB[hID
	 * @param length	tB[h
	 * @param notNull	nulls̏ꍇtrue
	 */
	public Define(int type,
							String id,
							int length,
							String label,
							boolean notNull) {
		this.type = type;
		this.id = id;
		this.length = length;
		this.label = label;
		this.notNull = notNull;
		validate();
	}
	/**
	 * RXgN^<br>
	 * 
	 * @param type		tB[h^Cv
	 * @param id		tB[hID
	 * @param length	tB[h
	 * @param label 	tB[h
	 */
	public Define(int type,
							String id,
							int length,
							String label) {
		this.type = type;
		this.id = id;
		this.length = length;
		this.label = label;
		validate();
	}

	/**
	 * RXgN^<br>
	 * 
	 * @param type		tB[h^Cv
	 * @param id		tB[hID
	 * @param length	tB[h
	 * @param numberOfDecimals	_ȉ̒
	 * @param label	tB[h
	 * @param notNull	nulls̏ꍇtrue
	 */
	public Define(int type,
							String id,
							int length,
							int numberOfDecimals,
							String label,
							boolean notNull) {
		this(type,id,length, label, notNull);
		this.numberOfDecimals = numberOfDecimals;
		validate();
	}
	
	/**
	 * RXgN^<br>
	 * 
	 * @param type		tB[h^Cv
	 * @param id		tB[hID
	 * @param length	tB[h
	 * @param numberOfDecimals	_ȉ̒
	 * @param label		tB[h
	 */
	public Define(int type,
							String id,
							int length,
							int numberOfDecimals,
							String label) {
		this(type,id,length,label);
		this.numberOfDecimals = numberOfDecimals;
		validate();
	}
	
	/**
	 * tB[h̃^Cv擾܂<br>
	 * @return tB[h̃^Cv
	 */
	public int getType() { return type; }

	/**
	 * tB[hID擾܂<br>
	 * @return tB[hID
	 */
	public String getId() {
		return id.toLowerCase();
	}
	
	/**
	 * S啶̃tB[hID擾܂B<br>
	 * @return S啶̃tB[hID
	 */
	public String getUpperCaseId() {
		return id.toUpperCase();
	}	
	
	/**
	 * tB[h擾܂<br>
	 * @return tB[h
	 */
	public String getLabel() {
		return label;
	}

	/**
	 * tB[h擾܂<br>
	 * @return tB[h
	 */
	public int getLengh() {
		return length;
	}
	/**
	 * _ȉ̌擾܂<br>
	 * @return _ȉ̌
	 */
	public int getNumberOfdecimals() {
		return numberOfDecimals;
	}
		

	/**
	 * ̃IuWFNg̃Rs[擾܂B<br>
	 * Rs[ꂽIuWFNg͕ʂ̃CX^XłB<br>
	 * 
	 * @return ̃IuWFNg̃Rs[
	 */
	protected Define deepCopy() {
		return new Define(type,
								id,
								length,
								numberOfDecimals,
								label,
								notNull
		);
	}

	/**
	 * tB[h̃^Cv܂<br>
	 * @return getType() == Types.CHARXXXXX ̂Ƃtrue
	 */
	public boolean isChar() { 
		return (type == CHAR 
				|| type == CHAR_ALPHA_NUMERIC);
	}

	/**
	 * tB[h̃^Cv܂<br>
	 * @return getType() == Types.DECIMAL ̂Ƃtrue
	 */
	public boolean isDecimal() { return (type == DECIMAL); }


	
	/**
	 * tB[hnulls܂<br>
	 * @return nulls̂Ƃtrue
	 */
	public boolean isNotNull() { return notNull; }
	

	/**
	 * ̃IuWFNg̕\擾܂<br>
	 * @return ̃IuWFNg̕\
	 */
	public String asString() {
		StringBuffer sb = new StringBuffer();
		Field[] fs = Types.class.getDeclaredFields();
		sb.append(" ").append(id).append(" ");
		
		for (int i = 0 ; i < fs.length ; i++ ) {
			Field f = fs[i];
			try {
				if (f.getInt(f) == type) {
					sb.append( f.getName() );
					break;
				} 
			} catch (Exception e) {
				throw new RuntimeException(e.getMessage());
			}
		}
		sb.append(" ").append(length).append(" ");
		
		return sb.toString();
	}
	
	private void validate() throws RuntimeException {
		Field[] fs = Types.class.getDeclaredFields();
		boolean found = false;
		for (int i = 0 ; i < fs.length ; i++ ) {
			Field f = fs[i];
			try {
				if (f.getInt(f) == type) {
					found = true;
					break;
				}
			} catch (Exception e) {
				throw new RuntimeException(e.getMessage());
			}
		}
		if (!found) { 
			throw new RuntimeException("萔ƂĐ錾ĂȂTypegpĂ܂");
		}
		if (StringUtil.isEmpty(id)) {
			throw new RuntimeException("ID܂");
		}
	}

}

		