package wisdomx.logic.formtemplate;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.math.BigDecimal;

import wisdom.core.CoreMessageGenerator;
import wisdom.core.CoreRuntimeException;
import wisdom.core.Message;
import wisdom.core.MessageGenerator;
import wisdom.core.application.AppMessageGenerator;
import wisdom.core.util.StringUtil;
import wisdomx.ui.object.IHasMessageList;

public class StringChecker implements Types {

	/** GR[hp萔 Shift JIS */
	public static final String URL_ENC = "Shift_JIS";

	/**
	 * f[^fBNViɒ`ꂽDefinȅɃG[`FbNs܂
	 * iCӓ͂̏ꍇj
	 * @param def DataDictionaryɋLqꂽDefine^萔
	 * @param target `FbN
	 * @return G[R[h
	 */
	public int check(Define def,String target){
		if(DECIMAL == def.getType()){
			return checkNumeric(target, def.getLengh(), def.getNumberOfdecimals());
		}else{
			return checkString(def.getType(), target, def.getLengh());
		}
	}
	
	/**
	 * f[^fBNViɒ`ꂽDefinȅɃG[`FbNs܂
	 * iCӓ͂̏ꍇj
	 * G[foɊi[܂
	 * 
	 * @param def DataDictionaryɋLqꂽDefine^萔
	 * @param target `FbN
	 * @param fo G[Zbgfo
	 * @return G[R[h
	 */
	public int check(Define def,String target,IHasMessageList fo){
		int result = check(def,target);
		if(result != VALID_VALUE){
			Message msg = getMessage(result, def.getLabel(), def.getLengh(), def.getNumberOfdecimals());
			msg.setField(def.getId());
			fo.addErrorMessage(msg);
		}
		return result;
	}
	
	public int check(Define def,String target,IHasMessageList fo, boolean isNotEmpty){
		if (isNotEmpty) {
			return checkNotEmpty(def,target,fo);
		} 
		return check(def,target,fo);
		
	}
	/**
	 * f[^fBNViɒ`ꂽDefinȅɃG[`FbNs܂
	 * iK{͂̏ꍇj
	 * 
	 * @param def DataDictionaryɋLqꂽDefine^萔
	 * @param target `FbN
	 * @param fo G[Zbgfo
	 * @return G[R[h
	 */
	public int checkNotEmpty(Define def,String target){
		if(StringUtil.isEmpty(target)) return ERROR_EMPTY_STRING;
		else return check(def,target);
	}
	
	/**
	 * f[^fBNViɒ`ꂽDefinȅɃG[`FbNs܂
	 * iK{͂̏ꍇj
	 * 
	 * @param def DataDictionaryɋLqꂽDefine^萔
	 * @param target `FbN
	 * @param fo G[Zbgfo
	 * @return G[R[h
	 * G[foɊi[܂
	 */
	public int checkNotEmpty(Define def,String target,IHasMessageList fo){
		int result = -1;
		if(StringUtil.isEmpty(target)) {
			result = ERROR_EMPTY_STRING;
		}else{
			result =  check(def,target);
		}
		if(result != VALID_VALUE){
			Message msg = getMessage(result, def.getLabel(), def.getLengh(), def.getNumberOfdecimals());
			msg.setField(def.getId());
			fo.addErrorMessage(msg);
		}
		return result;
	}
	
	/**
	 * G[R[hDefine`G[bZ[W擾܂
	 * @param errorCode G[R[h
	 * @param def Define`
	 * @return G[bZ[W
	 */
	public Message getMessage(int errorCode, Define def){
		return getMessage(errorCode, def.getLabel(), def.getLengh(), def.getNumberOfdecimals());
	}
	
	/**
	 * G[R[hƒlG[bZ[W𐶐ĕԂ܂<BR>
	 * `̃G[R[hnꂽꍇCoreRuntimeExceptionX[܂
	 * @param errorCode G[R[h
	 * @param fieldLabel tB[h
	 * @param len 
	 * @param numberOfDecimals _
	 * @return G[bZ[W
	 */
	public Message getMessage(int errorCode, String fieldLabel, int len, int numberOfDecimals){
		MessageGenerator messageGenerator = AppMessageGenerator.getInstance();
		String messageCode = "DCG" + errorCode + "E";
		switch (errorCode) {
			case ERROR_NUMERIC_LENGTH_OVERFLOW :
					return messageGenerator.getMessage(messageCode, fieldLabel, String.valueOf(len));
			case ERROR_NUMERIC_NUMBER_OF_DECIMAL_OVERFLOW :
					return messageGenerator.getMessage(messageCode, fieldLabel, String.valueOf(numberOfDecimals));
			case ERROR_CHAR_LENGTH_OVERFLOW :
					return messageGenerator.getMessage(messageCode, fieldLabel, String.valueOf(len));
			case ERROR_DOUBLE_BYTE_CHAR_DETECTED :
					return messageGenerator.getMessage(messageCode, fieldLabel);
			case ERROR_SINGLE_BYTE_CHAR_DETECTED :
					return messageGenerator.getMessage(messageCode, fieldLabel);
			case ERROR_SINGLE_BYTE_KANA_DETECTED  :
					return messageGenerator.getMessage(messageCode, fieldLabel);
			case ERROR_ANY_CHAR_DETECTED  :
					return messageGenerator.getMessage(messageCode, fieldLabel);
			case ERROR_EMPTY_STRING  :
					return messageGenerator.getMessage(messageCode, fieldLabel);
			case ERROR_PROHIBIT_CHAR_DETECTED  :
					return messageGenerator.getMessage(messageCode, fieldLabel);
		}
		throw new CoreRuntimeException(messageGenerator.getMessage("DCG9100E"));
	}
	
	
	private BigDecimal numericValue = null;

	/**
	 * ̃tH[}bg`FbNs܂(֎~`FbN)
	 * @param checkType `FbN^Cv
	 * @param checkString 
	 * @param length 
	 * @param prohibitCharcters ֎~
	 * @return 
	 */
	private int checkString(int checkType, String checkString, int length , String prohibitCharcters) {
		checkParameter(checkType);
		if (containsProhibitCharcters(checkString, prohibitCharcters)) return ERROR_PROHIBIT_CHAR_DETECTED;
		return checkString(checkType, checkString, length);
	}
	
	/**
	 * ̕K{`FbNEtH[}bg`FbNs܂(֎~`FbN)
	 * @param checkType `FbN^Cv
	 * @param checkString 
	 * @param length 
	 * @param prohibitCharcters ֎~
	 * @return
	 */
	private int checkNotEmptyString(int checkType, String checkString, int length, String prohibitCharcters) {
		checkParameter(checkType);	
		if (containsProhibitCharcters(checkString, prohibitCharcters)) return ERROR_PROHIBIT_CHAR_DETECTED;
		if (StringUtil.isEmpty(checkString)) return ERROR_EMPTY_STRING;
		return checkString(checkType, checkString, length);
	}
	
	/**
	 * ̃tH[}bg`FbNs܂
	 * @param checkType `FbN^Cv
	 * @param checkString 
	 * @param length 
	 * @return
	 */
	private int checkString(int checkType, String checkString, int length) {
		checkParameter(checkType);
		if (StringUtil.isEmpty(checkString)) return VALID_VALUE;
		
		/* 2007/5/16 kouda `FbNύX */
		//if (checkString.getBytes().length > length) return ERROR_CHAR_LENGTH_OVERFLOW;
		try {
			if (checkString.getBytes(URL_ENC).length > length) return ERROR_CHAR_LENGTH_OVERFLOW;
		} catch (UnsupportedEncodingException e) {
			return ERROR_CHAR_LENGTH_OVERFLOW;
		}
		
		switch (checkType) {
			case CHAR:
					if(containsKANA(checkString)) return ERROR_SINGLE_BYTE_CHAR_DETECTED;
					break;
					
			case CHAR_ALPHA_NUMERIC:
					if (containsDoubeByte(checkString)) return ERROR_DOUBLE_BYTE_CHAR_DETECTED;
					if (containsKANA(checkString)) return ERROR_SINGLE_BYTE_KANA_DETECTED;
					break;
		}
		return VALID_VALUE;	
	}
	
	/**
	 * ̕K{`FbNEtH[}bg`FbNs܂
	 * @param checkType `FbN^Cv
	 * @param checkString 
	 * @param length 
	 * @return
	 */
	private int checkNotEmptyString(int checkType, String checkString, int length) {
		checkParameter(checkType);
		if (StringUtil.isEmpty(checkString)) return ERROR_EMPTY_STRING;
		return checkString(checkType, checkString, length);
	}
	
	/**
	 * l̕K{`FbNE`FbNs܂
	 * @param checkString l
	 * @param length 
	 * @param scale XP[
	 * @return
	 */
	private int checkNotEmptyNumeric(String checkString, int length, int scale) {
		if (StringUtil.isEmpty(checkString)) return ERROR_EMPTY_STRING;
		return checkNumeric(checkString, length, scale);
	}
	
	/**
	 * ľ`FbNs܂
	 * @param checkString l
	 * @param length 
	 * @param scale XP[
	 * @return
	 */
	private int checkNumeric(String checkString, int length, int scale) {
		/* WA0029 ΉJn */
		if (StringUtil.isEmpty(checkString)) {
			return VALID_VALUE;
		}
		/* WA0029 ΉI */
		
		if (containsDoubeByte(checkString)) return ERROR_DOUBLE_BYTE_CHAR_DETECTED;
		
		if (scale == 0 && checkString.indexOf(".") != -1) {
			return ERROR_ANY_CHAR_DETECTED;
		}
		
		try {
			numericValue = new BigDecimal(checkString);
			if(checkString.length() > 18 ) return ERROR_NUMERIC_LENGTH_OVERFLOW;
		//} catch (NumberFormatException nfe) { WA0034Ή
		} catch (Exception nfe) {				// WA0034Ή
			return ERROR_ANY_CHAR_DETECTED;
		}

		long longValue = numericValue.longValue();
		if (Long.toString(longValue).length() > length) 
			return ERROR_NUMERIC_LENGTH_OVERFLOW;

/* 2007/06/04 shimazaki XP[0̏ꍇɃXP[`FbNsȂ̂C */
//		if (scale > 0 && numericValue.scale() > scale)
		if (numericValue.scale() > scale)
			return ERROR_NUMERIC_NUMBER_OF_DECIMAL_OVERFLOW;

		return VALID_VALUE;
	}

	/**
	 * ɑSp܂܂Ă邩A܂܂Ăꍇtrue߂܂B
	 * 
	 * @param	source	镶
	 * @return	Sp܂܂ꂢďꍇtrue
	 */
	private boolean containsDoubeByte(String source){
		try {
			byte[] b  =  source.getBytes(URL_ENC);
			if( source.length() == b.length ) return false;
			else return true;
		} catch (UnsupportedEncodingException e) {
			return false;
		}
	}
	
	/**
	 * ɔp܂܂Ă邩A܂܂Ăꍇtrue߂܂B
	 * 
	 * @param	source	镶
	 * @return	Sp܂܂ꂢďꍇtrue
	 */
	private boolean containsSingleByte(String source){
		try {
			for (int i = 0 ; i < source.length() ; i++ ) {
				String s  = String.valueOf(source.charAt(i));
				if (s.getBytes(URL_ENC).length != 2) return true;
			}
			return false;
		} catch (UnsupportedEncodingException e) {
			return false;
		}
	}
	/**
	 * ɋ֎~܂܂Ă邩A܂܂Ăꍇtrue߂܂B
	 * 
	 * @param	source	镶
	 * @param prohibitCharcters ֎~镶
	 * @return	Sp܂܂ꂢďꍇtrue
	 */
	private boolean containsProhibitCharcters(String source, String prohibitCharcters){
		boolean found = false;  	
		for (int i = 0 ; i < source.length() ; i++ ) {
			String s  = String.valueOf(source.charAt(i));
			if (prohibitCharcters.indexOf(s) != -1) {
				found = true;
				break;
			} 
		}
		return found;
	}
	/**
	 * ΏەɈȉ͈͓̌̔Ȁ͈͓ꍇ
	 * true߂܂Biz͔pJiłj
	 * Jń͈@	0xff62 
	 * I͈    0xff9f
	 * 
	 * @param	checkString	镶
	 * @return	܂܂Ăꍇtrue
	 */
	public boolean containsKANA(String checkString) {
		for (int i = 0 ; i < checkString.length() ; i++) {
			char c = checkString.charAt(i);
			if (c >= 0xff62 && c <= 0xff9f) return true;
		}
		return false;
	}	

	/**
	 * ΏەɈȉ͈͓̌̔Ȁ͈͓ꍇ
	 * true߂܂Biz͔pJiłj
	 * Jń͈@	0xff62 
	 * I͈    0xff9f
	 * 
	 * @param	checkString	镶
	 * @return	܂܂Ăꍇtrue
	 */
	private boolean onlyKANA(String checkString) {
		for (int i = 0 ; i < checkString.length() ; i++) {
			char c = checkString.charAt(i);
			if (c <= 0xff62 || c >= 0xff9f) return false;
		}
		return true;
	}
	
	private void checkParameter(int type) {
		Field[] field = Types.class.getDeclaredFields();
		boolean found = false;
		for (int i = 0 ; i < field.length ; i++ ) {
			if (!field[i].getName().startsWith("ERROR") && !field[i].getName().startsWith("VALID") ) {
				try {
					if (type == field[i].getInt(field[i])) found = true; 
				} catch (IllegalAccessException iae) {}
			}
		}
		if (!found) 
		throw new CoreRuntimeException(
			CoreMessageGenerator.getInstance().getMessage("WRE0060","checkType",String.valueOf(type))
		);

	}
	private String errorString(int error) {
		if (error == VALID_VALUE) return "VALID_VALUE"; 
		Field[] field = Types.class.getDeclaredFields();
		for (int i = 0 ; i < field.length ; i++ ) {
			if (field[i].getName().startsWith("ERROR")) {
				try {
					if (error == field[i].getInt(field[i])) return field[i].getName();
				} catch (IllegalAccessException iae) {}
			}
		}
		return null;
	}

}
