package wisdomx.ui.builder;

import java.util.*;
import java.sql.*;

/**
 * ɎgpPPreparedStatement쐬NX<br>
 * ̃NXSQL WHERE ȍ~̏gݗĂ܂B<br>
 * CX^XɁAWHERE܂܂ȂSSQLnAp[^ݒ肵܂Bݒ肵p[^̒l
 * null̏ꍇAݒ肵p[^͖܂B<br>
 * 
 * update 2004/5/24<br> 
 * WITH URΉ@ȗSQL̍Ō"WITH UR"ǉ܂BǉȂꍇARXgN^ŕύXĂB
 * 
 * @author  Takao Kouda 
 * @version 1
 *
 */
public class StatementBuilder {
	private List conditions = null;
	private StringBuffer buffer = null;
	private Connection c = null;
	private boolean readOnly = true;
	private boolean ur = true;
	private String orderBy = null;
	private String groupBy = null;
	
	/**
	 * RXgN^<br>
	 * 
	 * @param selectFieldSQL SQL WHERE܂łSELECTiWHERE܂܂Ȃj
	 * @param connection PreparedStatement쐬DBڑ
	 */
	public StatementBuilder(String selectFieldSQL, Connection connection) {
		super();
		this.buffer = new StringBuffer(selectFieldSQL);
		this.c = connection;

		conditions = new Vector();
	}
	
	/**
	 * RXgN^<br>
	 * SQLɊ܂܂"WITH UR"ǉ邩ۂwłRXgN^<br>
	 * 
	 * @param selectFieldSQL SQL WHERE܂łSELECTiWHERE܂܂Ȃj
	 * @param connection PreparedStatement쐬DBڑ
	 * @param isUr SQL̍ŌWITH URǉ邩ۂBtrueŒǉAfalseŒǉȂB
	 * @since 2004/5/24
	 * @author Takao Kouda
	 */
	public StatementBuilder(String selectFieldSQL, Connection connection, boolean isUr) {
		this(selectFieldSQL, connection);
		ur = isUr;
	}
		
	/**
	 * PreparedStatement쐬܂B<br>
	 * 쐬IuWFNg<br>
	 * Connection#prepareStatement(sql, ResultSet.TYPE_SCROLL_INSENSITIVE , ResultSet.CONCUR_READ_ONLY);<br>
	 * gp쐬邽߁APreparedStatementsŎ擾ResultSet̓XN[\łB<br>
	 * 
	 * @return 쐬ꂽPreparedStatement
	 * @throws Exception
	 */
	public PreparedStatement buildStatement() throws Exception {
		PreparedStatement ps =  c.prepareStatement(generateSQL(), ResultSet.TYPE_SCROLL_INSENSITIVE , ResultSet.CONCUR_READ_ONLY);
		setParameter(ps);
		return ps;
	}
	/**
	 * ANDǉ܂B<br>
	 * <pre>
	 * StatementBuilder buider = new StatementBuilder(
	 * 	"SELECT USERID,DEPTNAME FROM USER LEFT OUTER JOIN DEPARTMENT USING (USER.DEPTID = DEPARTMENT.DEPTID)"
	 * ); 
	 * buider.and(parameterInputForm.getString("userid",null) , "USER.USERID = ?");</pre><br>
	 * ̏ꍇAparameterInputForm擾łuserid̒lnull̏ꍇASQLWHERE͒ǉȂ
	 * PreparedStatement쐬܂Buserid̒lnullȊȌꍇASQLWHERE USER.USERID = ? 
	 * PreparedStatement쐬Ap[^ݒ肳ꂽԂɂȂ܂B<br><br>
	 * ̒ǉƂWHEREȍ~̏ǉ܂Aand\bh̏ꍇȀǉȑO
	 * ʂ̏ǉĂꍇÃ\bhɂǉANDƂĒǉ܂B<br>
	 * @param fieldValue
	 * @param expression
	 */
	public void and(String fieldValue, String expression) {
		addCondition(AND, fieldValue, expression);
	}
	/**
	 * ORǉ܂B<br>
	 * {and(String, String) }ƓłBor\bh̏ꍇȀǉȑO
	 * ʂ̏ǉĂꍇÃ\bhɂǉORƂĒǉ܂B<br>
	 * @param fieldValue
	 * @param expression
	 */	
	public void or(String fieldValue, String expression) {
		addCondition(OR, fieldValue, expression);
	}
		
	/**
	 * SQL ORDER BYݒ肵܂B<br>
	 * ̃\bh{@link #buildStatement()}̒ō쐬SQL̍ŌORDER BY ǉ̂łB<br>
	 * orderBySQL ORDER BY ܂߂Kv͂܂B
	 */
	public void setOrderBy(String orderBy) {
		this.orderBy = orderBy;
	}
	
	/**
	 * SQL GROUP BYݒ肵܂B<br>
	 * ̃\bh{@link #buildStatement()}̒ō쐬SQL̍ŌGROUP BY ǉ̂łB<br>
	 * groupBySQL GROUP BY ܂߂Kv͂܂B
	 */
	public void setGroupBy(String groupBy) {
		this.groupBy = groupBy;
	}
	
	private String generateSQL() throws Exception {
		for (int i = 0 ; i < conditions.size() ; i++ ) {
			ConditionField f = (ConditionField)conditions.get(i);
			if (i == 0) {
				buffer.append(" WHERE ");
			} else {
				if (f.conditionType == AND) {
					buffer.append(AND_);
				} else {
					buffer.append(OR_);
				}
			}
				 
			buffer.append(f.expression);
		}
		if (groupBy != null && groupBy.length() != 0) buffer.append(" GROUP BY ").append(groupBy);
		if (orderBy != null && orderBy.length() != 0) buffer.append(" ORDER BY ").append(orderBy);
				
		if (readOnly) buffer.append(" FOR READ ONLY");
		
		if (c.getMetaData().getDatabaseProductName().toLowerCase().indexOf("db2") != -1 && ur) {
			buffer.append(" WITH UR ");

		}
		
		return buffer.toString();
	}
	private void setParameter(PreparedStatement ps) throws Exception {
		int index = 0;
		for (int i = 0 ; i < conditions.size() ; i++ ) {
			ConditionField f = (ConditionField)conditions.get(i);
			if (f.expression.indexOf("?") != -1) {
				index++;
				ps.setString(index, f.fieldValue);
			}
		}
	}
	private void addCondition(int conditionType, String fieldValue, String expression) {
		if (fieldValue == null) return;
		conditions.add(new ConditionField(conditionType,fieldValue,expression));
	}
	class ConditionField {
		private int conditionType = -1;
		private String fieldValue = null;
		private String expression = null;
		
		private ConditionField(int conditionType, String fieldValue, String expression) {
			super();
			this.conditionType = conditionType;
			this.fieldValue = fieldValue;
			this.expression = expression;
		}

	}
	private static final int AND = 1;
	private static final int OR = 2;
	private static final String AND_ = " AND ";
	private static final String OR_ = " OR ";
	
}