package wisdomx.ui.builder;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.*;

import wisdomx.ui.object.FullRowsPageList;
import wisdomx.ui.object.IPageList;
import wisdomx.ui.object.PageListRow;
import wisdomx.ui.object.PerPageRowsPageList;
import wisdomx.ui.render.IPageListDecorator;
/**
 * PreparedStatementIPageList쐬IPageListBuilder̎NX<br>
 * NXłPreparedStatement#executeQuery()sResultSet
 * IPageList쐬܂BResultSet̓J[\EXN[gp邽߁A
 * PreparedStatement<br>
 * <pre>
 * 		Connection#prepareStatement(sql, ResultSet.TYPE_SCROLL_INSENSITIVE,ResultSet.CONCUR_READ_ONLY);
 * </pre><br>
 * gpč쐬ĂBPreparedStatementSQLɃp[^E}[J
 * ܂܂ĂꍇÃNXsOɂׂẴp[^ݒ肳Ă
 * Kv܂B<br>
 * @author  Takao Kouda
 * @version 1
 */
public class StatementPageListBuilder implements IPageListBuilder {
	
	private PreparedStatement statement = null;
	private List rows = null;
	private int totalRowNumber = 0; 
	
	private IPageListDecorator decorator = null;
	/**
	 * RXgN^<br>
	 * 
	 * @param statement sPreparedStatement
	 * @param decorator
	 */
	public StatementPageListBuilder(PreparedStatement statement, IPageListDecorator decorator) {
		this.statement = statement;
		this.decorator = decorator;
	}

	public IPageList buildPerPageRows(int perPageRows, int currentPageIndex) throws Exception {
		int startRowIndex = 1;
		if (currentPageIndex > 1) {
			startRowIndex = perPageRows * (currentPageIndex-1) +1;
		}
		rows = select(startRowIndex, perPageRows);
		return new PerPageRowsPageList(rows, perPageRows, currentPageIndex, totalRowNumber, decorator);
	}
	
	public IPageList buildFullRowsPage(int perPageRows, int currentPageIndex) throws Exception{ 
		FullRowsPageList page = new FullRowsPageList(select(), perPageRows, decorator);
		page.setCurrentPageIndex(currentPageIndex);
		return page;
	}	
	
	private List select() throws Exception {
		List list = new Vector();
		ResultSet rs = statement.executeQuery();
		ResultSetMetaData rsmd = rs.getMetaData();
		int columnSize = rsmd.getColumnCount();
		while(rs.next()){
			String[] values = new String[columnSize];
			for (int i = 0 ; i < columnSize;  i++ )  {
				String s = rs.getString(i+1);
				if (s != null) s = s.trim();
				values[i] = s;
			}
			list.add(new PageListRow(values));
		}
		rs.close();
		statement.close();
		totalRowNumber = list.size();
		return list;
	}	
	private List select(int startRowNumber, int getRowCount) throws Exception {
		List list = new Vector();		
		ResultSet rs = statement.executeQuery();
		ResultSetMetaData rsmd = rs.getMetaData();
		int columnSize = rsmd.getColumnCount();
		
		boolean found = false;
		for (found = rs.absolute(startRowNumber); found ; found = rs.next()) {
			if ( !found ) break;
			String[] values = new String[columnSize];
			for (int i = 0 ; i < columnSize;  i++ )  {
				String s = rs.getString(i+1);
				if (s != null) s = s.trim();
				values[i] = s;
			}
			list.add(new PageListRow(values));
			if (list.size() == getRowCount) break;
		}
		//if (found) {
			if (!rs.isLast()) rs.last();
			totalRowNumber = rs.getRow();
		//}
		rs.close();
		statement.close();
		return list;
	}	
}
