package wisdomx.ui.object;

import java.io.Serializable;
import java.util.*;

import wisdomx.ui.render.*;
/**
 * {@link IPageList}̒ێłB<br>
 * 
 * 2004/10/18 WA0027̑Ή 
 * @author Takao Kouda
 * @version 1
 * 
 * 
 */
public abstract class AbstractPageList implements IPageList, Serializable {
	
	protected List rows = null;
	protected int perPageRows = 0;
	protected int currentPageIndex = 0;
	protected int totalPage = 0;
	protected boolean previous = false;
	protected boolean next = false;	
	protected IPageListDecorator decorator = null;

	public boolean hasPrevious() { 
		return (currentPageIndex > 1); 
	}
	public boolean hasNext() { 
		return (totalPage > currentPageIndex);
	}	
	public int getNextPageRows() {
		if (!hasNext()) return -1;
		int last = size() - (currentPageIndex * perPageRows);
		if (last > perPageRows) return perPageRows;
		return last;
	}

	public int size() { return rows.size();}
	
	public PageListRow get(int index) {
		return (PageListRow)rows.get(index);
	}
	
	public int getPerPageRows() {
		return perPageRows;
	}
	
	public Iterator iterator() {
		return rows.iterator();
	}

	public int getTotalPageCount() {
		return totalPage;
	}
	
	public int getCurrentPageIndex() {
		return currentPageIndex;
	}	
	
	
	public String drawPageCounter(IPageListDecorator pageDecorator) {
		/* WA0027Ή */		
		//return pageDecorator.drawCounter(rows.size(),  totalPage, perPageRows, currentPageIndex, true, true);		
		return pageDecorator.drawCounter(rows.size(),  totalPage, perPageRows, currentPageIndex, hasPrevious(), hasNext());
	}
	public String drawPrevious(IPageListDecorator pageDecorator) {
		return pageDecorator.drawPrevious(hasPrevious());
	}
	public String drawNext(IPageListDecorator pageDecorator) {
		return pageDecorator.drawNext(hasNext());
	}	
	
	public String drawPageCounter() {
		return drawPageCounter(decorator);
	}
	
	public String drawPrevious() {
		return drawPrevious(decorator);
	}
	
	public String drawNext() {
		return drawNext(decorator);
	}
	
	public String toString() {
		StringBuffer sb = new StringBuffer(getClass().getName()).append("=");
		for (int i = 0 ; i < rows.size() ; i++) {
			sb.append(rows.get(i).toString());
		}
		return sb.toString();
	}

	public String toHidden() {	
		StringBuffer sb = new StringBuffer();
		sb.append(Tag.hidden(PAGE_INDEX, String.valueOf(currentPageIndex)));
		sb.append(Tag.hidden(PER_PAGE_ROWS, String.valueOf(perPageRows)));		
		return sb.toString();
	}
	public String toHidden(String fieldPrefix) {
		fieldPrefix = fieldPrefix.replace('.' ,'_');	
		StringBuffer sb = new StringBuffer();
		sb.append(Tag.hidden(fieldPrefix+PAGE_INDEX, String.valueOf(currentPageIndex)));
		sb.append(Tag.hidden(fieldPrefix+PER_PAGE_ROWS, String.valueOf(perPageRows)));		
		return sb.toString();
	}
	public String getHiddenName(String fieldPrefix) {
		return fieldPrefix = fieldPrefix.replace('.' ,'_');
	}
	
}
	