package wisdomx.ui.object;

import java.io.Serializable;
import java.util.*;

import wisdomx.ui.render.*;

/**
 * Sy[Wێ{@link IPageList}̎NX<br>
 * ̃NX͑Sy[Wێ܂B
 * 
 * @author Takao Kouda
 * @version 1
 */
public class FullRowsPageList extends AbstractPageList implements Serializable {
	public static final long serialVersionUID = 1L;

	/**
	 * RXgN^<br>
	 * 
	 * @param rows Sy[W̍s
	 * @param perPageRows 1y[W̕\s
	 */
	public FullRowsPageList(List rows, int perPageRows) {
		super();
		this.rows = rows;
		this.perPageRows = perPageRows;
		init();
		currentPageIndex = 1;
	}

	/**
	 * RXgN^<br>
	 * 
	 * @param rows Sy[W̍s
	 * @param perPageRows 1y[W̕\s
	 * @param pageDecorator ̃IuWFNg̕`Ɏgp{@link IPageListDecorator }̃CX^X
	 */
	public FullRowsPageList(List rows, int perPageRows, IPageListDecorator pageDecorator) {
		this(rows, perPageRows);
		this.decorator = pageDecorator;
	}
	
	private void init() {
		if (size() != 0) {
			totalPage = size() / perPageRows;
			if (size() % perPageRows != 0) totalPage++;
			currentPageIndex = (totalPage / perPageRows);
			if (currentPageIndex == 0) currentPageIndex = 1;
		}
	}

	public int getTotalRows() {
		return size();
	}
		
	/**
	 * ݃y[W̃y[WɈړ܂B<br>
	 * y[WꍇɎy[WɈړ܂BȂꍇړ܂B
	 *
	 */
	public void nextPage() {
		if (hasNext()) currentPageIndex++;
	}


	/**
	 * ݃y[WÕy[WɈړ܂B<br>
	 * y[WꍇɑOy[WɈړ܂BȂꍇړ܂B
	 *
	 */
	public void previouesPage() {
		if (hasPrevious()) currentPageIndex--;
	}	
	

	public List currentPage() {
		Vector v = new Vector();
		if (size() != 0 ) {
			int from = (currentPageIndex-1) * perPageRows;
			if (from < 0 ) from = 0;
			int to = from + perPageRows;
			if (to > rows.size()) to = rows.size();
			for (int i = from; i < to ; i++) {
				v.add(rows.get(i));
			}
		}
		return v;
	}
	
	/**
	 * ̃IuWFgׂĂPageListRowɃ`FbNԂݒ肵܂B<br>
	 * 
	 * @param check
	 */
	public void setCheck(boolean check) {
		for (int i = 0 ; i < size(); i ++) {
			PageListRow row = get(i);
			row.setCheck(check);
		}
	}
	
	/**
	 * indexɌ݃y[Ẅʒuݒ肵܂B<br>
	 * Jny[Wԍ0łB
	 * 
	 * @param index w肷錻݃y[Ẅʒu
	 */
	public void setCurrentPageIndex(int index) {
		currentPageIndex = index;
	}
	


}
	