package wisdomx.ui.object;

import java.util.*;

import wisdomx.ui.render.*;

/**
 * ꗗ`\̃IuWFNg쐬邽߂̋ʃC^[tF[XB<br> 
 * 
 * 2004/5/27 {@link #getTotalRows()}̒ǉ<br>
 * @author Takao Kouda
 * @version 1
 */
public interface IPageList  {

	/**
	 * ݂̃y[WECfbNX擾邽߂̒萔BHTMLhiddentB[hɎgp܂B
	 */
	public static final String PAGE_INDEX = "pi";
	
	/**
	 * 1y[Wɕ\s擾邽߂̒萔BHTMLhiddentB[hɎgp܂B
	 */
	public static final String PER_PAGE_ROWS = "ppr";
	
	/**
	 * Oy[WꍇAtrue߂܂B<br>
	 * 
	 * @return Oy[Wꍇtrue
	 */
	public boolean hasPrevious();
	
	/**
	 * y[WꍇAtrue߂܂B<br>
	 * @return y[Wꍇtrue
	 */
	public boolean hasNext();	
	
	/**
	 * ݃y[W̔z擾܂BzɊ܂܂s{@link PageListRow}łB<br>
	 * 
	 * @return ݃y[W̔zB
	 */
	public List currentPage() ;

	/**
	 * y[WɊ܂܂s擾܂B<br>
	 * 
	 * @return y[WɊ܂܂s
	 */
	public int getNextPageRows() ;
	
	/**
	 * s擾܂B<br>
	 * ̍s͎ɂقȂ܂BSy[Wێ̏ꍇASy[W̍s擾܂B<br>
	 * Ŝ̂̌݃y[Ŵ݂ێ̏ꍇA݃y[W̍s擾܂B
	 * @return s
	 */
	public int size() ;
	
	/**
	 * y[WɊ܂܂Ss擾܂B<br>
	 * 
	 * @since 2004/5/27
	 * @return y[WɊ܂܂Ss
	 */
	public int getTotalRows();
	
	/**
	 * w肳ꂽindex{@link PageListRow}擾܂B<br>
	 * 
	 * @param index 擾CfbNX
	 * @return PageListRow
	 */
	public PageListRow get(int index) ;
	
	/**
	 * 1y[WɊ܂ލs擾܂B<br>
	 * 
	 * @return 1y[WɊ܂ލs
	 */
	public int getPerPageRows() ;
	
	/**
	 * y[WɊ܂܂sQƂIteratorIuWFNg擾܂B<br>
	 * ʂ͎ɂقȂ܂BSy[Wێ̏ꍇASy[WQƂIterator擾܂B<br>
	 * Ŝ̂̌݃y[Ŵ݂ێ̏ꍇA݃y[WQƂIterator擾܂B
	 * @return Iterator
	 */
	public Iterator iterator() ;

	/**
	 * y[W擾܂B<br>
	 * 
	 * @return y[W
	 */
	public int getTotalPageCount() ;
	
	/**
	 * ݃y[W̃CfbNX擾܂B<br>
	 * 
	 * @return ݃y[W̃CfbNX
	 */
	public int getCurrentPageIndex() ;

	/**
	 * ꗗ\̃y[WEJE^`悷String擾܂B<br>
	 * ߂l͈{@link IPageListDecorator }̎Ɉˑ܂B<br>
	 * @param pageDecorator
	 * @return ꗗ\̃y[WEJE^`悷String
	 */
	public String drawPageCounter(IPageListDecorator pageDecorator);
	
	/**
	 * ꗗ\̑Oy[Wւ̃N`悷String擾܂B<br>
	 * ߂l͈{@link IPageListDecorator }̎Ɉˑ܂B<br>
	 * @param pageDecorator
	 * @return ꗗ\̑Oy[Wւ̃N`悷String
	 */	
	public String drawPrevious(IPageListDecorator pageDecorator);
	
	/**
	 * ꗗ\̎y[Wւ̃N`悷String擾܂B<br>
	 * ߂l͈{@link IPageListDecorator }̎Ɉˑ܂B<br>
	 * @param pageDecorator
	 * @return ꗗ\̎y[Wւ̃N`悷String
	 */		
	public String drawNext(IPageListDecorator pageDecorator);
	
	/**
	 * ꗗ\̃y[WEJE^`悷String擾܂B<br>
	 * @return ꗗ\̃y[WEJE^`悷String
	 */
	public String drawPageCounter();
	
	/**
	 * ꗗ\̑Oy[Wւ̃N`悷String擾܂B<br>
	 * @return ꗗ\̑Oy[Wւ̃N`悷String
	 */		
	public String drawPrevious();
	
	/**
	 * ꗗ\̎y[Wւ̃N`悷String擾܂B<br>
	 * @return ꗗ\̎y[Wւ̃N`悷String
	 */		
	public String drawNext(); 

	
	public String getHiddenName(String fieldPrefix);
}
	