package wisdomx.ui.render;

import java.util.*;

import wisdomx.ui.object.Checkbox;
import wisdomx.ui.object.IOption;

/**
 * CheckboxIuWFNg̕`NX<br>
 *
 * @author  Takao Kouda
 * @version 1
 */
public class XRCheckbox extends TagHelper {

	
	protected static String checkbox(Checkbox checkbox) {
		StringBuffer sb = new StringBuffer();
		if (checkbox == null) return sb.toString();
				
		for (int i = 0 ; i < checkbox.size() ; i++ ) {
			IOption option = checkbox.get(i);
			sb.append(checkboxInput(checkbox, option, null)).append("\n");
		}
		Checkbox disabled  = checkbox.getDisabledOptions();
		for (int i = 0 ; i < disabled.size() ; i++ ) {
			IOption option = disabled.get(i);
			sb.append(checkboxHidden(checkbox, option));
		}
		return sb.toString();

	}
	protected static String checkboxClass(Checkbox checkbox, String clazz) {
		StringBuffer sb = new StringBuffer();
		if (checkbox == null) return sb.toString();
				
		for (int i = 0 ; i < checkbox.size() ; i++ ) {
			IOption option = checkbox.get(i);
			sb.append(checkboxInput(checkbox, option, clazz)).append("\n");
		}
		Checkbox disabled  = checkbox.getDisabledOptions();
		for (int i = 0 ; i < disabled.size() ; i++ ) {
			IOption option = disabled.get(i);
			sb.append(checkboxHidden(checkbox, option));
		}
		return sb.toString();

	}	
	protected static List checkboxList(Checkbox checkbox) {
		List l = new Vector();
		if (checkbox == null) return l;
		for (int i = 0 ; i < checkbox.size() ; i++ ) {
			IOption option = checkbox.get(i);
			l.add(checkboxInput(checkbox, option, null));
		}
		return l;
	}
	protected static String checkboxDisables(Checkbox checkbox) {
		StringBuffer sb = new StringBuffer();
		if (checkbox == null) return sb.toString();
		Checkbox disabled  = checkbox.getDisabledOptions();
		for (int i = 0 ; i < disabled.size() ; i++ ) {
			IOption option = disabled.get(i);
			sb.append(checkboxHidden(checkbox, option));
		}
		return sb.toString();
	}	
	protected static String selectMultipule(Checkbox checkbox, int size) {
		StringBuffer sb = new StringBuffer("<select");
		sb.append(" name=").append( quote(checkbox.getName()) )
		.append(" multiple=").append(quote("multiple")).append(" size=").append( quote( size  ))
		.append(">\n");
		for (int i = 0 ; i < checkbox.size() ; i++ ) {
			IOption option = checkbox.get(i);
			sb.append("<option id=").append( quote(checkbox.getName() ) );
			sb.append(" value=").append( quote( option.getKey() ));
			if (checkbox.isChecked(option.getKey() )) sb.append(" selected=").append(quote("selected")).append(" ");	/* WA0042*/
			sb.append(">");
			sb.append(option.getValue());
			sb.append("</option>\n");
		}
		sb.append("</select>");
		return sb.toString();
	}
	
	private static String checkboxInput(Checkbox checkbox,  IOption option, String clazz) {
		StringBuffer sb = new StringBuffer();
		sb.append("<input")
		.append(" type=").append( quote( "checkbox" ))
		.append(" name=").append( quote(checkbox.getName()) )
		.append(" value=").append( quote(option.getKey() ));
			
		if (checkbox.isChecked(option.getKey() )) sb.append(" checked=").append(quote("checked")).append(" ");	/* WA0042*/
		if (checkbox.isDisabled(option.getKey() )) sb.append(" disabled=").append(quote("disabled")).append(" ");	/* WA0042*/ 
		sb.append(" />"); /* WA0042*/
		if (clazz != null) {
			sb.append("<span class=").append( quote(clazz) ).append(">");
		}
		sb.append(option.getValue());
		if (clazz != null) {
			sb.append("</span>");
		}		
		return sb.toString();
	}
	private static String checkboxHidden(Checkbox checkbox,  IOption option) {
		StringBuffer sb = new StringBuffer();
		sb.append(Tag.hidden(checkbox.getName(), option.getKey())).append("\n");
		return sb.toString();		
	}
			
}

		