﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace WitchPaper
{
    public partial class InputBox : Form
    {
        public static InputBox instance = new InputBox();
        const string DEF_TITLE = "InputBox";
        const string DEF_MESSAGE = "入力してください";
        const string DEF_VALUE = "";
        private InputBox()
        {
            InitializeComponent();
        }

        public static new string Show()
        {
            return Show(DEF_TITLE, DEF_MESSAGE, DEF_VALUE);
        }

        public static string Show(string title)
        {
            return Show(title, DEF_MESSAGE, DEF_VALUE);
        }

        public static string Show(string title, string message)
        {
            return Show(title, message, DEF_VALUE);
        }

        public static string Show(string title, string message, string defValue)
        {
            instance = new InputBox();
            instance.Text = title;
            instance.label1.Text = message;
            instance.textBox1.Text = defValue;
            if (instance.ShowDialog() == DialogResult.Cancel)
                return "";
            return instance.textBox1.Text;
        }

        private void InputBox_Load(object sender, EventArgs e)
        {

        }
        

        protected override void OnClosing(CancelEventArgs e)
        {
            if (isButton == false)
            {
                this.DialogResult = DialogResult.Cancel;
            }
        }

        private bool isButton = false;
        private void button1_Click(object sender, EventArgs e)
        {
            isButton = true;
            DialogResult = DialogResult.OK;
            this.Hide();
        }

        private void button2_Click(object sender, EventArgs e)
        {
            isButton = true;
            DialogResult = DialogResult.Cancel;
            this.Hide();
        }
    }
}