#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <ctype.h>
#include <stdarg.h>
#include <signal.h>
#include <sys/time.h>
#include <time.h>

#include <uim/uim.h>
#include <uim/uim-helper.h>

#include "ruby.h"

ID id_call;

typedef struct {
	int fd;
} UIM_Helper;

static void rb_uim_helper_send_message(VALUE self, VALUE str)
{
	UIM_Helper *uim_helper;

	Check_Type(str, T_STRING);
	Data_Get_Struct(self, UIM_Helper, uim_helper);
	uim_helper_send_message(uim_helper->fd, StringValuePtr(str));
}

static void rb_uim_helper_get_prop_list(VALUE self)
{
	UIM_Helper *uim_helper;

	Data_Get_Struct(self, UIM_Helper, uim_helper);
	uim_helper_client_get_prop_list();

}

static void rb_uim_helper_read_proc(VALUE self)
{
	UIM_Helper *uim_helper;

	Data_Get_Struct(self, UIM_Helper, uim_helper);
	uim_helper_read_proc(uim_helper->fd);

}

static VALUE rb_uim_helper_get_message(VALUE self)
{
	UIM_Helper *uim_helper;
	char *tmp;

	Data_Get_Struct(self, UIM_Helper, uim_helper);
	tmp = uim_helper_get_message();
	if (tmp == NULL) {
		return Qnil;
	}
	return rb_str_new2(tmp);
}

static void rb_uim_helper_init_client(VALUE self)
{
	UIM_Helper *uim_helper;

	Data_Get_Struct(self, UIM_Helper, uim_helper);

	if (uim_helper->fd == -1) {
		uim_helper->fd =
			uim_helper_init_client_fd(NULL);
	}
}

static VALUE rb_uim_helper_readable(VALUE self)
{
	UIM_Helper *uim_helper;
	Data_Get_Struct(self, UIM_Helper, uim_helper);

	if (uim_helper_fd_readable(uim_helper->fd) != 0) {
		return Qtrue;
	}
	return Qfalse;

}
static VALUE rb_uim_helper_initialize(VALUE self)
{
	VALUE obj;
	UIM_Helper *uim_helper;

	uim_helper = malloc(sizeof(UIM_Helper));
	memset(uim_helper, 0, sizeof(*uim_helper));
	uim_helper->fd = -1;

	obj = Data_Wrap_Struct(self, NULL, NULL, uim_helper);

	return obj;
}
void Init_uim(void) {
	VALUE rb_UIM;
	VALUE rb_UIM_Helper;

	id_call = rb_intern("call");

	rb_UIM = rb_define_class("UIM", rb_cObject);
	rb_UIM_Helper = rb_define_class_under(rb_UIM, "Helper", rb_cObject);
	rb_define_singleton_method(rb_UIM_Helper, "new",  rb_uim_helper_initialize, 0);
	rb_define_method(rb_UIM_Helper, "init_client", 
			 RUBY_METHOD_FUNC(rb_uim_helper_init_client), 0);
	rb_define_method(rb_UIM_Helper, "get_prop_list", 
			 RUBY_METHOD_FUNC(rb_uim_helper_get_prop_list), 0);
	rb_define_method(rb_UIM_Helper, "readable", 
			 RUBY_METHOD_FUNC(rb_uim_helper_readable), 0);
	rb_define_method(rb_UIM_Helper, "read_proc", 
			 RUBY_METHOD_FUNC(rb_uim_helper_read_proc), 0);
	rb_define_method(rb_UIM_Helper, "get_message", 
			 RUBY_METHOD_FUNC(rb_uim_helper_get_message), 0);
	rb_define_method(rb_UIM_Helper, "send_message", 
			 RUBY_METHOD_FUNC(rb_uim_helper_send_message), 1);
	
}
