/*
  $Id: uim.c,v 1.10 2005/12/11 13:54:06 masahino Exp $
 */
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <ctype.h>
#include <stdarg.h>
#include <signal.h>
#include <sys/time.h>
#include <time.h>

#include <locale.h>

#include <uim/uim.h>
#include <uim/uim-helper.h>

#include <ruby.h>

ID id_call;

typedef struct {
	int fd;
} UIM_Helper;

typedef struct {
	uim_context uc;
} UIM_Context;

#define WHOLE_DESKTOP 0
#define THIS_TEXT_AREA_ONLY 1
#define THIS_APPLICATION_ONLY 2

#define UIM_VERSION "0.1.1"

static void rb_uim_helper_send_message(VALUE self, VALUE str)
{
	UIM_Helper *uim_helper;

	Check_Type(str, T_STRING);
	Data_Get_Struct(self, UIM_Helper, uim_helper);
	uim_helper_send_message(uim_helper->fd, StringValuePtr(str));
}

static void rb_uim_helper_get_prop_list(VALUE self)
{
	UIM_Helper *uim_helper;

	Data_Get_Struct(self, UIM_Helper, uim_helper);
	uim_helper_client_get_prop_list();

}

static void rb_uim_helper_read_proc(VALUE self)
{
	UIM_Helper *uim_helper;

	Data_Get_Struct(self, UIM_Helper, uim_helper);
	uim_helper_read_proc(uim_helper->fd);

}

static VALUE rb_uim_helper_get_message(VALUE self)
{
	UIM_Helper *uim_helper;
	char *tmp;

	Data_Get_Struct(self, UIM_Helper, uim_helper);
	tmp = uim_helper_get_message();
	if (tmp == NULL) {
		return Qnil;
	}
	return rb_str_new2(tmp);
}

static void rb_uim_helper_init_client(VALUE self)
{
	UIM_Helper *uim_helper;

	Data_Get_Struct(self, UIM_Helper, uim_helper);

	if (uim_helper->fd == -1) {
		uim_helper->fd =
			uim_helper_init_client_fd(NULL);
	}
}

static void rb_uim_helper_close_client(VALUE self)
{
	UIM_Helper *uim_helper;

	Data_Get_Struct(self, UIM_Helper, uim_helper);

	uim_helper_close_client_fd(uim_helper->fd);
	uim_helper->fd = -1;
}

static VALUE rb_uim_helper_get_pathname(VALUE self)
{
	UIM_Helper *uim_helper;
	char *tmp;
	VALUE obj;

	Data_Get_Struct(self, UIM_Helper, uim_helper);

	tmp = uim_helper_get_pathname();
	obj = rb_str_new2(tmp);
	return obj;
}

static VALUE rb_uim_helper_check_connection(VALUE self)
{
	UIM_Helper *uim_helper;

	Data_Get_Struct(self, UIM_Helper, uim_helper);

	return INT2FIX(uim_helper_check_connection_fd(uim_helper->fd));
}

static VALUE rb_uim_helper_is_setugid(VALUE self)
{
	UIM_Helper *uim_helper;
	uim_bool ret;

	Data_Get_Struct(self, UIM_Helper, uim_helper);

	ret = uim_helper_is_setugid();
	return (ret == UIM_FALSE)? Qfalse:Qtrue;
}

static VALUE rb_uim_helper_str_terminated(VALUE self, VALUE str)
{
	UIM_Helper *helper;
	Check_Type(str, T_STRING);

	if (uim_helper_str_terminated(StringValuePtr(str)) == 1) {
		return Qtrue;
	} else {
		return Qfalse;
	}
}

static VALUE rb_uim_helper_readable(VALUE self)
{
	UIM_Helper *uim_helper;
	Data_Get_Struct(self, UIM_Helper, uim_helper);

	if (uim_helper_fd_readable(uim_helper->fd) != 0) {
		return Qtrue;
	}
	return Qfalse;

}

static VALUE rb_uim_helper_writable(VALUE self)
{
	UIM_Helper *uim_helper;
	Data_Get_Struct(self, UIM_Helper, uim_helper);

	if (uim_helper_fd_writable(uim_helper->fd) != 0) {
		return Qtrue;
	}
	return Qfalse;

}

static VALUE rb_uim_helper_initialize(VALUE self)
{
	VALUE obj;
	UIM_Helper *uim_helper;

	uim_helper = malloc(sizeof(UIM_Helper));
	memset(uim_helper, 0, sizeof(*uim_helper));

	uim_init();

	uim_helper->fd =
		uim_helper_init_client_fd(NULL);

	obj = Data_Wrap_Struct(self, NULL, NULL, uim_helper);

	return obj;
}

static void rb_uim_helper_im_list_get(VALUE self)
{
	UIM_Helper *uim_helper;

	Data_Get_Struct(self, UIM_Helper, uim_helper);
	uim_helper_send_message(uim_helper->fd, "im_list_get\n");
	
}

static void rb_uim_helper_prop_label_get(VALUE self)
{
	UIM_Helper *uim_helper;

	Data_Get_Struct(self, UIM_Helper, uim_helper);
	uim_helper_send_message(uim_helper->fd, "prop_label_get\n");
	
}

static void rb_uim_helper_prop_activate(VALUE self, VALUE str)
{
	UIM_Helper *uim_helper;
	VALUE strobj;

	Check_Type(str, T_STRING);
	Data_Get_Struct(self, UIM_Helper, uim_helper);
	strobj = rb_str_new2("prop_activate\n");
	strobj = rb_str_plus(strobj, str);
	rb_str_cat2(strobj, "\n");
	uim_helper_send_message(uim_helper->fd, StringValuePtr(strobj));
}

static void rb_uim_helper_im_change(VALUE self, VALUE type, VALUE im)
{
	UIM_Helper *uim_helper;
	VALUE strobj;

	Check_Type(type, T_FIXNUM);
	Check_Type(im, T_STRING);
	Data_Get_Struct(self, UIM_Helper, uim_helper);
	strobj = rb_str_new2("im_change_");
	switch(FIX2INT(type)) {
	case WHOLE_DESKTOP:
		rb_str_cat2(strobj, "whole_desktop\n");
		break;
	case THIS_TEXT_AREA_ONLY:
		rb_str_cat2(strobj, "this_text_area_only\n");
		break;
	case THIS_APPLICATION_ONLY:
		rb_str_cat2(strobj, "this_applicatino_only\n");
		break;
	default:
		rb_raise(rb_eRuntimeError, "unknown type");
		break;
	}
	strobj = rb_str_plus(strobj, im);
	rb_str_cat2(strobj, "\n");
	printf ("strobj = %s\n", StringValuePtr(strobj));
//	uim_helper_send_message(uim_helper->fd, StringValuePtr(strobj));
}

static void rb_uim_helper_read(int argc, VALUE *argv, VALUE self)
{
	UIM_Helper *helper;
	VALUE vtimeout;
	char *message;
	VALUE obj;
	int timeout;
	
	Data_Get_Struct(self, UIM_Helper, helper);
	if (rb_scan_args(argc, argv, "01", &vtimeout) == 0) {
		timeout = 0;
	} else {
		Check_Type(vtimeout, T_FIXNUM);
		timeout = FIX2INT(vtimeout);
	}
	/* TODO: タイムアウト処理をきちんと */
	while (uim_helper_fd_readable(helper->fd) <=0) {
		usleep(10000); /* 10ms */
		if (timeout > 0) {
			timeout -= 10;
			if (timeout <= 0) {
				return;
			}
		}
	}
	uim_helper_read_proc(helper->fd);
	while (1) {
		message = uim_helper_get_message();
		if (message == NULL) {
			break;
		}
//		printf ("%s\n", message);
		obj = rb_str_new2(message);
		rb_yield(obj);
	}
}

static VALUE rb_uim_helper_get_fd(VALUE self)
{
	UIM_Helper *uim_helper;

	Data_Get_Struct(self, UIM_Helper, uim_helper);
	return INT2FIX(uim_helper->fd);
	
}


/* UIM::Context */
static void rb_uim_commit_cb(void *ptr, const char *commit_str)
{
}

static VALUE rb_uim_context_initialize(int argc, VALUE *argv, VALUE self)
{
	UIM_Context *ruc;
	char *charset;
	const char *im_name;
	VALUE vcharset, vim_name, obj;

	if (uim_init() == -1) {
		rb_raise(rb_eRuntimeError, "uim_init error");
	}
	rb_scan_args(argc, argv, "02", &vcharset, &vim_name);
	if (vcharset == Qnil) {
		charset = strdup("UTF-8");
	} else {
		charset = StringValuePtr(vcharset);
	}
	if (vim_name == Qnil) {
		im_name = uim_get_default_im_name("");
	} else {
		im_name = StringValuePtr(vim_name);
	}

	ruc = malloc(sizeof(UIM_Context));
	ruc->uc = uim_create_context(NULL, charset, NULL, im_name,
				uim_iconv, rb_uim_commit_cb);
	obj = Data_Wrap_Struct(self, -1, -1, ruc);
	return obj;
}

static void rb_uim_context_client_focus_in(VALUE self)
{
	UIM_Context *ruc;

	Data_Get_Struct(self, UIM_Context, ruc);
	
	uim_helper_client_focus_in(ruc->uc);
}

static void rb_uim_context_client_focus_out(VALUE self)
{
	UIM_Context *ruc;

	Data_Get_Struct(self, UIM_Context, ruc);
	
	uim_helper_client_focus_out(ruc->uc);
}

void Init_uim(void) {
	VALUE rb_UIM;
	VALUE rb_UIM_Helper;
	VALUE rb_UIM_Context;

	id_call = rb_intern("call");

	rb_UIM = rb_define_class("UIM", rb_cObject);

	/* UIM::Context */
	rb_UIM_Context = rb_define_class_under(rb_UIM, "Context", rb_cObject);
	rb_define_singleton_method(rb_UIM_Context, "new", rb_uim_context_initialize, -1);
	rb_define_method(rb_UIM_Context, "client_focus_in", 
			 RUBY_METHOD_FUNC(rb_uim_context_client_focus_in), 0);
	rb_define_method(rb_UIM_Context, "client_focus_out", 
			 RUBY_METHOD_FUNC(rb_uim_context_client_focus_out), 0);

	/* UIM::Helper */
	rb_UIM_Helper = rb_define_class_under(rb_UIM, "Helper", rb_cObject);
	rb_define_singleton_method(rb_UIM_Helper, "new",  rb_uim_helper_initialize, 0);
	rb_define_method(rb_UIM_Helper, "init_client", 
			 RUBY_METHOD_FUNC(rb_uim_helper_init_client), 0);
	rb_define_method(rb_UIM_Helper, "close_client", 
			 RUBY_METHOD_FUNC(rb_uim_helper_close_client), 0);
	rb_define_method(rb_UIM_Helper, "get_prop_list", 
			 RUBY_METHOD_FUNC(rb_uim_helper_get_prop_list), 0);
	rb_define_method(rb_UIM_Helper, "readable?", 
			 RUBY_METHOD_FUNC(rb_uim_helper_readable), 0);
	rb_define_method(rb_UIM_Helper, "writable?", 
			 RUBY_METHOD_FUNC(rb_uim_helper_writable), 0);
	rb_define_method(rb_UIM_Helper, "read_proc", 
			 RUBY_METHOD_FUNC(rb_uim_helper_read_proc), 0);
	rb_define_method(rb_UIM_Helper, "get_message", 
			 RUBY_METHOD_FUNC(rb_uim_helper_get_message), 0);
	rb_define_method(rb_UIM_Helper, "send_message", 
			 RUBY_METHOD_FUNC(rb_uim_helper_send_message), 1);
	rb_define_method(rb_UIM_Helper, "pathname", 
			 RUBY_METHOD_FUNC(rb_uim_helper_get_pathname), 0);
	rb_define_method(rb_UIM_Helper, "check_connection", 
			 RUBY_METHOD_FUNC(rb_uim_helper_check_connection), 0);
	rb_define_method(rb_UIM_Helper, "is_setugid?", 
			 RUBY_METHOD_FUNC(rb_uim_helper_is_setugid), 0);
	rb_define_singleton_method(rb_UIM_Helper, "str_terminated?",
			 RUBY_METHOD_FUNC(rb_uim_helper_str_terminated), 1);

	
	/* my function */
	rb_define_method(rb_UIM_Helper, "prop_label_get",
			 RUBY_METHOD_FUNC(rb_uim_helper_prop_label_get), 0);
	rb_define_method(rb_UIM_Helper, "im_list_get",
			 RUBY_METHOD_FUNC(rb_uim_helper_im_list_get), 0);
	rb_define_method(rb_UIM_Helper, "prop_activate",
			 RUBY_METHOD_FUNC(rb_uim_helper_prop_activate), 1);
	rb_define_method(rb_UIM_Helper, "im_change",
			 RUBY_METHOD_FUNC(rb_uim_helper_im_change), 2);
	rb_define_method(rb_UIM_Helper, "read",
			 RUBY_METHOD_FUNC(rb_uim_helper_read), -1);
	rb_define_method(rb_UIM_Helper, "fd",
			 RUBY_METHOD_FUNC(rb_uim_helper_get_fd), 0);

	rb_define_const(rb_UIM_Helper, "WHOLE_DESKTOP",
			INT2FIX(WHOLE_DESKTOP));
	rb_define_const(rb_UIM_Helper, "THIS_TEXT_AREA_ONLY",
			INT2FIX(THIS_TEXT_AREA_ONLY));
	rb_define_const(rb_UIM_Helper, "THIS_APPLICATION_ONLY",
			INT2FIX(THIS_APPLICATION_ONLY));

	rb_define_const(rb_UIM, "VERSION",
			rb_obj_freeze(rb_str_new2(UIM_VERSION)));

}
