! i64_module.F  -*-f90-*-
! Time-stamp: <2007-11-14 15:58:48 takeshi>
! Author:     NISHIMATSU Takeshi <t-nissie{at}imr.tohoku.ac.jp>
! Reference:  Haruhiko Okumura: C-gengo niyoru saishin algorithm jiten (New algorithm
!   handbook in C language) (Gijyutsu-hyouron-sha, Tokyo, 1991) isqrt.c [in Japanese]
!!
module i64_module
  ! Use this module to express 8 byte (64 bit) constant integer
  ! like the way: 216_i64.
  integer,parameter :: i64=selected_int_kind(18)

contains
  integer*8 function i64sqrt(x)
    implicit none
    integer*8 x, s
    if (x.lt.0_i64) then
       stop 'i64sqrt: the argument is negative'
    else if (x.eq.0_i64) then
       i64sqrt = 0_i64
       return
    else
       s = 1_i64
       i64sqrt = x
       do while (s < i64sqrt)
          s = ishft(s,1_i64)
          i64sqrt = ishft(i64sqrt,-1_i64)
       end do
       do
          i64sqrt = s
          s = ishft((x / s + s),-1_i64)
          if (s >= i64sqrt) return
       end do
    end if
  end function i64sqrt

end module i64_module
