/*
 * Decompiled with CFR 0.152.
 */
package woolpack.action;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import ognl.MethodFailedException;
import woolpack.action.ActionDef;
import woolpack.action.ActionResult;
import woolpack.action.ForwardDef;
import woolpack.action.ForwardDefNotFoundException;
import woolpack.utils.UtilsConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionInvoker {
    private final Map<String, ActionDef> actionDefMap;
    private final Iterable<ForwardDef> forwardDefIterable;

    public ActionInvoker(Map<String, ActionDef> actionDefMap, Iterable<ForwardDef> forwardDefIterable) {
        actionDefMap.getClass();
        forwardDefIterable.getClass();
        this.actionDefMap = actionDefMap;
        this.forwardDefIterable = forwardDefIterable;
    }

    public ActionInvoker(Map<String, ActionDef> actionDefMap, ForwardDef ... forwardDefIterable) {
        this(actionDefMap, (Iterable<ForwardDef>)Arrays.asList(forwardDefIterable));
    }

    public ActionResult invoke(Object root, String id, Map inputMap) {
        ActionDef actionDef = this.actionDefMap.get(id);
        actionDef.getClass();
        try {
            actionDef.getComponentOGE().setValues(root, inputMap);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            try {
                Object result = actionDef.getMethodOGE().invoke(root);
                return ActionInvoker.findId(actionDef.getForwardDefIterable(), result);
            }
            catch (MethodFailedException e) {
                return ActionInvoker.findId(actionDef.getForwardDefIterable(), e.getReason());
            }
        }
        catch (ForwardDefNotFoundException e) {
            return ActionInvoker.findId(this.forwardDefIterable, e.getReturnedObject());
        }
    }

    public static ActionResult findId(Iterable<ForwardDef> iterable, Object aReturnedObject) throws ForwardDefNotFoundException {
        for (ForwardDef forwardDef : iterable) {
            if (!forwardDef.getMatchable().matches(aReturnedObject)) continue;
            return new ActionResult(forwardDef, aReturnedObject);
        }
        throw new ForwardDefNotFoundException(aReturnedObject);
    }

    public Map<String, ActionDef> getActionDefMap() {
        return Collections.unmodifiableMap(this.actionDefMap);
    }

    public Iterable<ForwardDef> getForwardDefIterable() {
        return UtilsConstants.unmodifiableIterable(this.forwardDefIterable);
    }
}

