/*
 * Decompiled with CFR 0.152.
 */
package woolpack.dom;

import java.util.LinkedHashMap;
import java.util.Map;
import org.w3c.dom.Node;
import woolpack.dom.DomContext;
import woolpack.dom.DomExpression;

public class CacheNode
implements DomExpression {
    private final DomExpression nodeMaker;
    private final Map<Object, Node> cacheMap;

    public CacheNode(final int maxEntries, DomExpression nodeMaker) {
        nodeMaker.getClass();
        this.nodeMaker = nodeMaker;
        this.cacheMap = maxEntries > 0 ? new LinkedHashMap<Object, Node>(){
            private static final long serialVersionUID = 1L;

            @Override
            protected boolean removeEldestEntry(Map.Entry eldest) {
                return this.size() > maxEntries;
            }
        } : null;
    }

    public void interpret(DomContext context) {
        if (this.cacheMap == null) {
            this.nodeMaker.interpret(context);
        } else {
            Object key = this.getCacheKey(context.getId());
            Node node = this.cacheMap.get(key);
            if (node == null) {
                this.nodeMaker.interpret(context);
                node = context.getNode();
                this.cacheMap.put(key, node);
            }
            context.setNode(node.cloneNode(true));
        }
    }

    public Object getCacheKey(String id) {
        return id;
    }
}

