/*
 * Decompiled with CFR 0.152.
 */
package woolpack.locale;

import java.io.IOException;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import woolpack.locale.LocaleConstants;
import woolpack.validator.ValidatorConstants;
import woolpack.validator.ValidatorContext;
import woolpack.validator.ValidatorExpression;
import woolpack.validator.ValidatorExpressionAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BranchByLocaleValidator
extends ValidatorExpressionAdapter {
    private final Map<Locale, ValidatorExpression> map;
    private final ThreadLocal<Locale> threadLocal;

    public BranchByLocaleValidator(Map<Locale, ValidatorExpression> map, ThreadLocal<Locale> threadLocal) {
        map.getClass();
        threadLocal.getClass();
        this.map = map;
        this.threadLocal = threadLocal;
    }

    @Override
    public boolean interpret(ValidatorContext context) {
        Locale l0 = this.threadLocal.get();
        Locale l1 = LocaleConstants.search((Collection<Locale>)this.map.keySet(), l0);
        return this.map.get(l1).interpret(context);
    }

    @Override
    public void appendArgumentTo(Appendable sb) throws IOException {
        ValidatorConstants.appendTo(sb, this.map);
    }

    @Override
    public void addMessageTo(Collection<String> messageCollection) {
        for (Locale key : this.map.keySet()) {
            ValidatorExpression expression = this.map.get(key);
            expression.addMessageTo(messageCollection);
        }
    }
}

